/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.transport;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.server.ServerWebExchange;

public final class SseEventFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(SseEventFormatter.class);

    private SseEventFormatter() {
    }

    public static DataBuffer formatEvent(ServerSentEvent<?> event, ServerWebExchange exchange) {
        StringBuilder sseData = new StringBuilder();
        if (Objects.nonNull(event.event())) {
            sseData.append("event: ").append(event.event()).append("\n");
        }
        if (Objects.nonNull(event.data())) {
            sseData.append("data: ").append(event.data()).append("\n");
        }
        if (Objects.nonNull(event.id())) {
            sseData.append("id: ").append(event.id()).append("\n");
        }
        if (Objects.nonNull(event.retry())) {
            sseData.append("retry: ").append(event.retry()).append("\n");
        }
        sseData.append("\n");
        String formattedEvent = sseData.toString();
        LOG.debug("Formatted SSE event: {}", (Object)formattedEvent.trim());
        return exchange.getResponse().bufferFactory().wrap(formattedEvent.getBytes());
    }

    public static DataBuffer formatComment(String comment, ServerWebExchange exchange) {
        String formattedComment = ": " + comment + "\n\n";
        LOG.debug("Formatted SSE comment: {}", (Object)formattedComment.trim());
        return exchange.getResponse().bufferFactory().wrap(formattedComment.getBytes());
    }
}

