/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import jakarta.annotation.PreDestroy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.event.instance.InstanceInfoReportEvent;
import org.apache.shenyu.admin.model.vo.InstanceDataVisualLineVO;
import org.apache.shenyu.admin.model.vo.InstanceDataVisualVO;
import org.apache.shenyu.admin.model.vo.InstanceInfoVO;
import org.apache.shenyu.admin.service.InstanceInfoService;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.enums.InstanceStatusEnum;
import org.apache.shenyu.register.common.dto.InstanceBeatInfoDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class InstanceCheckService {
    private static final int MAX_HISTORY_SIZE = 20;
    private static final Logger LOG = LoggerFactory.getLogger(InstanceCheckService.class);
    private ScheduledThreadPoolExecutor executor;
    private final int scheduledTime;
    private ConcurrentHashMap<String, InstanceInfoVO> instanceHealthBeatInfo = new ConcurrentHashMap();
    private long instanceHeartBeatTimeOut = 20000L;
    private long deleteTimeout = 60000L;
    private InstanceInfoService instanceInfoService;
    private final Map<Integer, Deque<Long>> stateHistoryMap;

    public InstanceCheckService(InstanceInfoService instanceInfoService) {
        this.scheduledTime = 10;
        this.instanceInfoService = instanceInfoService;
        this.stateHistoryMap = new ConcurrentHashMap<Integer, Deque<Long>>();
    }

    public void setup() {
        this.fetchInstanceData();
        this.executor = new ScheduledThreadPoolExecutor(1, ShenyuThreadFactory.create((String)"scheduled-instance-heartbeat-task", (boolean)false));
        this.executor.scheduleWithFixedDelay(this::scheduled, 30L, this.scheduledTime, TimeUnit.SECONDS);
        this.executor.scheduleWithFixedDelay(this::syncDB, 40L, this.scheduledTime, TimeUnit.SECONDS);
    }

    public void fetchInstanceData() {
        List<InstanceInfoVO> list = this.instanceInfoService.list();
        list.forEach(instanceInfoVO -> {
            String instanceKey = this.getInstanceKey((InstanceInfoVO)instanceInfoVO);
            this.instanceHealthBeatInfo.put(instanceKey, (InstanceInfoVO)instanceInfoVO);
        });
    }

    public String getInstanceKey(InstanceInfoVO instanceInfoVO) {
        return instanceInfoVO.getInstanceIp() + ":" + instanceInfoVO.getInstancePort() + "@" + instanceInfoVO.getInstanceType() + "#" + instanceInfoVO.getNamespaceId();
    }

    public String getInstanceKey(InstanceBeatInfoDTO instanceBeatInfoDTO) {
        return instanceBeatInfoDTO.getInstanceIp() + ":" + instanceBeatInfoDTO.getInstancePort() + "@" + instanceBeatInfoDTO.getInstanceType() + "#" + instanceBeatInfoDTO.getNamespaceId();
    }

    public InstanceInfoVO getInstanceHealthBeatInfo(InstanceBeatInfoDTO instanceBeatInfoDTO) {
        return this.instanceHealthBeatInfo.get(this.getInstanceKey(instanceBeatInfoDTO));
    }

    public InstanceInfoVO getInstanceHealthBeatInfo(String instanceKey) {
        return this.instanceHealthBeatInfo.get(instanceKey);
    }

    public void handleBeatInfo(InstanceBeatInfoDTO instanceBeatInfoDTO) {
        String instanceKey = this.getInstanceKey(instanceBeatInfoDTO);
        if (this.instanceHealthBeatInfo.containsKey(instanceKey)) {
            InstanceInfoVO instanceInfoVO = this.instanceHealthBeatInfo.get(instanceKey);
            instanceInfoVO.setLastHeartBeatTime(System.currentTimeMillis());
        } else {
            InstanceInfoVO instanceInfoVO = new InstanceInfoVO();
            instanceInfoVO.setInstanceIp(instanceBeatInfoDTO.getInstanceIp());
            instanceInfoVO.setInstanceState(1);
            instanceInfoVO.setInstanceInfo(instanceBeatInfoDTO.getInstanceInfo());
            instanceInfoVO.setInstanceType(instanceBeatInfoDTO.getInstanceType());
            instanceInfoVO.setLastHeartBeatTime(System.currentTimeMillis());
            instanceInfoVO.setInstancePort(instanceBeatInfoDTO.getInstancePort());
            instanceInfoVO.setNamespaceId(instanceBeatInfoDTO.getNamespaceId());
            instanceInfoVO.setLastHeartBeatTime(System.currentTimeMillis());
            this.instanceHealthBeatInfo.put(instanceKey, instanceInfoVO);
        }
    }

    private void scheduled() {
        try {
            this.doCheck();
        }
        catch (Exception e) {
            LOG.error("upstream scheduled check error", (Throwable)e);
        }
    }

    private void doCheck() {
        this.instanceHealthBeatInfo.values().forEach(instance -> {
            if (System.currentTimeMillis() - instance.getLastHeartBeatTime() > this.instanceHeartBeatTimeOut) {
                if (InstanceStatusEnum.ONLINE.getCode() == instance.getInstanceState()) {
                    LOG.info("[instanceHealthInfo]namespace:{},type:{},Ip:{},Port:{} offline!", new Object[]{instance.getNamespaceId(), instance.getInstanceType(), instance.getInstanceIp(), instance.getInstancePort()});
                    instance.setInstanceState(InstanceStatusEnum.OFFLINE.getCode());
                }
            } else {
                LOG.info("[instanceHealthInfo]namespace:{},type:{},Ip:{},Port:{} online!", new Object[]{instance.getNamespaceId(), instance.getInstanceType(), instance.getInstanceIp(), instance.getInstancePort()});
                instance.setInstanceState(InstanceStatusEnum.ONLINE.getCode());
            }
            if (System.currentTimeMillis() - instance.getLastHeartBeatTime() > this.deleteTimeout && InstanceStatusEnum.OFFLINE.getCode() == instance.getInstanceState()) {
                LOG.info("[instanceHealthInfo]namespace:{},type:{},Ip:{},Port:{} deleted!", new Object[]{instance.getNamespaceId(), instance.getInstanceType(), instance.getInstanceIp(), instance.getInstancePort()});
                instance.setInstanceState(InstanceStatusEnum.DELETED.getCode());
            }
            this.collectStateData();
        });
    }

    public void syncDB() {
        this.instanceHealthBeatInfo.values().forEach(vo -> this.instanceInfoService.createOrUpdate((InstanceInfoVO)vo));
    }

    @PreDestroy
    public void close() {
        this.syncDB();
        this.instanceHealthBeatInfo.clear();
        this.executor.shutdown();
    }

    @EventListener(value={InstanceInfoReportEvent.class})
    public void onInstanceInfoReport(InstanceInfoReportEvent event) {
        InstanceBeatInfoDTO instanceBeatInfoDTO = this.buildInstanceInfoDTO(event);
        this.handleBeatInfo(instanceBeatInfoDTO);
    }

    private InstanceBeatInfoDTO buildInstanceInfoDTO(InstanceInfoReportEvent instanceInfoRegisterDTO) {
        InstanceBeatInfoDTO instanceInfoDTO = new InstanceBeatInfoDTO();
        instanceInfoDTO.setInstanceIp(instanceInfoRegisterDTO.getInstanceIp());
        instanceInfoDTO.setInstancePort(instanceInfoRegisterDTO.getInstancePort());
        instanceInfoDTO.setInstanceType(instanceInfoRegisterDTO.getInstanceType());
        instanceInfoDTO.setInstanceInfo(instanceInfoRegisterDTO.getInstanceInfo());
        instanceInfoDTO.setNamespaceId(instanceInfoRegisterDTO.getNamespaceId());
        return instanceInfoDTO;
    }

    private void collectStateData() {
        if (!CollectionUtils.isEmpty(this.instanceHealthBeatInfo)) {
            Map<Integer, Long> pieData = this.instanceHealthBeatInfo.values().stream().collect(Collectors.groupingBy(InstanceInfoVO::getInstanceState, Collectors.counting()));
            this.updateStateHistory(pieData);
        }
    }

    public InstanceDataVisualVO getInstanceDataVisual(String namespaceId) {
        InstanceDataVisualVO instanceDataVisualVO = new InstanceDataVisualVO();
        List<InstanceInfoVO> instanceInfoVOS = this.instanceHealthBeatInfo.values().stream().toList();
        if (StringUtils.isNotBlank((CharSequence)namespaceId)) {
            instanceInfoVOS = instanceInfoVOS.stream().filter(vo -> namespaceId.equals(vo.getNamespaceId())).collect(Collectors.toList());
        }
        Map<Integer, Long> pieData = instanceInfoVOS.stream().collect(Collectors.groupingBy(InstanceInfoVO::getInstanceState, Collectors.counting()));
        ArrayList<InstanceDataVisualLineVO> lineList = new ArrayList<InstanceDataVisualLineVO>();
        for (Integer state : Arrays.asList(0, 1, 2)) {
            Deque queue = this.stateHistoryMap.getOrDefault(state, new ArrayDeque(20));
            ArrayList<Long> data = new ArrayList<Long>(queue);
            while (data.size() < 20) {
                data.add(0, 0L);
            }
            InstanceDataVisualLineVO dto = new InstanceDataVisualLineVO(InstanceStatusEnum.getNameByCode((int)state), data);
            lineList.add(dto);
        }
        List<InstanceDataVisualVO.Entry> pieDataList = pieData.entrySet().stream().map(entry -> {
            Integer stateCode = (Integer)entry.getKey();
            String stateName = InstanceStatusEnum.getNameByCode((int)stateCode);
            return new InstanceDataVisualVO.Entry(stateName, (Long)entry.getValue());
        }).collect(Collectors.toList());
        instanceDataVisualVO.setPieData(pieDataList);
        instanceDataVisualVO.setLineData(lineList);
        return instanceDataVisualVO;
    }

    private void updateStateHistory(Map<Integer, Long> currentData) {
        this.ensureStateQueues();
        for (Integer state : Arrays.asList(0, 1, 2)) {
            Long count = currentData.getOrDefault(state, 0L);
            Deque<Long> queue = this.stateHistoryMap.get(state);
            queue.addLast(count);
            while (queue.size() > 20) {
                queue.removeFirst();
            }
        }
    }

    private void ensureStateQueues() {
        for (Integer state : Arrays.asList(0, 1, 2)) {
            this.stateHistoryMap.putIfAbsent(state, new ConcurrentLinkedDeque());
        }
    }
}

