/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.SnowballLanguage;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SnowballTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final SnowballLanguage language;
    public static final JsonpDeserializer<SnowballTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnowballTokenFilter::setupSnowballTokenFilterDeserializer);

    private SnowballTokenFilter(Builder builder) {
        super(builder);
        this.language = ApiTypeHelper.requireNonNull(builder.language, this, "language");
    }

    public static SnowballTokenFilter of(Function<Builder, ObjectBuilder<SnowballTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Snowball;
    }

    public final SnowballLanguage language() {
        return this.language;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "snowball");
        super.serializeInternal(generator, mapper);
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
    }

    protected static void setupSnowballTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::language, SnowballLanguage._DESERIALIZER, "language");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SnowballTokenFilter> {
        private SnowballLanguage language;

        public final Builder language(SnowballLanguage value) {
            this.language = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnowballTokenFilter build() {
            this._checkSingleUse();
            return new SnowballTokenFilter(this);
        }
    }
}

