/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DiscoveryNode;
import co.elastic.clients.elasticsearch.ml.TrainedModelAssignmentRoutingTable;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelDeploymentNodesStats
implements JsonpSerializable {
    private final double averageInferenceTimeMs;
    private final int errorCount;
    private final int inferenceCount;
    private final long lastAccess;
    private final DiscoveryNode node;
    private final int numberOfAllocations;
    private final int numberOfPendingRequests;
    private final int rejectionExecutionCount;
    private final TrainedModelAssignmentRoutingTable routingState;
    private final long startTime;
    private final int threadsPerAllocation;
    private final int timeoutCount;
    public static final JsonpDeserializer<TrainedModelDeploymentNodesStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelDeploymentNodesStats::setupTrainedModelDeploymentNodesStatsDeserializer);

    private TrainedModelDeploymentNodesStats(Builder builder) {
        this.averageInferenceTimeMs = ApiTypeHelper.requireNonNull(builder.averageInferenceTimeMs, this, "averageInferenceTimeMs");
        this.errorCount = ApiTypeHelper.requireNonNull(builder.errorCount, this, "errorCount");
        this.inferenceCount = ApiTypeHelper.requireNonNull(builder.inferenceCount, this, "inferenceCount");
        this.lastAccess = ApiTypeHelper.requireNonNull(builder.lastAccess, this, "lastAccess");
        this.node = ApiTypeHelper.requireNonNull(builder.node, this, "node");
        this.numberOfAllocations = ApiTypeHelper.requireNonNull(builder.numberOfAllocations, this, "numberOfAllocations");
        this.numberOfPendingRequests = ApiTypeHelper.requireNonNull(builder.numberOfPendingRequests, this, "numberOfPendingRequests");
        this.rejectionExecutionCount = ApiTypeHelper.requireNonNull(builder.rejectionExecutionCount, this, "rejectionExecutionCount");
        this.routingState = ApiTypeHelper.requireNonNull(builder.routingState, this, "routingState");
        this.startTime = ApiTypeHelper.requireNonNull(builder.startTime, this, "startTime");
        this.threadsPerAllocation = ApiTypeHelper.requireNonNull(builder.threadsPerAllocation, this, "threadsPerAllocation");
        this.timeoutCount = ApiTypeHelper.requireNonNull(builder.timeoutCount, this, "timeoutCount");
    }

    public static TrainedModelDeploymentNodesStats of(Function<Builder, ObjectBuilder<TrainedModelDeploymentNodesStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double averageInferenceTimeMs() {
        return this.averageInferenceTimeMs;
    }

    public final int errorCount() {
        return this.errorCount;
    }

    public final int inferenceCount() {
        return this.inferenceCount;
    }

    public final long lastAccess() {
        return this.lastAccess;
    }

    public final DiscoveryNode node() {
        return this.node;
    }

    public final int numberOfAllocations() {
        return this.numberOfAllocations;
    }

    public final int numberOfPendingRequests() {
        return this.numberOfPendingRequests;
    }

    public final int rejectionExecutionCount() {
        return this.rejectionExecutionCount;
    }

    public final TrainedModelAssignmentRoutingTable routingState() {
        return this.routingState;
    }

    public final long startTime() {
        return this.startTime;
    }

    public final int threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    public final int timeoutCount() {
        return this.timeoutCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("average_inference_time_ms");
        generator.write(this.averageInferenceTimeMs);
        generator.writeKey("error_count");
        generator.write(this.errorCount);
        generator.writeKey("inference_count");
        generator.write(this.inferenceCount);
        generator.writeKey("last_access");
        generator.write(this.lastAccess);
        generator.writeKey("node");
        this.node.serialize(generator, mapper);
        generator.writeKey("number_of_allocations");
        generator.write(this.numberOfAllocations);
        generator.writeKey("number_of_pending_requests");
        generator.write(this.numberOfPendingRequests);
        generator.writeKey("rejection_execution_count");
        generator.write(this.rejectionExecutionCount);
        generator.writeKey("routing_state");
        this.routingState.serialize(generator, mapper);
        generator.writeKey("start_time");
        generator.write(this.startTime);
        generator.writeKey("threads_per_allocation");
        generator.write(this.threadsPerAllocation);
        generator.writeKey("timeout_count");
        generator.write(this.timeoutCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelDeploymentNodesStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::averageInferenceTimeMs, JsonpDeserializer.doubleDeserializer(), "average_inference_time_ms");
        op.add(Builder::errorCount, JsonpDeserializer.integerDeserializer(), "error_count");
        op.add(Builder::inferenceCount, JsonpDeserializer.integerDeserializer(), "inference_count");
        op.add(Builder::lastAccess, JsonpDeserializer.longDeserializer(), "last_access");
        op.add(Builder::node, DiscoveryNode._DESERIALIZER, "node");
        op.add(Builder::numberOfAllocations, JsonpDeserializer.integerDeserializer(), "number_of_allocations");
        op.add(Builder::numberOfPendingRequests, JsonpDeserializer.integerDeserializer(), "number_of_pending_requests");
        op.add(Builder::rejectionExecutionCount, JsonpDeserializer.integerDeserializer(), "rejection_execution_count");
        op.add(Builder::routingState, TrainedModelAssignmentRoutingTable._DESERIALIZER, "routing_state");
        op.add(Builder::startTime, JsonpDeserializer.longDeserializer(), "start_time");
        op.add(Builder::threadsPerAllocation, JsonpDeserializer.integerDeserializer(), "threads_per_allocation");
        op.add(Builder::timeoutCount, JsonpDeserializer.integerDeserializer(), "timeout_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelDeploymentNodesStats> {
        private Double averageInferenceTimeMs;
        private Integer errorCount;
        private Integer inferenceCount;
        private Long lastAccess;
        private DiscoveryNode node;
        private Integer numberOfAllocations;
        private Integer numberOfPendingRequests;
        private Integer rejectionExecutionCount;
        private TrainedModelAssignmentRoutingTable routingState;
        private Long startTime;
        private Integer threadsPerAllocation;
        private Integer timeoutCount;

        public final Builder averageInferenceTimeMs(double value) {
            this.averageInferenceTimeMs = value;
            return this;
        }

        public final Builder errorCount(int value) {
            this.errorCount = value;
            return this;
        }

        public final Builder inferenceCount(int value) {
            this.inferenceCount = value;
            return this;
        }

        public final Builder lastAccess(long value) {
            this.lastAccess = value;
            return this;
        }

        public final Builder node(DiscoveryNode value) {
            this.node = value;
            return this;
        }

        public final Builder node(Function<DiscoveryNode.Builder, ObjectBuilder<DiscoveryNode>> fn) {
            return this.node(fn.apply(new DiscoveryNode.Builder()).build());
        }

        public final Builder numberOfAllocations(int value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder numberOfPendingRequests(int value) {
            this.numberOfPendingRequests = value;
            return this;
        }

        public final Builder rejectionExecutionCount(int value) {
            this.rejectionExecutionCount = value;
            return this;
        }

        public final Builder routingState(TrainedModelAssignmentRoutingTable value) {
            this.routingState = value;
            return this;
        }

        public final Builder routingState(Function<TrainedModelAssignmentRoutingTable.Builder, ObjectBuilder<TrainedModelAssignmentRoutingTable>> fn) {
            return this.routingState(fn.apply(new TrainedModelAssignmentRoutingTable.Builder()).build());
        }

        public final Builder startTime(long value) {
            this.startTime = value;
            return this;
        }

        public final Builder threadsPerAllocation(int value) {
            this.threadsPerAllocation = value;
            return this;
        }

        public final Builder timeoutCount(int value) {
            this.timeoutCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelDeploymentNodesStats build() {
            this._checkSingleUse();
            return new TrainedModelDeploymentNodesStats(this);
        }
    }
}

