/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.Static;
import org.opengis.annotation.UML;

public final class Classes
extends Static {
    private static final Class<Object>[] EMPTY_ARRAY = new Class[0];
    private static final String[] EXCLUDES = new String[]{"clone", "getClass", "hashCode", "toString", "toWKT"};

    private Classes() {
    }

    public static Class<?> changeArrayDimension(Class<?> element, int change) {
        if (change != 0 && element != null) {
            if (change < 0) {
                while ((element = element.getComponentType()) != null && ++change != 0) {
                }
            } else if (element != Void.TYPE) {
                StringBuilder buffer = new StringBuilder();
                do {
                    buffer.insert(0, '[');
                } while (--change != 0);
                if (element.isPrimitive()) {
                    buffer.append(Numbers.getInternal(element));
                } else if (element.isArray()) {
                    buffer.append(element.getName());
                } else {
                    buffer.append('L').append(element.getName()).append(';');
                }
                String name = buffer.toString();
                try {
                    element = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    throw new TypeNotPresentException(name, e);
                }
            }
        }
        return element;
    }

    public static Class<?> boundOfParameterizedProperty(Field field) {
        return Classes.getActualTypeArgument(field.getGenericType());
    }

    public static Class<?> boundOfParameterizedProperty(Method method) {
        Type type;
        Type[] parameters = method.getGenericParameterTypes();
        switch (parameters.length) {
            case 0: {
                type = method.getGenericReturnType();
                break;
            }
            case 1: {
                type = parameters[0];
                break;
            }
            default: {
                return null;
            }
        }
        return Classes.getActualTypeArgument(type);
    }

    public static Class<?> boundOfParameterizedDeclaration(GenericDeclaration typeOrMethod) {
        TypeVariable<?>[] parameters = typeOrMethod.getTypeParameters();
        int i = Classes.chooseSingleType(typeOrMethod, parameters.length);
        if (i >= 0) {
            Class<?> bounds = null;
            for (Type p : parameters[i].getBounds()) {
                if (!(p instanceof Class)) continue;
                bounds = Classes.findCommonClass(bounds, (Class)p);
            }
            return bounds;
        }
        return Classes.getActualTypeArgument(typeOrMethod);
    }

    private static Class<?> getActualTypeArgument(Object typeOrMethod) {
        while (typeOrMethod instanceof Class) {
            typeOrMethod = ((Class)typeOrMethod).getGenericSuperclass();
        }
        if (typeOrMethod instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)typeOrMethod;
            Type[] parameters = p.getActualTypeArguments();
            int i = Classes.chooseSingleType(p.getRawType(), parameters.length);
            if (i >= 0) {
                Type type = parameters[i];
                while (type instanceof WildcardType) {
                    Type[] bounds = ((WildcardType)type).getUpperBounds();
                    if (bounds.length != 1) {
                        return null;
                    }
                    type = bounds[0];
                }
                int dimension = 0;
                while (type instanceof GenericArrayType) {
                    type = ((GenericArrayType)type).getGenericComponentType();
                    ++dimension;
                }
                if (type instanceof ParameterizedType) {
                    type = ((ParameterizedType)type).getRawType();
                }
                if (type instanceof Class) {
                    return Classes.changeArrayDimension((Class)type, dimension);
                }
            }
        }
        return null;
    }

    private static int chooseSingleType(Object rawType, int count) {
        switch (count) {
            case 2: {
                if (!(rawType instanceof Class) && Map.class.isAssignableFrom((Class)rawType)) break;
            }
            case 1: {
                return 0;
            }
        }
        return -1;
    }

    public static <T> Class<? extends T> getClass(T object) {
        return object != null ? object.getClass() : null;
    }

    private static <T> Set<Class<? extends T>> getClasses(Iterable<? extends T> objects) {
        LinkedHashSet<Class<T>> types = new LinkedHashSet<Class<T>>();
        for (T object : objects) {
            types.add(Classes.getClass(object));
        }
        return types;
    }

    public static <T> Class<? super T> getStandardType(Class<T> type) {
        for (Class<T> candidate : Classes.getAllInterfaces(type)) {
            if (!candidate.isAnnotationPresent(UML.class)) continue;
            return candidate;
        }
        for (Class<T> candidate = type; candidate != null; candidate = candidate.getSuperclass()) {
            if (!Classes.isPublic(candidate)) continue;
            return candidate;
        }
        return type;
    }

    public static <T> Class<? super T>[] getAllInterfaces(Class<T> type) {
        Set<Class<?>> interfaces = Classes.getInterfaceSet(type);
        return interfaces != null ? (Class[])interfaces.toArray(Class[]::new) : EMPTY_ARRAY;
    }

    private static Set<Class<?>> getInterfaceSet(Class<?> type) {
        Set<Class<?>> interfaces = null;
        while (type != null) {
            interfaces = Classes.getInterfaceSet(type, interfaces);
            type = type.getSuperclass();
        }
        return interfaces;
    }

    private static Set<Class<?>> getInterfaceSet(Class<?> type, Set<Class<?>> addTo) {
        Class<?>[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (addTo == null) {
                addTo = JDK19.newLinkedHashSet(interfaces.length);
            }
            if (addTo.add(interfaces[i])) continue;
            interfaces[i] = null;
        }
        for (Class<?> candidate : interfaces) {
            if (candidate == null) continue;
            Classes.getInterfaceSet(candidate, addTo);
        }
        return addTo;
    }

    public static <T> Class<? extends T>[] getLeafInterfaces(Class<?> type, Class<T> baseInterface) {
        int count = 0;
        Class<Object>[] types = EMPTY_ARRAY;
        while (type != null) {
            Class<?>[] candidates;
            block1: for (Class<Object> clazz : candidates = type.getInterfaces()) {
                if (baseInterface != null && !baseInterface.isAssignableFrom(clazz)) continue;
                for (int i = 0; i < count; ++i) {
                    Class<Object> old = types[i];
                    if (clazz.isAssignableFrom(old)) continue block1;
                    if (!old.isAssignableFrom(clazz)) continue;
                    types[i] = clazz;
                    continue block1;
                }
                if (types == EMPTY_ARRAY) {
                    types = candidates;
                }
                if (count >= types.length) {
                    types = Arrays.copyOf(types, types.length + candidates.length);
                }
                types[count++] = clazz;
            }
            type = type.getSuperclass();
        }
        return ArraysExt.resize(types, count);
    }

    public static Class<?> findSpecializedClass(Iterable<?> objects) {
        Set<Class<?>> types = Classes.getClasses(objects);
        types.remove(null);
        Iterator<Class<?>> it = types.iterator();
        block0: while (it.hasNext()) {
            Class<?> candidate = it.next();
            for (Class<?> type : types) {
                if (candidate == type || !candidate.isAssignableFrom(type)) continue;
                it.remove();
                continue block0;
            }
        }
        return Classes.common(types);
    }

    private static Class<?> common(Set<Class<?>> types) {
        Iterator<Class<?>> it = types.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Class<?> type = it.next();
        while (it.hasNext()) {
            type = Classes.findCommonClass(type, it.next());
        }
        return type;
    }

    public static Class<?> findCommonClass(Iterable<?> objects) {
        Set<Class<?>> types = Classes.getClasses(objects);
        types.remove(null);
        return Classes.common(types);
    }

    public static Class<?> findCommonClass(Class<?> c1, Class<?> c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        do {
            if (c1.isAssignableFrom(c2)) {
                return c1;
            }
            if (c2.isAssignableFrom(c1)) {
                return c2;
            }
            c1 = c1.getSuperclass();
            c2 = c2.getSuperclass();
        } while (c1 != null && c2 != null);
        return Object.class;
    }

    public static Set<Class<?>> findCommonInterfaces(Class<?> c1, Class<?> c2) {
        Set<Class<Class<?>>> interfaces = Classes.getInterfaceSet(c1);
        Set<Class<?>> buffer = Classes.getInterfaceSet(c2);
        if (interfaces == null || buffer == null) {
            return Collections.emptySet();
        }
        interfaces.retainAll(buffer);
        Iterator<Class<?>> it = interfaces.iterator();
        while (it.hasNext()) {
            Class<?> candidate = it.next();
            buffer.clear();
            Classes.getInterfaceSet(candidate, buffer);
            if (!interfaces.removeAll(buffer)) continue;
            it = interfaces.iterator();
        }
        return interfaces;
    }

    public static boolean implementSameInterfaces(Class<?> object1, Class<?> object2, Class<?> baseInterface) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        Class<?>[] c1 = Classes.getLeafInterfaces(object1, baseInterface);
        Class<?>[] c2 = Classes.getLeafInterfaces(object2, baseInterface);
        int n = c2.length;
        for (Class<?> c : c1) {
            int j;
            block4: {
                j = n;
                while (--j >= 0) {
                    if (c != c2[j]) continue;
                    break block4;
                }
                return false;
            }
            System.arraycopy(c2, j + 1, c2, j, --n - j);
        }
        return n == 0;
    }

    public static String getShortName(Class<?> classe) {
        if (classe == null) {
            return "<*>";
        }
        while (classe.isAnonymousClass()) {
            classe = classe.getSuperclass();
        }
        Object name = classe.getSimpleName();
        Class<?> enclosing = classe.getEnclosingClass();
        if (enclosing != null) {
            name = Classes.getShortName(enclosing) + "." + (String)name;
        }
        return name;
    }

    public static String getShortClassName(Object object) {
        return Classes.getShortName(Classes.getClass(object));
    }

    public static boolean isAssignableToAny(Class<?> type, Class<?> ... allowedTypes) {
        if (type != null) {
            if (allowedTypes == null) {
                return true;
            }
            for (Class<?> candidate : allowedTypes) {
                if (candidate == null || !candidate.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPossibleGetter(Method method) {
        return method.getReturnType() != Void.TYPE && method.getParameterCount() == 0 && !method.isSynthetic() && !ArraysExt.contains(EXCLUDES, method.getName());
    }

    public static boolean isParameterizedProperty(Class<?> type) {
        return type == Optional.class;
    }

    public static boolean isPublic(Class<?> type) {
        return type != null && Modifier.isPublic(type.getModifiers()) && type.getModule().isExported(type.getPackageName());
    }
}

