/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.NilReferencingObject;
import org.apache.sis.referencing.operation.gridded.CompressedGrid;
import org.apache.sis.referencing.operation.gridded.GridFile;
import org.apache.sis.referencing.operation.gridded.LoadedGrid;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.Molodensky;
import org.apache.sis.referencing.operation.transform.InterpolatedGeocentricTransform;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class FranceGeocentricInterpolation
extends AbstractProvider {
    private static final long serialVersionUID = -298193260915837911L;
    public static final double TX = 168.0;
    public static final double TY = 60.0;
    public static final double TZ = -320.0;
    static final double PRECISION = 1.0E-4;
    private static final double[] ACCURACY = new double[]{0.05, 0.1, 0.2, 0.5, 1.0};
    private static final String HEADER = "GR3D";
    private static final String DEFAULT = "gr3df97a.txt";
    public static final ParameterDescriptor<URI> FILE;
    public static final ParameterDescriptor<Integer> INTERPOLATION_CRS;
    public static final ParameterDescriptor<Integer> STANDARD_CT;
    static final ParameterDescriptorGroup PARAMETERS;

    public FranceGeocentricInterpolation() {
        super(Transformation.class, PARAMETERS, EllipsoidalCS.class, true, EllipsoidalCS.class, true, (byte)2);
    }

    public static boolean isRecognized(GridFile file) {
        String filename = file.parameter.getPath();
        int s = filename.lastIndexOf(47) + 1;
        return filename.regionMatches(true, s, DEFAULT, 0, 5);
    }

    private static Ellipsoid createEllipsoid(Parameters values, ParameterDescriptor<Double> semiMajor, ParameterDescriptor<Double> semiMinor, Ellipsoid candidate) {
        double semiMajorAxis = values.doubleValue(semiMajor);
        double semiMinorAxis = values.doubleValue(semiMinor);
        if (candidate != null && Math.abs(candidate.getSemiMajorAxis() - semiMajorAxis) < 1.0E-6 && Math.abs(candidate.getSemiMinorAxis() - semiMinorAxis) < 1.0E-6) {
            return candidate;
        }
        return DefaultEllipsoid.createEllipsoid(Map.of("name", NilReferencingObject.UNNAMED), semiMajorAxis, semiMinorAxis, (Unit<Length>)Units.METRE);
    }

    @Override
    public MathTransform createMathTransform(MathTransformProvider.Context context) throws FactoryException {
        LoadedGrid<Angle, Length> grid;
        Parameters pg = Parameters.castOrWrap(context.getCompletedParameters());
        int dim = (Integer)pg.getValue(Molodensky.DIMENSION);
        GridFile file = new GridFile(pg, FILE);
        try {
            double[] dArray;
            if (FranceGeocentricInterpolation.isRecognized(file)) {
                double[] dArray2 = new double[3];
                dArray2[0] = 168.0;
                dArray2[1] = 60.0;
                dArray = dArray2;
                dArray2[2] = -320.0;
            } else {
                dArray = null;
            }
            grid = FranceGeocentricInterpolation.getOrLoad(file, dArray, 1.0E-4);
        }
        catch (FactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw file.canNotLoad(FranceGeocentricInterpolation.class, HEADER, e);
        }
        MathTransform tr = InterpolatedGeocentricTransform.createGeodeticTransformation(context.getFactory(), FranceGeocentricInterpolation.createEllipsoid(pg, (ParameterDescriptor<Double>)Molodensky.TGT_SEMI_MAJOR, (ParameterDescriptor<Double>)Molodensky.TGT_SEMI_MINOR, CommonCRS.ETRS89.ellipsoid()), context.getTargetDimensions().orElse(dim) >= 3, FranceGeocentricInterpolation.createEllipsoid(pg, (ParameterDescriptor<Double>)Molodensky.SRC_SEMI_MAJOR, (ParameterDescriptor<Double>)Molodensky.SRC_SEMI_MINOR, null), context.getSourceDimensions().orElse(dim) >= 3, grid);
        try {
            tr = tr.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException((Throwable)e);
        }
        return tr;
    }

    static LoadedGrid<Angle, Length> getOrLoad(GridFile file, double[] averages, double scale) throws Exception {
        return LoadedGrid.getOrLoad(file, null, new Loader(file, averages, scale)).castTo(Angle.class, Length.class);
    }

    static {
        ParameterBuilder builder = FranceGeocentricInterpolation.builder();
        FILE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8727")).addName("Geocentric translation file")).create(URI.class, URI.create(DEFAULT));
        INTERPOLATION_CRS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("1048")).addName("EPSG code for Interpolation CRS")).create(Integer.class, null);
        STANDARD_CT = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("1062")).addName("EPSG code for standard transformation T0")).addName("EPSG code for \"standard\" CT")).create(Integer.class, null);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("1087")).addName("Geocentric translations (geog2D domain) by grid (IGN)")).addName("Geocentric translation by Grid Interpolation (IGN)")).setDeprecated(true)).addIdentifier("9655")).addName("France geocentric interpolation")).setDeprecated(false)).createGroup(new GeneralParameterDescriptor[]{Molodensky.DIMENSION, Molodensky.SRC_SEMI_MAJOR, Molodensky.SRC_SEMI_MINOR, Molodensky.TGT_SEMI_MAJOR, Molodensky.TGT_SEMI_MINOR, FILE, INTERPOLATION_CRS, STANDARD_CT});
    }

    static final class Loader
    implements Callable<LoadedGrid<?, ?>> {
        private final GridFile file;
        private final double[] averages;
        private final double scale;

        Loader(GridFile file, double[] averages, double scale) {
            this.file = file;
            this.averages = averages;
            this.scale = scale;
        }

        @Override
        public LoadedGrid<?, ?> call() throws Exception {
            LoadedGrid<Angle, Length> grid;
            try (BufferedReader in = this.file.newBufferedReader();){
                this.file.startLoading(FranceGeocentricInterpolation.class);
                LoadedGrid.Float<Angle, Length> g = Loader.load(in, this.file);
                grid = CompressedGrid.compress(g, this.averages, this.scale);
            }
            return grid.useSharedData();
        }

        static LoadedGrid.Float<Angle, Length> load(BufferedReader in, GridFile file) throws IOException, FactoryException, NoninvertibleTransformException {
            String line;
            LoadedGrid.Float<Angle, Length> grid = null;
            double x0 = 0.0;
            double xf = 0.0;
            double y0 = 0.0;
            double yf = 0.0;
            double \u0394x = 0.0;
            double \u0394y = 0.0;
            int nx = 0;
            int ny = 0;
            block4: while (true) {
                int p;
                if ((line = in.readLine()) == null) {
                    throw new EOFException(Errors.format((short)168, (Object)file));
                }
                int length = CharSequences.skipTrailingWhitespaces((CharSequence)line, (int)0, (int)line.length());
                if (length <= 0 || line.charAt(p = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)0, (int)length)) == '#') continue;
                if (!line.regionMatches(true, p, FranceGeocentricInterpolation.HEADER, 0, FranceGeocentricInterpolation.HEADER.length())) break;
                if ((p += FranceGeocentricInterpolation.HEADER.length()) >= length) continue;
                char c = line.charAt(p);
                p = CharSequences.skipLeadingWhitespaces((CharSequence)line, (int)(p + 1), (int)length);
                switch (c) {
                    case '1': {
                        if (grid != null) {
                            throw new FactoryException(Errors.format((short)37, (Object)FranceGeocentricInterpolation.HEADER));
                        }
                        double[] gridGeometry = CharSequences.parseDoubles((CharSequence)line.substring(p, length), (char)' ');
                        if (gridGeometry.length != 6) break;
                        x0 = gridGeometry[0];
                        xf = gridGeometry[1];
                        y0 = gridGeometry[2];
                        yf = gridGeometry[3];
                        \u0394x = gridGeometry[4];
                        \u0394y = gridGeometry[5];
                        nx = Math.toIntExact(Math.round((xf - x0) / \u0394x + 1.0));
                        ny = Math.toIntExact(Math.round((yf - y0) / \u0394y + 1.0));
                        grid = new LoadedGrid.Float<Angle, Length>(3, Units.DEGREE, Units.METRE, false, x0, y0, \u0394x, \u0394y, nx, ny, PARAMETERS, file);
                        grid.accuracy = Double.NaN;
                        float[][] fArray = grid.offsets;
                        int n = fArray.length;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= n) continue block4;
                            float[] data = fArray[n2];
                            Arrays.fill(data, Float.NaN);
                            ++n2;
                        }
                    }
                    case '2': {
                        String interp = line.substring(p, length);
                        if (interp.matches("(?i)INTERPOLATION[^A-Z]+BILINEAIRE")) break;
                        LogRecord record = Errors.forLocale(null).createLogRecord(Level.WARNING, (short)198, (Object)interp);
                        Logging.completeAndLog((Logger)AbstractProvider.LOGGER, FranceGeocentricInterpolation.class, (String)"createMathTransform", (LogRecord)record);
                        break;
                    }
                }
            }
            if (grid == null) {
                throw new FactoryException(Resources.format((short)90, FranceGeocentricInterpolation.HEADER, file));
            }
            float[] tX = grid.offsets[0];
            float[] tY = grid.offsets[1];
            float[] tZ = grid.offsets[2];
            do {
                String[] tokens = line.split("\\s+");
                double x = Double.parseDouble(tokens[1]);
                double y = Double.parseDouble(tokens[2]);
                int i = Math.toIntExact(Math.round((x - x0) / \u0394x));
                int j = Math.toIntExact(Math.round((y - y0) / \u0394y));
                if (i < 0 || i >= nx) {
                    throw new FactoryException(Errors.format((short)204, (Object)"x", (Object)x, (Object)x0, (Object)xf));
                }
                if (j < 0 || j >= ny) {
                    throw new FactoryException(Errors.format((short)204, (Object)"y", (Object)y, (Object)y0, (Object)yf));
                }
                int p = j * nx + i;
                if (!(Double.isNaN(tX[p]) && Double.isNaN(tY[p]) && Double.isNaN(tZ[p]))) {
                    throw new FactoryException(Errors.format((short)202, (Object)(x + ", " + y)));
                }
                tX[p] = -Float.parseFloat(tokens[3]);
                tY[p] = -Float.parseFloat(tokens[4]);
                tZ[p] = -Float.parseFloat(tokens[5]);
                int accuracyCode = Math.max(0, Integer.parseInt(tokens[6]) - 1);
                double accuracy = ACCURACY[Math.min(ACCURACY.length - 1, accuracyCode)];
                if (accuracy >= grid.accuracy) continue;
                grid.accuracy = accuracy;
            } while ((line = in.readLine()) != null);
            return grid;
        }
    }
}

