/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.sis.filter.Filter;
import org.apache.sis.style.se1.Description;
import org.apache.sis.style.se1.ElseFilter;
import org.apache.sis.style.se1.LegendGraphic;
import org.apache.sis.style.se1.StyleElement;
import org.apache.sis.style.se1.StyleFactory;
import org.apache.sis.style.se1.Symbolizer;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.bind.Context;
import org.opengis.metadata.citation.OnlineResource;

@XmlType(name="RuleType", propOrder={"name", "description", "legend", "elseFilter", "minScale", "maxScale", "symbolizers"})
@XmlRootElement(name="Rule")
public class Rule<R>
extends StyleElement<R> {
    @XmlElement(name="Name")
    protected String name;
    @XmlElement(name="Description")
    protected Description<R> description;
    @XmlElement(name="LegendGraphic")
    protected LegendGraphic<R> legend;
    protected Filter<R> filter;
    protected boolean isElseFilter;
    protected double minScale;
    protected double maxScale;
    @XmlElementRef(name="Symbolizer")
    private List<Symbolizer<R>> symbolizers;
    protected OnlineResource onlineSource;

    private Rule() {
    }

    public Rule(StyleFactory<R> factory) {
        super(factory);
        this.maxScale = Double.POSITIVE_INFINITY;
        this.symbolizers = new ArrayList<Symbolizer<R>>();
    }

    public Rule(Rule<R> source) {
        super(source);
        this.name = source.name;
        this.description = source.description;
        this.legend = source.legend;
        this.filter = source.filter;
        this.minScale = source.minScale;
        this.maxScale = source.maxScale;
        this.onlineSource = source.onlineSource;
        this.symbolizers = new ArrayList<Symbolizer<R>>(source.symbolizers);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(String value) {
        this.name = value;
    }

    public Optional<Description<R>> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public void setDescription(Description<R> value) {
        this.description = value;
    }

    public Optional<LegendGraphic<R>> getLegend() {
        return Optional.ofNullable(this.legend);
    }

    public void setLegend(LegendGraphic<R> value) {
        this.legend = value;
    }

    public Filter<R> getFilter() {
        if (this.isElseFilter) {
            return Filter.exclude();
        }
        Filter value = this.filter;
        return value != null ? value : Filter.include();
    }

    public void setFilter(Filter<R> value) {
        this.isElseFilter = false;
        this.filter = value;
    }

    public boolean isElseFilter() {
        return this.isElseFilter;
    }

    public void setElseFilter(boolean value) {
        this.isElseFilter = value;
    }

    @XmlElement(name="ElseFilter")
    private ElseFilter getElseFilter() {
        return this.isElseFilter ? ElseFilter.INSTANCE : null;
    }

    private void setElseFilter(ElseFilter value) {
        this.isElseFilter = value != null;
    }

    public double getMinScaleDenominator() {
        return this.minScale;
    }

    @XmlElement(name="MinScaleDenominator")
    private Double getMinScale() {
        double value = this.minScale;
        return value > 0.0 || this.maxScale != Double.POSITIVE_INFINITY ? Double.valueOf(value) : null;
    }

    public void setMinScaleDenominator(double value) {
        ArgumentChecks.ensurePositive((String)"MinScaleDenominator", (double)value);
        this.minScale = value;
        if (value > this.maxScale) {
            this.maxScale = Double.POSITIVE_INFINITY;
        }
    }

    private void setMinScale(Double value) {
        if (this.isValidScale("MinScaleDenominator", value)) {
            this.minScale = value;
        }
    }

    public double getMaxScaleDenominator() {
        return this.maxScale;
    }

    @XmlElement(name="MaxScaleDenominator")
    private Double getMaxScale() {
        double value = this.maxScale;
        return value != Double.POSITIVE_INFINITY ? Double.valueOf(value) : null;
    }

    public void setMaxScaleDenominator(double value) {
        ArgumentChecks.ensureStrictlyPositive((String)"MaxScaleDenominator", (double)value);
        this.maxScale = value;
        if (value < this.minScale) {
            this.minScale = 0.0;
        }
    }

    private void setMaxScale(Double value) {
        if (this.isValidScale("MaxScaleDenominator", value)) {
            this.maxScale = value;
        }
    }

    private boolean isValidScale(String name, Double value) {
        boolean isValidScale;
        boolean bl = isValidScale = value != null;
        if (isValidScale) {
            boolean bl2 = isValidScale = value >= this.minScale && value <= this.maxScale;
            if (!isValidScale) {
                Context.warningOccured((Context)Context.current(), Rule.class, (String)"set".concat(name), Errors.class, (short)204, (Object[])new Object[]{name, this.minScale, this.maxScale, value});
            }
        }
        return isValidScale;
    }

    public List<Symbolizer<R>> symbolizers() {
        return this.symbolizers;
    }

    public Optional<OnlineResource> getOnlineSource() {
        return Optional.ofNullable(this.onlineSource);
    }

    public void setOnlineSource(OnlineResource value) {
        this.onlineSource = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.name, this.description, this.legend, this.filter, this.minScale, this.maxScale, this.symbolizers, this.onlineSource};
    }

    @Override
    public Rule<R> clone() {
        Rule clone = (Rule)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.description != null) {
            this.description = this.description.clone();
        }
        if (this.legend != null) {
            this.legend = this.legend.clone();
        }
        this.symbolizers = new ArrayList<Symbolizer<R>>(this.symbolizers);
        this.symbolizers.replaceAll(Symbolizer::clone);
    }
}

