/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.factory.v6.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.skywalking.library.elasticsearch.response.Mappings;

final class V6MappingsDeserializer
extends JsonDeserializer<Mappings> {
    V6MappingsDeserializer() {
    }

    public Mappings deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Map m = (Map)p.getCodec().readValue(p, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Optional<Map.Entry> typeMapping = m.entrySet().stream().filter(it -> it.getValue() instanceof Map).filter(it -> ((Map)it.getValue()).containsKey("properties") || ((Map)it.getValue()).containsKey("_source")).findFirst();
        Optional<Mappings> result = typeMapping.map(it -> {
            Object excludes;
            Mappings mappings = new Mappings();
            mappings.setType((String)it.getKey());
            Map properties = (Map)((Map)it.getValue()).get("properties");
            Map source = (Map)((Map)it.getValue()).get("_source");
            if (properties != null) {
                mappings.setProperties(properties);
            }
            if (source != null && (excludes = source.get("excludes")) != null) {
                mappings.getSource().setExcludes(new HashSet<String>((ArrayList)excludes));
            }
            return mappings;
        });
        return result.orElse(null);
    }
}

