/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.net.UrlEscapers;
import io.netty.util.NetUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DomainSocketUtil {
    private static final byte[] IPV6_DISCARD_ADDR = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 65, 114, 109, 101, 114, 105, 97, 33};
    public static final String DOMAIN_SOCKET_IP = NetUtil.bytesToIpAddress(IPV6_DISCARD_ADDR);
    public static final int DOMAIN_SOCKET_PORT = 1;
    private static final Pattern AT_OR_COLON = Pattern.compile("[@:]");

    public static boolean isDomainSocketAddress(InetAddress addr) {
        return Arrays.equals(addr.getAddress(), IPV6_DISCARD_ADDR);
    }

    public static InetAddress toInetAddress(String path) {
        try {
            return InetAddress.getByAddress("unix:" + path, IPV6_DISCARD_ADDR);
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    public static String toAuthority(String path) {
        Objects.requireNonNull(path, "path");
        String escaped = UrlEscapers.urlPathSegmentEscaper().escape(path);
        Matcher matcher = AT_OR_COLON.matcher(escaped);
        try (TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tmp.stringBuilder();
            buf.append("unix%3A");
            int i = 0;
            while (i < escaped.length()) {
                if (!matcher.find(i)) {
                    buf.append(escaped, i, escaped.length());
                    break;
                }
                int pos = matcher.start();
                buf.append(escaped, i, pos);
                buf.append(escaped.charAt(pos) == '@' ? "%40" : "%3A");
                i = pos + 1;
            }
            String string = buf.toString();
            return string;
        }
    }

    private DomainSocketUtil() {
    }
}

