/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.config;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.config.group.EndpointNameGrouping;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamingControl
implements Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NamingControl.class);
    private final int serviceNameMaxLength;
    private final int instanceNameMaxLength;
    private final int endpointNameMaxLength;
    private final EndpointNameGrouping endpointNameGrouping;

    public String formatServiceName(String serviceName) {
        if (serviceName != null && serviceName.length() > this.serviceNameMaxLength) {
            String rename = serviceName.substring(0, this.serviceNameMaxLength);
            if (log.isDebugEnabled()) {
                log.debug("Service {} has been renamed to {} due to length limitation {}", new Object[]{serviceName, rename, this.serviceNameMaxLength});
            }
            return rename;
        }
        return serviceName;
    }

    public String formatInstanceName(String instanceName) {
        if (instanceName != null && instanceName.length() > this.instanceNameMaxLength) {
            String rename = instanceName.substring(0, this.instanceNameMaxLength);
            if (log.isDebugEnabled()) {
                log.debug("Service instance {} has been renamed to {} due to length limitation {}", new Object[]{instanceName, rename, this.serviceNameMaxLength});
            }
            return rename;
        }
        return instanceName;
    }

    public String formatEndpointName(String serviceName, String endpointName) {
        if (StringUtil.isEmpty((String)serviceName) || StringUtil.isEmpty((String)endpointName)) {
            return endpointName;
        }
        String lengthControlledName = endpointName;
        if (endpointName.length() > this.endpointNameMaxLength) {
            lengthControlledName = endpointName.substring(0, this.endpointNameMaxLength);
            if (log.isDebugEnabled()) {
                log.debug("Endpoint {} has been renamed to {} due to length limitation {}", new Object[]{endpointName, lengthControlledName, this.serviceNameMaxLength});
            }
        }
        return (String)this.endpointNameGrouping.format(serviceName, lengthControlledName)._1();
    }

    @Generated
    public NamingControl(int serviceNameMaxLength, int instanceNameMaxLength, int endpointNameMaxLength, EndpointNameGrouping endpointNameGrouping) {
        this.serviceNameMaxLength = serviceNameMaxLength;
        this.instanceNameMaxLength = instanceNameMaxLength;
        this.endpointNameMaxLength = endpointNameMaxLength;
        this.endpointNameGrouping = endpointNameGrouping;
    }
}

