/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v7.support;

import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.elasticsearch.v7.support.RestClientCache;
import org.elasticsearch.action.ActionListener;

public class ActionListenerAdapter<T>
implements ActionListener<T>,
EnhancedInstance {
    private final RestClientCache<T> restClientCache;

    public ActionListenerAdapter(RestClientCache<T> restClientCache) {
        this.restClientCache = restClientCache;
    }

    public void onResponse(T o) {
        try {
            if (this.restClientCache.getContextSnapshot() != null) {
                this.continueContext("/onResponse");
            }
            if (this.restClientCache.getActionListener() != null) {
                this.restClientCache.getActionListener().onResponse(o);
            }
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            this.restClientCache.setContextSnapshot(null);
            ContextManager.stopSpan();
        }
    }

    public void onFailure(Exception e) {
        try {
            if (this.restClientCache.getContextSnapshot() != null) {
                this.continueContext("/onFailure");
            }
            if (this.restClientCache.getActionListener() != null) {
                this.restClientCache.getActionListener().onFailure(e);
            }
        }
        catch (Throwable t) {
            ContextManager.activeSpan().log(t);
            throw t;
        }
        finally {
            ContextManager.stopSpan();
        }
    }

    public Object getSkyWalkingDynamicField() {
        return this.restClientCache;
    }

    public void setSkyWalkingDynamicField(Object enhanceInfo) {
    }

    private void continueContext(String action) {
        AbstractSpan activeSpan = ContextManager.createLocalSpan((String)(this.restClientCache.getOperationName() + action));
        activeSpan.setComponent((Component)ComponentsDefine.REST_HIGH_LEVEL_CLIENT);
        Tags.DB_TYPE.set(activeSpan, "Elasticsearch");
        SpanLayer.asDB((AbstractSpan)activeSpan);
        ContextManager.continued((ContextSnapshot)this.restClientCache.getContextSnapshot());
    }
}

