/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.jvm.cpu;

import org.apache.skywalking.apm.network.common.v3.CPU;

public abstract class CPUMetricsAccessor {
    private long lastCPUTimeNs;
    private long lastSampleTimeNs;
    private final int cpuCoreNum;

    public CPUMetricsAccessor(int cpuCoreNum) {
        this.cpuCoreNum = cpuCoreNum;
    }

    protected void init() {
        this.lastCPUTimeNs = this.getCpuTime();
        this.lastSampleTimeNs = System.nanoTime();
    }

    protected abstract long getCpuTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPU getCPUMetrics() {
        long cpuTime = this.getCpuTime();
        long cpuCost = cpuTime - this.lastCPUTimeNs;
        long now = System.nanoTime();
        try {
            CPU.Builder cpuBuilder = CPU.newBuilder();
            CPU cPU = cpuBuilder.setUsagePercent((double)cpuCost * 1.0 / (double)((now - this.lastSampleTimeNs) * (long)this.cpuCoreNum) * 100.0).build();
            return cPU;
        }
        finally {
            this.lastCPUTimeNs = cpuTime;
            this.lastSampleTimeNs = now;
        }
    }
}

