/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.AsyncOffsetSeqLog$;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqLog;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\f\u0019\u0001\u0015B\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AQ\b\u0001B\u0001B\u0003%a\b\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!i\u0005A!A!\u0002\u0013q\u0005\"B*\u0001\t\u0003!\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B/\t\u000f\u0011\u0004!\u0019!C\u0005K\"1A\u000e\u0001Q\u0001\n\u0019Dq!\u001c\u0001C\u0002\u0013\u0005a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0002H\u0001!\t!!\u0013\b\u0013\u0005E\u0003$!A\t\u0002\u0005Mc\u0001C\f\u0019\u0003\u0003E\t!!\u0016\t\rM#B\u0011AA/\u0011%\ty\u0006FI\u0001\n\u0003\t\tGA\tBgft7m\u00144gg\u0016$8+Z9M_\u001eT!!\u0007\u000e\u0002\u0013M$(/Z1nS:<'BA\u000e\u001d\u0003%)\u00070Z2vi&|gN\u0003\u0002\u001e=\u0005\u00191/\u001d7\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019\t\u0007/Y2iK*\t1%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001MA\u0011q\u0005K\u0007\u00021%\u0011\u0011\u0006\u0007\u0002\r\u001f\u001a47/\u001a;TKFdunZ\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003Y5j\u0011\u0001H\u0005\u0003]q\u0011Ab\u00159be.\u001cVm]:j_:\fA\u0001]1uQB\u0011\u0011G\u000f\b\u0003ea\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u0013\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e2\u0014aD3yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0011\u0005}2U\"\u0001!\u000b\u0005\u0005\u0013\u0015AC2p]\u000e,(O]3oi*\u00111\tR\u0001\u0005kRLGNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0003%A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\fac\u001c4gg\u0016$8i\\7nSRLe\u000e^3sm\u0006dWj\u001d\t\u0003\u0015.k\u0011AN\u0005\u0003\u0019Z\u0012A\u0001T8oO\u0006)1\r\\8dWB\u0011q*U\u0007\u0002!*\u00111IH\u0005\u0003%B\u0013Qa\u00117pG.\fa\u0001P5oSRtDCB+W/bK&\f\u0005\u0002(\u0001!)!F\u0002a\u0001W!)qF\u0002a\u0001a!)QH\u0002a\u0001}!)\u0001J\u0002a\u0001\u0013\"9QJ\u0002I\u0001\u0002\u0004q\u0015a\u00059f]\u0012LgnZ(gMN,Go\u0016:ji\u0016\u001cX#A/\u0011\t}r\u0016\nY\u0005\u0003?\u0002\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\ry\u0014-S\u0005\u0003E\u0002\u0013\u0011cQ8na2,G/\u00192mK\u001a+H/\u001e:f\u0003Q\u0001XM\u001c3j]\u001e|eMZ:fi^\u0013\u0018\u000e^3tA\u0005YB.Y:u\u0007>lW.\u001b;JgN,X\r\u001a+j[\u0016\u001cH/Y7q\u001bN,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0002\u000ba!\u0019;p[&\u001c\u0017BA6i\u0005)\tEo\\7jG2{gnZ\u0001\u001dY\u0006\u001cHoQ8n[&$\u0018j]:vK\u0012$\u0016.\\3ti\u0006l\u0007/T:!\u0003]9(/\u001b;uK:$v\u000eR;sC\ndWm\u0015;pe\u0006<W-F\u0001p!\ry\u0004/S\u0005\u0003c\u0002\u0013QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3EKF,X-\u0001\rxe&$H/\u001a8U_\u0012+(/\u00192mKN#xN]1hK\u0002\n1cZ3u\u0003NLhnY(gMN,Go\u0016:ji\u0016$\"!\u001e=\u0011\u0007)3\b-\u0003\u0002xm\t1q\n\u001d;j_:DQ!_\u0007A\u0002%\u000bqAY1uG\"LE-\u0001\fsK6|g/Z!ts:\u001cwJ\u001a4tKR<&/\u001b;f)\tax\u0010\u0005\u0002K{&\u0011aP\u000e\u0002\u0005+:LG\u000fC\u0003z\u001d\u0001\u0007\u0011*\u0001\u0005bI\u0012\f5/\u001f8d)\u0019\t)!a\u0005\u0002\u0016A!q(YA\u0004!\u0019Q\u0015\u0011B%\u0002\u000e%\u0019\u00111\u0002\u001c\u0003\rQ+\b\u000f\\33!\rQ\u0015qB\u0005\u0004\u0003#1$a\u0002\"p_2,\u0017M\u001c\u0005\u0006s>\u0001\r!\u0013\u0005\b\u0003/y\u0001\u0019AA\r\u0003!iW\r^1eCR\f\u0007cA\u0014\u0002\u001c%\u0019\u0011Q\u0004\r\u0003\u0013=3gm]3u'\u0016\f\u0018\u0001G1eI:+wOQ1uG\"\u0014\u0015p\u0015;sK\u0006l\u0017i]=oGR!\u00111EA\u001f)\u0011\t)#a\n\u0011\t}\n\u0017Q\u0002\u0005\b\u0003S\u0001\u0002\u0019AA\u0016\u0003\t1g\u000e\u0005\u0004K\u0003[\t\t\u0004`\u0005\u0004\u0003_1$!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t\u0019$!\u000f\u000e\u0005\u0005U\"bAA\u001c\t\u0006\u0011\u0011n\\\u0005\u0005\u0003w\t)D\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0003z!\u0001\u0007\u0011*A\u0003qkJ<W\rF\u0002}\u0003\u0007Ba!!\u0012\u0012\u0001\u0004I\u0015\u0001\u0005;ie\u0016\u001c\bn\u001c7e\u0005\u0006$8\r[%e\u0003]\u0001XM\u001c3j]\u001e\f5/\u001f8d\u001f\u001a47/\u001a;Xe&$X\r\u0006\u0002\u0002LA\u0019!*!\u0014\n\u0007\u0005=cGA\u0002J]R\f\u0011#Q:z]\u000e|eMZ:fiN+\u0017\u000fT8h!\t9CcE\u0002\u0015\u0003/\u00022ASA-\u0013\r\tYF\u000e\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005M\u0013a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002d)\u001aa*!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001d7\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class AsyncOffsetSeqLog
extends OffsetSeqLog {
    private final ThreadPoolExecutor executorService;
    private final long offsetCommitIntervalMs;
    private final Clock clock;
    private final ConcurrentHashMap<Object, CompletableFuture<Object>> pendingOffsetWrites;
    private final AtomicLong lastCommitIssuedTimestampMs;
    private final ConcurrentLinkedDeque<Object> writtenToDurableStorage;

    public static Clock $lessinit$greater$default$5() {
        return AsyncOffsetSeqLog$.MODULE$.$lessinit$greater$default$5();
    }

    private ConcurrentHashMap<Object, CompletableFuture<Object>> pendingOffsetWrites() {
        return this.pendingOffsetWrites;
    }

    private AtomicLong lastCommitIssuedTimestampMs() {
        return this.lastCommitIssuedTimestampMs;
    }

    public ConcurrentLinkedDeque<Object> writtenToDurableStorage() {
        return this.writtenToDurableStorage;
    }

    public Option<CompletableFuture<Object>> getAsyncOffsetWrite(long batchId) {
        return Option$.MODULE$.apply(this.pendingOffsetWrites().get(BoxesRunTime.boxToLong((long)batchId)));
    }

    public void removeAsyncOffsetWrite(long batchId) {
        this.pendingOffsetWrites().remove(BoxesRunTime.boxToLong((long)batchId));
    }

    public CompletableFuture<Tuple2<Object, Object>> addAsync(long batchId2, OffsetSeq metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable & scala.Serializable)() -> "'null' metadata cannot written to a metadata log");
        long lastIssuedTs = this.lastCommitIssuedTimestampMs().get();
        CompletableFuture<Tuple2.mcJZ.sp> future = this.offsetCommitIntervalMs > 0L ? (lastIssuedTs == -1L || lastIssuedTs + this.offsetCommitIntervalMs <= this.clock.getTimeMillis() ? this.issueAsyncWrite$1(batchId2, metadata).thenApply(batchId -> AsyncOffsetSeqLog.$anonfun$addAsync$4(BoxesRunTime.unboxToLong((Object)batchId))) : CompletableFuture.completedFuture(new Tuple2.mcJZ.sp(batchId2, false))) : this.issueAsyncWrite$1(batchId2, metadata).thenApply(batchId -> AsyncOffsetSeqLog.$anonfun$addAsync$5(BoxesRunTime.unboxToLong((Object)batchId)));
        this.batchCache().put(BoxesRunTime.boxToLong((long)batchId2), metadata);
        return future;
    }

    private CompletableFuture<Object> addNewBatchByStreamAsync(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            future.complete(BoxesRunTime.boxToBoolean((boolean)false));
            return future;
        }
        this.executorService.submit(new Runnable(this, batchMetadataFile, future, fn, batchId){
            private final /* synthetic */ AsyncOffsetSeqLog $outer;
            private final Path batchMetadataFile$1;
            private final CompletableFuture future$1;
            private final Function1 fn$1;
            private final long batchId$2;

            public void run() {
                block3: {
                    try {
                        if (this.$outer.fileManager().exists(this.batchMetadataFile$1)) {
                            this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)false));
                            break block3;
                        }
                        long start = System.currentTimeMillis();
                        this.$outer.write(this.batchMetadataFile$1, (Function1<OutputStream, BoxedUnit>)this.fn$1);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Offset commit for batch ").append($this.batchId$2).append(" took").append(" ").append(System.currentTimeMillis() - start).append(" ms to be persisted to durable storage").toString());
                        this.$outer.writtenToDurableStorage().add(BoxesRunTime.boxToLong((long)this.batchId$2));
                        this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    catch (Throwable e) {
                        this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Encountered error while writing batch ").append($this.batchId$2).append(" to offset log").toString(), e);
                        this.future$1.completeExceptionally(e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchMetadataFile$1 = batchMetadataFile$1;
                this.future$1 = future$1;
                this.fn$1 = fn$1;
                this.batchId$2 = batchId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.execution.streaming.AsyncOffsetSeqLog$$anon$1 long ), $anonfun$run$2(org.apache.spark.sql.execution.streaming.AsyncOffsetSeqLog$$anon$1 )}, serializedLambda);
            }
        });
        return future;
    }

    @Override
    public void purge(long thresholdBatchId) {
        super.purge(thresholdBatchId);
    }

    public int pendingAsyncOffsetWrite() {
        return this.pendingOffsetWrites().size();
    }

    public static final /* synthetic */ long $anonfun$addAsync$3(long batchId$1, boolean ret) {
        if (ret) {
            return batchId$1;
        }
        throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(batchId$1);
    }

    private final CompletableFuture issueAsyncWrite$1(long batchId, OffsetSeq metadata$1) {
        this.lastCommitIssuedTimestampMs().set(this.clock.getTimeMillis());
        CompletionStage future = this.addNewBatchByStreamAsync(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)output -> {
            this.serialize(metadata$1, output);
            return BoxedUnit.UNIT;
        }).thenApply(ret -> BoxesRunTime.boxToLong((long)AsyncOffsetSeqLog.$anonfun$addAsync$3(batchId, BoxesRunTime.unboxToBoolean((Object)ret))));
        this.pendingOffsetWrites().put(BoxesRunTime.boxToLong((long)batchId), (CompletableFuture<Object>)future);
        return future;
    }

    public static final /* synthetic */ Tuple2 $anonfun$addAsync$4(long batchId) {
        return new Tuple2.mcJZ.sp(batchId, true);
    }

    public static final /* synthetic */ Tuple2 $anonfun$addAsync$5(long batchId) {
        return new Tuple2.mcJZ.sp(batchId, true);
    }

    public AsyncOffsetSeqLog(SparkSession sparkSession, String path, ThreadPoolExecutor executorService, long offsetCommitIntervalMs, Clock clock) {
        this.executorService = executorService;
        this.offsetCommitIntervalMs = offsetCommitIntervalMs;
        this.clock = clock;
        super(sparkSession, path);
        Predef$.MODULE$.assert(this.metadataCacheEnabled());
        this.pendingOffsetWrites = new ConcurrentHashMap();
        this.lastCommitIssuedTimestampMs = new AtomicLong(-1L);
        this.writtenToDurableStorage = new ConcurrentLinkedDeque(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.listBatchesOnDisk())).toList()).asJavaCollection());
    }
}

