/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import java.io.Serializable;
import org.apache.spark.ml.linalg.JsonMatrixConverter$;
import org.apache.spark.ml.linalg.JsonVectorConverter$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005%d\u0001B\u000e\u001d\u0001\u001dB\u0001b\u000f\u0001\u0003\u0006\u0004%\t\u0001\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005{!Aa\t\u0001BC\u0002\u0013\u0005A\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003>\u0011!A\u0005A!b\u0001\n\u0003a\u0004\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011)\u0003!Q1A\u0005\u0002-C\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\u0006=\u0002!\ta\u0018\u0005\u0006=\u0002!\tA\u001a\u0005\u0006=\u0002!\t!\u001d\u0005\u0006=\u0002!\t!\u001e\u0005\u0007s\u0002!\t\u0001\b>\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t\t\u0003\u0001Q\u0001\nuBq!a\t\u0001\t\u000b\n)\u0003C\u0004\u0002(\u0001!)%!\u000b\t\u000f\u0005E\u0002\u0001\"\u0012\u00024\u001dA\u0011\u0011\b\u000f\t\u0002y\tYDB\u0004\u001c9!\u0005a$!\u0010\t\ry;B\u0011AA'\u0011\u001d\tIb\u0006C\u0001\u0003\u001fB\u0011\"!\u0017\u0018\u0003\u0003%I!a\u0017\u0003\u000bA\u000b'/Y7\u000b\u0005uq\u0012!\u00029be\u0006l'BA\u0010!\u0003\tiGN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001)\"\u0001K)\u0014\u0007\u0001Is\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0004B]f\u0014VM\u001a\t\u0003aar!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Q2\u0013A\u0002\u001fs_>$h(C\u0001-\u0013\t94&A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$\u0001D*fe&\fG.\u001b>bE2,'BA\u001c,\u0003\u0019\u0001\u0018M]3oiV\tQ\b\u0005\u0002?\u0005:\u0011q\b\u0011\t\u0003e-J!!Q\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003.\nq\u0001]1sK:$\b%\u0001\u0003oC6,\u0017!\u00028b[\u0016\u0004\u0013a\u00013pG\u0006!Am\\2!\u0003\u001dI7OV1mS\u0012,\u0012\u0001\u0014\t\u0005U5{%,\u0003\u0002OW\tIa)\u001e8di&|g.\r\t\u0003!Fc\u0001\u0001B\u0003S\u0001\t\u00071KA\u0001U#\t!v\u000b\u0005\u0002++&\u0011ak\u000b\u0002\b\u001d>$\b.\u001b8h!\tQ\u0003,\u0003\u0002ZW\t\u0019\u0011I\\=\u0011\u0005)Z\u0016B\u0001/,\u0005\u001d\u0011un\u001c7fC:\f\u0001\"[:WC2LG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0001\u00147\rZ3\u0011\u0007\u0005\u0004q*D\u0001\u001d\u0011\u0015Y\u0014\u00021\u0001>\u0011\u00151\u0015\u00021\u0001>\u0011\u0015A\u0015\u00021\u0001>\u0011\u0015Q\u0015\u00021\u0001M)\u0015\u0001wM\\8q\u0011\u0015Y$\u00021\u0001i!\tIG.D\u0001k\u0015\tYg$\u0001\u0003vi&d\u0017BA7k\u00051IE-\u001a8uS\u001aL\u0017M\u00197f\u0011\u00151%\u00021\u0001>\u0011\u0015A%\u00021\u0001>\u0011\u0015Q%\u00021\u0001M)\u0011\u0001'o\u001d;\t\u000bmZ\u0001\u0019A\u001f\t\u000b\u0019[\u0001\u0019A\u001f\t\u000b![\u0001\u0019A\u001f\u0015\t\u00014x\u000f\u001f\u0005\u0006w1\u0001\r\u0001\u001b\u0005\u0006\r2\u0001\r!\u0010\u0005\u0006\u00112\u0001\r!P\u0001\tm\u0006d\u0017\u000eZ1uKR\u00111P \t\u0003UqL!!`\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007f6\u0001\raT\u0001\u0006m\u0006dW/Z\u0001\u0002oR!\u0011QAA\u0006!\u0011\t\u0017qA(\n\u0007\u0005%ADA\u0005QCJ\fW\u000eU1je\")qP\u0004a\u0001\u001f\u0006qA%\\5okN$sM]3bi\u0016\u0014H\u0003BA\u0003\u0003#AQa`\bA\u0002=\u000b!B[:p]\u0016s7m\u001c3f)\ri\u0014q\u0003\u0005\u0006\u007fB\u0001\raT\u0001\u000bUN|g\u000eR3d_\u0012,GcA(\u0002\u001e!1\u0011qD\tA\u0002u\nAA[:p]\u0006!2\u000f\u001e:j]\u001e\u0014V\r\u001d:fg\u0016tG/\u0019;j_:\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002{\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002,A\u0019!&!\f\n\u0007\u0005=2FA\u0002J]R\fa!Z9vC2\u001cHc\u0001.\u00026!1\u0011qG\u000bA\u0002]\u000b1a\u001c2k\u0003\u0015\u0001\u0016M]1n!\t\twc\u0005\u0003\u0018S\u0005}\u0002\u0003BA!\u0003\u0017j!!a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0003S>T!!!\u0013\u0002\t)\fg/Y\u0005\u0004s\u0005\rCCAA\u001e+\u0011\t\t&!\u0016\u0015\t\u0005M\u0013q\u000b\t\u0004!\u0006UC!\u0002*\u001a\u0005\u0004\u0019\u0006BBA\u00103\u0001\u0007Q(\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002^A!\u0011qLA3\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u001d\u0013\u0001\u00027b]\u001eLA!a\u001a\u0002b\t1qJ\u00196fGR\u0004")
public class Param<T>
implements Serializable {
    private final String parent;
    private final String name;
    private final String doc;
    private final Function1<T, Object> isValid;
    private final String stringRepresentation;

    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public String doc() {
        return this.doc;
    }

    public Function1<T, Object> isValid() {
        return this.isValid;
    }

    public void validate(T value) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.isValid().apply(value))) {
            String string;
            T t = value;
            if (ScalaRunTime$.MODULE$.isArray(t, 1)) {
                T t2 = t;
                string = Predef$.MODULE$.genericWrapArray(t2).mkString("[", ",", "]");
            } else {
                string = value.toString();
            }
            String valueToString = string;
            throw new IllegalArgumentException(new StringBuilder(33).append(this.parent()).append(" parameter ").append(this.name()).append(" given invalid value ").append(valueToString).append(".").toString());
        }
    }

    public ParamPair<T> w(T value) {
        return this.$minus$greater(value);
    }

    public ParamPair<T> $minus$greater(T value) {
        return new ParamPair<T>(this, value);
    }

    public String jsonEncode(T value) {
        String string;
        T t = value;
        if (t instanceof String) {
            String string2 = (String)t;
            JsonAST.JString x$1 = package$.MODULE$.JString().apply(string2);
            Formats x$2 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$1);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$1, x$2));
        } else if (t instanceof Vector) {
            T t2 = t;
            string = JsonVectorConverter$.MODULE$.toJson((Vector)t2);
        } else if (t instanceof Matrix) {
            T t3 = t;
            string = JsonMatrixConverter$.MODULE$.toJson((Matrix)t3);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(64).append("The default jsonEncode only supports string, vector and matrix. ").append(new StringBuilder(31).append(this.getClass().getName()).append(" must override jsonEncode for ").append(value.getClass().getName()).append(".").toString()).toString());
        }
        return string;
    }

    public T jsonDecode(String json) {
        return Param$.MODULE$.jsonDecode(json);
    }

    public final String toString() {
        return this.stringRepresentation;
    }

    public final int hashCode() {
        return Statics.anyHash((Object)this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Param)) return false;
        Param param = (Param)object;
        String string = param.parent();
        String string2 = this.parent();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = param.name();
        String string4 = this.name();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public Param(String parent, String name, String doc, Function1<T, Object> isValid) {
        this.parent = parent;
        this.name = name;
        this.doc = doc;
        this.isValid = isValid;
        this.stringRepresentation = new StringBuilder(2).append(parent).append("__").append(name).toString();
    }

    public Param(Identifiable parent, String name, String doc, Function1<T, Object> isValid) {
        this(parent.uid(), name, doc, isValid);
    }

    public Param(String parent, String name, String doc) {
        this(parent, name, doc, ParamValidators$.MODULE$.alwaysTrue());
    }

    public Param(Identifiable parent, String name, String doc) {
        this(parent.uid(), name, doc);
    }
}

