/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.storage.Zero$;
import java.io.Serializable;
import org.apache.spark.mllib.clustering.ExpectationSum;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;

public final class ExpectationSum$
implements Serializable {
    public static final ExpectationSum$ MODULE$ = new ExpectationSum$();

    public ExpectationSum zero(int k, int d) {
        return new ExpectationSum(0.0, (double[])Array$.MODULE$.fill(k, (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0, (ClassTag)ClassTag$.MODULE$.Double()), (DenseVector[])Array$.MODULE$.fill(k, (Function0 & Serializable)() -> DenseVector$.MODULE$.zeros$mDc$sp(d, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), ClassTag$.MODULE$.apply(DenseVector.class)), (DenseMatrix[])Array$.MODULE$.fill(k, (Function0 & Serializable)() -> DenseMatrix$.MODULE$.zeros$mDc$sp(d, d, (ClassTag)ClassTag$.MODULE$.Double(), Zero$.MODULE$.DoubleZero()), ClassTag$.MODULE$.apply(DenseMatrix.class)));
    }

    public ExpectationSum add(double[] weights, MultivariateGaussian[] dists, ExpectationSum sums, Vector<Object> x) {
        double[] p = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.doubleArrayOps(weights), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])dists))), (Function1 & Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)ExpectationSum$.$anonfun$add$1(x, x0$1)), (ClassTag)ClassTag$.MODULE$.Double());
        double pSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(p).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        sums.logLikelihood_$eq(sums.logLikelihood() + package$.MODULE$.log(pSum));
        for (int i = 0; i < sums.k(); ++i) {
            int n = i;
            p[n] = p[n] / pSum;
            int n2 = i;
            sums.weights()[n2] = sums.weights()[n2] + p[i];
            sums.means()[i].$plus$eq(x.$times((Object)BoxesRunTime.boxToDouble((double)p[i]), (UFunc.UImpl2)HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix()), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_DV_V_zero_idempotent_Double_OpAdd());
            BLAS$.MODULE$.syr(p[i], Vectors$.MODULE$.fromBreeze(x), (org.apache.spark.mllib.linalg.DenseMatrix)Matrices$.MODULE$.fromBreeze((Matrix<Object>)sums.sigmas()[i]));
        }
        return sums;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExpectationSum$.class);
    }

    public static final /* synthetic */ double $anonfun$add$1(Vector x$7, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double weight = tuple2._1$mcD$sp();
        MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
        double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((Vector<Object>)x$7);
        return d;
    }

    private ExpectationSum$() {
    }
}

