/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.AlterTableSetLocationCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ug\u0001B\u000e\u001d\u0001&B\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t!\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0011\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005l\u0001\tE\t\u0015!\u0003T\u0011!a\u0007A!f\u0001\n\u0003i\u0007\u0002\u0003<\u0001\u0005#\u0005\u000b\u0011\u00028\t\u000b]\u0004A\u0011\u0001=\t\u000bu\u0004A\u0011\t@\t\u0013\u0005]\u0001!!A\u0005\u0002\u0005e\u0001\"CA\u0011\u0001E\u0005I\u0011AA\u0012\u0011%\tI\u0004AI\u0001\n\u0003\tY\u0004C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013q\t\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u0005=\u0004!!A\u0005B\u0005E\u0004\"CA@\u0001\u0005\u0005I\u0011AAA\u0011%\tY\tAA\u0001\n\u0003\ni\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\u001eI\u0011q\u0013\u000f\u0002\u0002#\u0005\u0011\u0011\u0014\u0004\t7q\t\t\u0011#\u0001\u0002\u001c\"1q/\u0006C\u0001\u0003gC\u0011\"!.\u0016\u0003\u0003%)%a.\t\u0013\u0005eV#!A\u0005\u0002\u0006m\u0006\"CAb+\u0005\u0005I\u0011QAc\u0011%\t\u0019.FA\u0001\n\u0013\t)N\u0001\u000fBYR,'\u000fV1cY\u0016\u001cV\r\u001e'pG\u0006$\u0018n\u001c8D_6l\u0017M\u001c3\u000b\u0005uq\u0012aB2p[6\fg\u000e\u001a\u0006\u0003?\u0001\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0005\u0012\u0013aA:rY*\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001QC\u0007\u000f \u0011\u0005-\u0012T\"\u0001\u0017\u000b\u00055r\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003_A\nQ\u0001\u001d7b]NT!!\r\u0011\u0002\u0011\r\fG/\u00197zgRL!a\r\u0017\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003kYj\u0011\u0001H\u0005\u0003oq\u00111\u0003T3bMJ+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002@\u000f:\u0011\u0001)\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\"\na\u0001\u0010:p_Rt\u0014\"A\u001e\n\u0005\u0019S\u0014a\u00029bG.\fw-Z\u0005\u0003\u0011&\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0012\u001e\u0002\u0013Q\f'\r\\3OC6,W#\u0001'\u0011\u00055sU\"\u0001\u0019\n\u0005=\u0003$a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\u0002\u0015Q\f'\r\\3OC6,\u0007%A\u0007qCJ$\u0018\u000e^5p]N\u0003XmY\u000b\u0002'B\u0019\u0011\b\u0016,\n\u0005US$AB(qi&|g\u000e\u0005\u0002XQ:\u0011\u0001,\u001a\b\u00033\u000et!A\u00172\u000f\u0005m\u000bgB\u0001/a\u001d\tivL\u0004\u0002B=&\tq%\u0003\u0002&M%\u00111\u0005J\u0005\u0003C\tJ!!\r\u0011\n\u0005\u0011\u0004\u0014aB2bi\u0006dwnZ\u0005\u0003M\u001e\fAbQ1uC2|w\rV=qKNT!\u0001\u001a\u0019\n\u0005%T'A\u0005+bE2,\u0007+\u0019:uSRLwN\\*qK\u000eT!AZ4\u0002\u001dA\f'\u000f^5uS>t7\u000b]3dA\u0005AAn\\2bi&|g.F\u0001o!\ty7O\u0004\u0002qcB\u0011\u0011IO\u0005\u0003ej\na\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!OO\u0001\nY>\u001c\u0017\r^5p]\u0002\na\u0001P5oSRtD\u0003B={wr\u0004\"!\u000e\u0001\t\u000b);\u0001\u0019\u0001'\t\u000bE;\u0001\u0019A*\t\u000b1<\u0001\u0019\u00018\u0002\u0007I,h\u000eF\u0002\u0000\u0003\u001b\u0001RaPA\u0001\u0003\u000bI1!a\u0001J\u0005\r\u0019V-\u001d\t\u0005\u0003\u000f\tI!D\u0001!\u0013\r\tY\u0001\t\u0002\u0004%><\bbBA\b\u0011\u0001\u0007\u0011\u0011C\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003\u000f\t\u0019\"C\u0002\u0002\u0016\u0001\u0012Ab\u00159be.\u001cVm]:j_:\fAaY8qsR9\u00110a\u0007\u0002\u001e\u0005}\u0001b\u0002&\n!\u0003\u0005\r\u0001\u0014\u0005\b#&\u0001\n\u00111\u0001T\u0011\u001da\u0017\u0002%AA\u00029\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002&)\u001aA*a\n,\u0005\u0005%\u0002\u0003BA\u0016\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\r;\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003o\tiCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002>)\u001a1+a\n\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\t\u0016\u0004]\u0006\u001d\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002JA!\u00111JA+\u001b\t\tiE\u0003\u0003\u0002P\u0005E\u0013\u0001\u00027b]\u001eT!!a\u0015\u0002\t)\fg/Y\u0005\u0004i\u00065\u0013\u0001\u00049s_\u0012,8\r^!sSRLXCAA.!\rI\u0014QL\u0005\u0004\u0003?R$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA3\u0003W\u00022!OA4\u0013\r\tIG\u000f\u0002\u0004\u0003:L\b\"CA7\u001f\u0005\u0005\t\u0019AA.\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000f\t\u0007\u0003k\nY(!\u001a\u000e\u0005\u0005]$bAA=u\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u0014q\u000f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0004\u0006%\u0005cA\u001d\u0002\u0006&\u0019\u0011q\u0011\u001e\u0003\u000f\t{w\u000e\\3b]\"I\u0011QN\t\u0002\u0002\u0003\u0007\u0011QM\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002J\u0005=\u0005\"CA7%\u0005\u0005\t\u0019AA.\u0003\u0019)\u0017/^1mgR!\u00111QAK\u0011%\tigEA\u0001\u0002\u0004\t)'\u0001\u000fBYR,'\u000fV1cY\u0016\u001cV\r\u001e'pG\u0006$\u0018n\u001c8D_6l\u0017M\u001c3\u0011\u0005U*2#B\u000b\u0002\u001e\u0006%\u0006\u0003CAP\u0003Kc5K\\=\u000e\u0005\u0005\u0005&bAARu\u00059!/\u001e8uS6,\u0017\u0002BAT\u0003C\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84!\u0011\tY+!-\u000e\u0005\u00055&\u0002BAX\u0003#\n!![8\n\u0007!\u000bi\u000b\u0006\u0002\u0002\u001a\u0006AAo\\*ue&tw\r\u0006\u0002\u0002J\u0005)\u0011\r\u001d9msR9\u00110!0\u0002@\u0006\u0005\u0007\"\u0002&\u0019\u0001\u0004a\u0005\"B)\u0019\u0001\u0004\u0019\u0006\"\u00027\u0019\u0001\u0004q\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u000f\fy\r\u0005\u0003:)\u0006%\u0007CB\u001d\u0002L2\u001bf.C\u0002\u0002Nj\u0012a\u0001V;qY\u0016\u001c\u0004\u0002CAi3\u0005\u0005\t\u0019A=\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002XB!\u00111JAm\u0013\u0011\tY.!\u0014\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableSetLocationCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;
    private final String location;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Option<Map<String, String>>, String>> unapply(AlterTableSetLocationCommand x$0) {
        return AlterTableSetLocationCommand$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<TableIdentifier, Option<Map<String, String>>, String>, AlterTableSetLocationCommand> tupled() {
        return AlterTableSetLocationCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, Function1<String, AlterTableSetLocationCommand>>> curried() {
        return AlterTableSetLocationCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableSetLocationCommand alterTableSetLocationCommand = this;
        synchronized (alterTableSetLocationCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    public String location() {
        return this.location;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        URI locUri = CatalogUtils$.MODULE$.stringToURI(this.location());
        Option<Map<String, String>> option = this.partitionSpec();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map spec = (Map)some.value();
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE ... SET LOCATION");
            Map normalizedSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, table.partitionSchema(), table.identifier().quotedString(), sparkSession.sessionState().conf().resolver());
            CatalogTablePartition part = catalog.getPartition(table.identifier(), normalizedSpec);
            CatalogStorageFormat x$1 = part.storage().copy((Option)new Some((Object)locUri), part.storage().copy$default$2(), part.storage().copy$default$3(), part.storage().copy$default$4(), part.storage().copy$default$5(), part.storage().copy$default$6());
            Map x$2 = part.copy$default$1();
            Map x$3 = part.copy$default$3();
            long x$4 = part.copy$default$4();
            long x$5 = part.copy$default$5();
            Option x$6 = part.copy$default$6();
            CatalogTablePartition newPart = part.copy(x$2, x$1, x$3, x$4, x$5, x$6);
            catalog.alterPartitions(table.identifier(), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{newPart})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            catalog.alterTable(table.withNewStorage((Option)new Some((Object)locUri), table.withNewStorage$default$2(), table.withNewStorage$default$3(), table.withNewStorage$default$4(), table.withNewStorage$default$5(), table.withNewStorage$default$6()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        sparkSession.catalog().refreshTable(table.identifier().quotedString());
        CommandUtils$.MODULE$.updateTableStats(sparkSession, table);
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public AlterTableSetLocationCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec, String location) {
        return new AlterTableSetLocationCommand(tableName, partitionSpec, location);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String copy$default$3() {
        return this.location();
    }

    public String productPrefix() {
        return "AlterTableSetLocationCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.partitionSpec();
                break;
            }
            case 2: {
                object = this.location();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableSetLocationCommand;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "tableName";
                break;
            }
            case 1: {
                string = "partitionSpec";
                break;
            }
            case 2: {
                string = "location";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableSetLocationCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableSetLocationCommand alterTableSetLocationCommand = (AlterTableSetLocationCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableSetLocationCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = alterTableSetLocationCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string = this.location();
        String string2 = alterTableSetLocationCommand.location();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableSetLocationCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableSetLocationCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec, String location) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.location = location;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        Statics.releaseFence();
    }
}

