/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ConditionalExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="CASE WHEN expr1 THEN expr2 [WHEN expr3 THEN expr4]* [ELSE expr5] END - When `expr1` = true, returns `expr2`; else when `expr3` = true, returns `expr4`; else returns `expr5`.", arguments="\n    Arguments:\n      * expr1, expr3 - the branch condition expressions should all be boolean type.\n      * expr2, expr4, expr5 - the branch value expressions and else value expression should all be\n          same type or coercible to a common type.\n  ", examples="\n    Examples:\n      > SELECT CASE WHEN 1 > 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       1.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 > 0 THEN 2.0 ELSE 1.2 END;\n       2.0\n      > SELECT CASE WHEN 1 < 0 THEN 1 WHEN 2 < 0 THEN 2.0 END;\n       NULL\n  ", since="1.0.1", group="conditional_funcs")
@ScalaSignature(bytes="\u0006\u0005\tmd\u0001\u0002\u0015*\u0001ZB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\t7\u0002\u0011\t\u0012)A\u0005+\"AA\f\u0001BK\u0002\u0013\u0005Q\f\u0003\u0005b\u0001\tE\t\u0015!\u0003_\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001dQ\u0007A1A\u0005F-Dq!!\u0002\u0001A\u00035A\u000eC\u0004\u0002\b\u0001!\t&!\u0003\t\u0015\u0005U\u0001\u0001#b\u0001\n\u0003\n9\u0002C\u0004\u00020\u0001!\t%!\r\t\u000f\u0005e\u0002\u0001\"\u0011\u0002<!1\u0011\u0011\n\u0001\u0005B!Dq!a\u0013\u0001\t\u0003\ni\u0005C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!1a\u0006\u0001C!\u0003wBq!! \u0001\t\u0013\ty\bC\u0004\u0002\u001c\u0002!\t%!(\t\u0013\u0005\r\u0006!!A\u0005\u0002\u0005\u0015\u0006\"CAV\u0001E\u0005I\u0011AAW\u0011%\t\u0019\rAI\u0001\n\u0003\t)\rC\u0005\u0002J\u0002\t\t\u0011\"\u0011\u0002L\"I\u00111\u001c\u0001\u0002\u0002\u0013\u0005\u0011Q\u001c\u0005\n\u0003K\u0004\u0011\u0011!C\u0001\u0003OD\u0011\"!<\u0001\u0003\u0003%\t%a<\t\u0013\u0005u\b!!A\u0005\u0002\u0005}\b\"\u0003B\u0002\u0001\u0005\u0005I\u0011\tB\u0003\u0011%\u0011I\u0001AA\u0001\n\u0003\u0012YaB\u0004\u00036%B\tAa\u000e\u0007\r!J\u0003\u0012\u0001B\u001d\u0011\u0019\u0011w\u0004\"\u0001\u0003L!9!QJ\u0010\u0005\u0002\t=\u0003b\u0002B+?\u0011\u0005!q\u000b\u0005\n\u0005\u001bz\u0012\u0011!CA\u00057B\u0011B!\u0019 #\u0003%\t!!2\t\u0013\t\rt$!A\u0005\u0002\n\u0015\u0004\"\u0003B8?E\u0005I\u0011AAc\u0011%\u0011\thHA\u0001\n\u0013\u0011\u0019H\u0001\u0005DCN,w\u000b[3o\u0015\tQ3&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0017.\u0003!\u0019\u0017\r^1msN$(B\u0001\u00180\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003aE\nQa\u001d9be.T!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO\u000e\u00011C\u0002\u00018wy\nu\t\u0005\u00029s5\t\u0011&\u0003\u0002;S\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005ab\u0014BA\u001f*\u0005q\u0019u.\u001c9mKb$\u0016\u0010]3NKJ<\u0017N\\4FqB\u0014Xm]:j_:\u0004\"\u0001O \n\u0005\u0001K#!F\"p]\u0012LG/[8oC2,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0011\u0002\b!J|G-^2u!\tA\u0005K\u0004\u0002J\u001d:\u0011!*T\u0007\u0002\u0017*\u0011A*N\u0001\u0007yI|w\u000e\u001e \n\u0003\u0011K!aT\"\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u001f\u000e\u000b\u0001B\u0019:b]\u000eDWm]\u000b\u0002+B\u0019\u0001J\u0016-\n\u0005]\u0013&aA*fcB!!)W\u001c8\u0013\tQ6I\u0001\u0004UkBdWMM\u0001\nEJ\fgn\u00195fg\u0002\n\u0011\"\u001a7tKZ\u000bG.^3\u0016\u0003y\u00032AQ08\u0013\t\u00017I\u0001\u0004PaRLwN\\\u0001\u000bK2\u001cXMV1mk\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0002eK\u001a\u0004\"\u0001\u000f\u0001\t\u000bM+\u0001\u0019A+\t\u000fq+\u0001\u0013!a\u0001=\u0006A1\r[5mIJ,g.F\u0001j!\rAekN\u0001\r]>$W\rU1ui\u0016\u0014hn]\u000b\u0002YB\u0019\u0001JV7\u0011\u00059|hBA8}\u001d\t\u0001(P\u0004\u0002rs:\u0011!\u000f\u001f\b\u0003g^t!\u0001\u001e<\u000f\u0005)+\u0018\"\u0001\u001b\n\u0005I\u001a\u0014B\u0001\u00192\u0013\tqs&\u0003\u0002-[%\u00111pK\u0001\u0006iJ,Wm]\u0005\u0003{z\f1\u0002\u0016:fKB\u000bG\u000f^3s]*\u00111pK\u0005\u0005\u0003\u0003\t\u0019AA\u0006Ue\u0016,\u0007+\u0019;uKJt'BA?\u007f\u00035qw\u000eZ3QCR$XM\u001d8tA\u00059r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004o\u0005-\u0001bBA\u0007\u0013\u0001\u0007\u0011qB\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003I\u0003#9\u0014bAA\n%\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002)%t\u0007/\u001e;UsB,7OR8s\u001b\u0016\u0014x-\u001b8h+\t\tI\u0002\u0005\u0003I-\u0006m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005R&A\u0003usB,7/\u0003\u0003\u0002&\u0005}!\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0007)\tI\u0003E\u0002C\u0003WI1!!\fD\u0005%!(/\u00198tS\u0016tG/\u0001\u0005ok2d\u0017M\u00197f+\t\t\u0019\u0004E\u0002C\u0003kI1!a\u000eD\u0005\u001d\u0011un\u001c7fC:\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!!\u0010\u0011\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011,\u0003!\tg.\u00197zg&\u001c\u0018\u0002BA$\u0003\u0003\u0012q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u0016C2<\u0018-_:Fm\u0006dW/\u0019;fI&s\u0007/\u001e;t\u00031\u0011'/\u00198dQ\u001e\u0013x.\u001e9t+\t\ty\u0005E\u0002I-&\fA!\u001a<bYR!\u0011QKA.!\r\u0011\u0015qK\u0005\u0004\u00033\u001a%aA!os\"I\u0011QL\b\u0011\u0002\u0003\u0007\u0011qL\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003C\n\u0019'D\u0001,\u0013\r\t)g\u000b\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0005u_N#(/\u001b8h)\t\tY\u0007\u0005\u0003\u0002n\u0005Ud\u0002BA8\u0003c\u0002\"AS\"\n\u0007\u0005M4)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003o\nIH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003g\u001aUCAA6\u0003QiW\u000f\u001c;j\u0005J\fgn\u00195fg\u000e{G-Z4f]R1\u0011\u0011QAG\u0003/\u0003B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000fK\u0013aB2pI\u0016<WM\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tyI\u0005a\u0001\u0003#\u000b1a\u0019;y!\u0011\t\u0019)a%\n\t\u0005U\u0015Q\u0011\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tIJ\u0005a\u0001\u0003\u0003\u000b!!\u001a<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBAA\u0003?\u000b\t\u000bC\u0004\u0002\u0010N\u0001\r!!%\t\u000f\u0005e5\u00031\u0001\u0002\u0002\u0006!1m\u001c9z)\u0015!\u0017qUAU\u0011\u001d\u0019F\u0003%AA\u0002UCq\u0001\u0018\u000b\u0011\u0002\u0003\u0007a,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005=&fA+\u00022.\u0012\u00111\u0017\t\u0005\u0003k\u000by,\u0004\u0002\u00028*!\u0011\u0011XA^\u0003%)hn\u00195fG.,GMC\u0002\u0002>\u000e\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t-a.\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d'f\u00010\u00022\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!4\u0011\t\u0005=\u0017\u0011\\\u0007\u0003\u0003#TA!a5\u0002V\u0006!A.\u00198h\u0015\t\t9.\u0001\u0003kCZ\f\u0017\u0002BA<\u0003#\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a8\u0011\u0007\t\u000b\t/C\u0002\u0002d\u000e\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0016\u0002j\"I\u00111^\r\u0002\u0002\u0003\u0007\u0011q\\\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\bCBAz\u0003s\f)&\u0004\u0002\u0002v*\u0019\u0011q_\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002|\u0006U(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\r\u0003\u0002!I\u00111^\u000e\u0002\u0002\u0003\u0007\u0011QK\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002N\n\u001d\u0001\"CAv9\u0005\u0005\t\u0019AAp\u0003\u0019)\u0017/^1mgR!\u00111\u0007B\u0007\u0011%\tY/HA\u0001\u0002\u0004\t)\u0006K\f\u0001\u0005#\u00119B!\u0007\u0003\u001e\t}!1\u0005B\u0013\u0005S\u0011YCa\f\u00032A\u0019\u0001Ha\u0005\n\u0007\tU\u0011FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tm\u0011!a\u0017D\u0003N+\u0005e\u0016%F\u001d\u0002*\u0007\u0010\u001d:2AQCUI\u0014\u0011fqB\u0014(\u0007I.X\u0011\u0016s\u0005%\u001a=qeN\u0002C\u000bS#OA\u0015D\bO\u001d\u001b^U\u0001ZV\tT*FA\u0015D\bO]\u001b^A\u0015sE\tI\u0017!/\",g\u000e\t1fqB\u0014\u0018\u0007\u0019\u0011>AQ\u0014X/\u001a\u0017!e\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:3An\u0002S\r\\:fA]DWM\u001c\u0011aKb\u0004(o\r1!{\u0001\"(/^3-AI,G/\u001e:og\u0002\u0002W\r\u001f9si\u0001\\\u0004%\u001a7tK\u0002\u0012X\r^;s]N\u0004\u0003-\u001a=qeV\u0002g&A\u0005be\u001e,X.\u001a8ug\u0006\u0012!\u0011E\u0001\u0002z*\u0001\u0003\u0005\t\u0011Be\u001e,X.\u001a8ugjR\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeFb\u0003%\u001a=qeN\u0002S\u0006\t;iK\u0002\u0012'/\u00198dQ\u0002\u001awN\u001c3ji&|g\u000eI3yaJ,7o]5p]N\u00043\u000f[8vY\u0012\u0004\u0013\r\u001c7!E\u0016\u0004#m\\8mK\u0006t\u0007\u0005^=qK:R\u0001\u0005\t\u0011!A\u0001R\u0003%\u001a=qeJb\u0003%\u001a=qeRb\u0003%\u001a=qeV\u0002S\u0006\t;iK\u0002\u0012'/\u00198dQ\u00022\u0018\r\\;fA\u0015D\bO]3tg&|gn\u001d\u0011b]\u0012\u0004S\r\\:fAY\fG.^3!Kb\u0004(/Z:tS>t\u0007e\u001d5pk2$\u0007%\u00197mA\t,'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!g\u0006lW\r\t;za\u0016\u0004sN\u001d\u0011d_\u0016\u00148-\u001b2mK\u0002\"x\u000eI1!G>lWn\u001c8!if\u0004XM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003(\u0005\u0011)A\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011D\u0003N+\u0005e\u0016%F\u001d\u0002\n\u0004E\u0010\u00111AQCUI\u0014\u00112A]CUI\u0014\u00113Ay\u0002\u0003\u0007\t+I\u000b:\u0003#G\f\u0019!\u000b2\u001bV\tI\u0019/e\u0001*e\nR\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!c9\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\"B'\u0016\u0003s\u000bS#OAE\u0002C\b\t\u0019!)\"+e\nI\u0019!/\"+e\n\t\u001a!}\u0001\u0002\u0004\u0005\u0016%F\u001d\u0002\u0012d\u0006\r\u0011F\u0019N+\u0005%\r\u00183A\u0015sEi\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113]AR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006eQ!T\u000b\u0002:\u0006*\u0012(!c\u0001b\u0004\u0005\r\u0011U\u0011\u0016s\u0005%\r\u0011X\u0011\u0016s\u0005E\r\u0011=AA\u0002C\u000bS#OAIr\u0003\u0007I#O\tnR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\u0017\u0003\u0015\td\u0006\r\u00182\u0003\u00159'o\\;qC\t\u0011\u0019$A\td_:$\u0017\u000e^5p]\u0006dwLZ;oGN\f\u0001bQ1tK^CWM\u001c\t\u0003q}\u0019Ra\bB\u001e\u0005\u0003\u00022A\u0011B\u001f\u0013\r\u0011yd\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bRAAa\u0012\u0002V\u0006\u0011\u0011n\\\u0005\u0004#\n\u0015CC\u0001B\u001c\u0003\u0015\t\u0007\u000f\u001d7z)\u0015!'\u0011\u000bB*\u0011\u0015\u0019\u0016\u00051\u0001V\u0011\u0015a\u0016\u00051\u00018\u0003A\u0019'/Z1uK\u001a\u0013x.\u001c)beN,'\u000fF\u0002e\u00053BQa\u0015\u0012A\u0002%$R\u0001\u001aB/\u0005?BQaU\u0012A\u0002UCq\u0001X\u0012\u0011\u0002\u0003\u0007a,A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$BAa\u001a\u0003lA!!i\u0018B5!\u0011\u0011\u0015,\u00160\t\u0011\t5T%!AA\u0002\u0011\f1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!Q\u000f\t\u0005\u0003\u001f\u00149(\u0003\u0003\u0003z\u0005E'AB(cU\u0016\u001cG\u000f")
public class CaseWhen
extends Expression
implements ComplexTypeMergingExpression,
ConditionalExpression,
Serializable {
    private transient Seq<DataType> inputTypesForMerging;
    private final Seq<Tuple2<Expression, Expression>> branches;
    private final Option<Expression> elseValue;
    private final Seq<Enumeration.Value> nodePatterns;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Expression> $lessinit$greater$default$2() {
        return CaseWhen$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Seq<Tuple2<Expression, Expression>>, Option<Expression>>> unapply(CaseWhen x$0) {
        return CaseWhen$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return CaseWhen$.MODULE$.apply$default$2();
    }

    public static CaseWhen createFromParser(Seq<Expression> branches) {
        return CaseWhen$.MODULE$.createFromParser(branches);
    }

    @Override
    public final boolean foldable() {
        return ConditionalExpression.foldable$(this);
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public DataType dataType() {
        return ComplexTypeMergingExpression.dataType$(this);
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return !this.bitmap$0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    public Seq<Tuple2<Expression, Expression>> branches() {
        return this.branches;
    }

    public Option<Expression> elseValue() {
        return this.elseValue;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)((IterableOps)this.branches().flatMap((Function1 & Serializable)b -> {
            Expression expression = (Expression)b._1();
            Expression expression2 = (Expression)b._2();
            return package$.MODULE$.Nil().$colon$colon((Object)expression2).$colon$colon((Object)expression);
        })).$plus$plus(this.elseValue());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return super.legacyWithNewChildren(newChildren);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        CaseWhen caseWhen = this;
        synchronized (caseWhen) {
            if (!this.bitmap$trans$0) {
                this.inputTypesForMerging = (Seq)((IterableOps)this.branches().map((Function1 & Serializable)x$1 -> ((Expression)x$1._2()).dataType())).$plus$plus((IterableOnce)this.elseValue().map((Function1 & Serializable)x$2 -> x$2.dataType()));
                this.bitmap$trans$0 = true;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return !this.bitmap$trans$0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    @Override
    public boolean nullable() {
        return this.branches().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$nullable$1(x$3))) || BoxesRunTime.unboxToBoolean((Object)this.elseValue().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.nullable())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        if (TypeCoercion$.MODULE$.haveSameType(this.inputTypesForMerging())) {
            if (this.branches().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$2(x$5)))) {
                typeCheckResult = TypeCheckResult$TypeCheckSuccess$.MODULE$;
            } else {
                int index = this.branches().indexWhere((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CaseWhen.$anonfun$checkInputDataTypes$3(x$6)));
                typeCheckResult = new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)Integer.toString(index + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)BooleanType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)TypeUtils$.MODULE$.toSQLExpr((Expression)((Tuple2)this.branches().apply(index))._1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)((Expression)((Tuple2)this.branches().apply(index))._1()).dataType()))}))));
            }
        } else {
            typeCheckResult = new TypeCheckResult.DataTypeMismatch("DATA_DIFF_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)TypeUtils$.MODULE$.toSQLId(this.prettyName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)((IterableOnceOps)this.inputTypesForMerging().map((Function1 & Serializable)t -> TypeUtils$.MODULE$.toSQLType((AbstractDataType)t))).mkString("[", ", ", "]"))}))));
        }
        return typeCheckResult;
    }

    @Override
    public Seq<Expression> alwaysEvaluatedInputs() {
        Expression expression = (Expression)this.children().head();
        return package$.MODULE$.Nil().$colon$colon((Object)expression);
    }

    @Override
    public Seq<Seq<Expression>> branchGroups() {
        Nil$ conditions = this.branches().length() > 1 ? (Seq)this.branches().map((Function1 & Serializable)x$7 -> (Expression)x$7._1()) : package$.MODULE$.Nil();
        Nil$ values = this.elseValue().nonEmpty() ? (Seq)((IterableOps)this.branches().map((Function1 & Serializable)x$8 -> (Expression)x$8._2())).$plus$plus(this.elseValue()) : package$.MODULE$.Nil();
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{conditions, values}));
    }

    @Override
    public Object eval(InternalRow input) {
        int size = this.branches().size();
        for (int i = 0; i < size; ++i) {
            if (!Boolean.TRUE.equals(((Expression)((Tuple2)this.branches().apply(i))._1()).eval(input))) continue;
            return ((Expression)((Tuple2)this.branches().apply(i))._2()).eval(input);
        }
        return this.elseValue().isDefined() ? ((Expression)this.elseValue().get()).eval(input) : null;
    }

    @Override
    public String toString() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c).append(" THEN ").append(v).toString();
            return string;
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$9 -> new StringBuilder(6).append(" ELSE ").append(x$9).toString()).getOrElse((Function0 & Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    @Override
    public String sql() {
        String cases = ((IterableOnceOps)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression c = (Expression)tuple2._1();
            Expression v = (Expression)tuple2._2();
            String string = new StringBuilder(12).append(" WHEN ").append(c.sql()).append(" THEN ").append(v.sql()).toString();
            return string;
        })).mkString();
        String elseCase = (String)this.elseValue().map((Function1 & Serializable)x$10 -> new StringBuilder(6).append(" ELSE ").append(x$10.sql()).toString()).getOrElse((Function0 & Serializable)() -> "");
        return new StringBuilder(8).append("CASE").append(cases).append(elseCase).append(" END").toString();
    }

    private ExprCode multiBranchesCodegen(CodegenContext ctx, ExprCode ev) {
        Seq allConditions;
        int NOT_MATCHED = -1;
        int HAS_NONNULL = 0;
        int HAS_NULL = 1;
        String resultState = ctx.freshName("caseWhenResultState");
        ev.value_$eq(JavaCode$.MODULE$.global(ctx.addMutableState(CodeGenerator$.MODULE$.javaType(this.dataType()), ExprValue$.MODULE$.exprValueToString(ev.value()), ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5()), this.dataType()));
        Seq cases = (Seq)this.branches().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Expression condExpr = (Expression)tuple2._1();
            Expression valueExpr = (Expression)tuple2._2();
            ExprCode cond = condExpr.genCode(ctx);
            ExprCode res = valueExpr.genCode(ctx);
            String string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |").append(cond.code()).append("\n         |if (!").append(cond.isNull()).append(" && ").append(cond.value()).append(") {\n         |  ").append(res.code()).append("\n         |  ").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |  ").append(ev.value()).append(" = ").append(res.value()).append(";\n         |  continue;\n         |}\n       ").toString()));
            return string;
        });
        Option elseCode = this.elseValue().map((Function1 & Serializable)elseExpr -> {
            ExprCode res = elseExpr.genCode(ctx);
            return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(63).append("\n         |").append(res.code()).append("\n         |").append(resultState).append(" = (byte)(").append(res.isNull()).append(" ? ").append(HAS_NULL).append(" : ").append(HAS_NONNULL).append(");\n         |").append(ev.value()).append(" = ").append(res.value()).append(";\n       ").toString()));
        });
        Seq x$1 = allConditions = (Seq)cases.$plus$plus((IterableOnce)elseCode);
        String x$2 = "caseWhen";
        String x$3 = "byte";
        Function1 & Serializable x$4 = (Function1 & Serializable)func -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append("byte").append(" ").append(resultState).append(" = ").append(NOT_MATCHED).append(";\n           |do {\n           |  ").append((String)func).append("\n           |} while (false);\n           |return ").append(resultState).append(";\n         ").toString()));
        Function1 & Serializable x$5 = (Function1 & Serializable)x$11 -> ((IterableOnceOps)x$11.map((Function1 & Serializable)funcCall -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n           |").append(resultState).append(" = ").append((String)funcCall).append(";\n           |if (").append(resultState).append(" != ").append(NOT_MATCHED).append(") {\n           |  continue;\n           |}\n         ").toString())))).mkString();
        Seq<Tuple2<String, String>> x$6 = ctx.splitExpressionsWithCurrentInputs$default$3();
        String codes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)x$1, "caseWhen", x$6, "byte", (Function1<String, String>)x$4, (Function1<Seq<String>, String>)x$5);
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = ", ";\n         |do {\n         |  ", "\n         |} while (false);\n         |// TRUE if any condition is met and the result is null, or no any condition is met.\n         |final boolean ", " = (", " != ", ");\n       "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"byte", resultState, BoxesRunTime.boxToInteger((int)NOT_MATCHED), codes, ev.isNull(), resultState, BoxesRunTime.boxToInteger((int)HAS_NONNULL)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.branches().length() == 1 ? new If((Expression)((Tuple2)this.branches().apply(0))._1(), (Expression)((Tuple2)this.branches().apply(0))._2(), (Expression)this.elseValue().getOrElse((Function0 & Serializable)() -> Literal$.MODULE$.create(null, ((Expression)((Tuple2)this.branches().apply(0))._2()).dataType()))).doGenCode(ctx, ev) : this.multiBranchesCodegen(ctx, ev);
    }

    public CaseWhen copy(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        return new CaseWhen(branches, elseValue);
    }

    public Seq<Tuple2<Expression, Expression>> copy$default$1() {
        return this.branches();
    }

    public Option<Expression> copy$default$2() {
        return this.elseValue();
    }

    @Override
    public String productPrefix() {
        return "CaseWhen";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.branches();
                break;
            }
            case 1: {
                object = this.elseValue();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CaseWhen;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "branches";
                break;
            }
            case 1: {
                string = "elseValue";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CaseWhen)) return false;
        boolean bl = true;
        if (!bl) return false;
        CaseWhen caseWhen = (CaseWhen)x$1;
        Seq<Tuple2<Expression, Expression>> seq = this.branches();
        Seq<Tuple2<Expression, Expression>> seq2 = caseWhen.branches();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Option<Expression> option = this.elseValue();
        Option<Expression> option2 = caseWhen.elseValue();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!caseWhen.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$nullable$1(Tuple2 x$3) {
        return ((Expression)x$3._2()).nullable();
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$2(Tuple2 x$5) {
        DataType dataType = ((Expression)x$5._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return !(dataType != null ? !dataType.equals(booleanType$) : booleanType$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$3(Tuple2 x$6) {
        DataType dataType = ((Expression)x$6._1()).dataType();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return dataType == null ? booleanType$ != null : !dataType.equals(booleanType$);
    }

    public CaseWhen(Seq<Tuple2<Expression, Expression>> branches, Option<Expression> elseValue) {
        this.branches = branches;
        this.elseValue = elseValue;
        ComplexTypeMergingExpression.$init$(this);
        ConditionalExpression.$init$(this);
        this.nodePatterns = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{TreePattern$.MODULE$.CASE_WHEN()}));
    }
}

