/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayMax$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.EmptyBlock$;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.JavaCode$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(array) - Returns the maximum value in the array. NaN is greater than\n    any non-NaN elements for double/float type. NULL elements are skipped.", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 20, null, 3));\n       20\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001\u0002\u0010 \u00012B\u0001B\u0012\u0001\u0003\u0016\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005\u0011\")A\n\u0001C\u0001\u001b\")\u0001\u000b\u0001C!#\")Q\u000b\u0001C!#\")a\u000b\u0001C!/\"A\u0011\r\u0001EC\u0002\u0013%!\rC\u0003n\u0001\u0011\u0005c\u000eC\u0003v\u0001\u0011Ec\u000fC\u0004\u0002\n\u0001!\t&a\u0003\t\u0015\u0005E\u0001\u0001#b\u0001\n\u0003\n\u0019\u0002C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005E\u0002\u0001\"\u0015\u00024!I\u0011\u0011\b\u0001\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u007f\u0001\u0011\u0013!C\u0001\u0003\u0003B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\t\u0013\u0005%\u0004!!A\u0005\u0002\u0005-\u0004\"CA:\u0001\u0005\u0005I\u0011AA;\u0011%\tY\bAA\u0001\n\u0003\ni\bC\u0005\u0002\f\u0002\t\t\u0011\"\u0001\u0002\u000e\"I\u0011\u0011\u0013\u0001\u0002\u0002\u0013\u0005\u00131\u0013\u0005\n\u0003/\u0003\u0011\u0011!C!\u00033;\u0011\"!0 \u0003\u0003E\t!a0\u0007\u0011yy\u0012\u0011!E\u0001\u0003\u0003Da\u0001\u0014\r\u0005\u0002\u0005e\u0007\"CAn1\u0005\u0005IQIAo\u0011%\ty\u000eGA\u0001\n\u0003\u000b\t\u000fC\u0005\u0002fb\t\t\u0011\"!\u0002h\"I\u00111\u001f\r\u0002\u0002\u0013%\u0011Q\u001f\u0002\t\u0003J\u0014\u0018-_'bq*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001[E\"$\b\u0005\u0002/_5\tq$\u0003\u00021?\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t9\u0001K]8ek\u000e$\bCA\u001eD\u001d\ta\u0014I\u0004\u0002>\u00016\taH\u0003\u0002@W\u00051AH]8pizJ\u0011aN\u0005\u0003\u0005Z\nq\u0001]1dW\u0006<W-\u0003\u0002E\u000b\na1+\u001a:jC2L'0\u00192mK*\u0011!IN\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0011B\u0011a&S\u0005\u0003\u0015~\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"AT(\u0011\u00059\u0002\u0001\"\u0002$\u0004\u0001\u0004A\u0015A\u00048vY2Le\u000e^8mKJ\fg\u000e^\u000b\u0002%B\u0011QgU\u0005\u0003)Z\u0012qAQ8pY\u0016\fg.\u0001\u0005ok2d\u0017M\u00197f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u00021B\u00191(W.\n\u0005i+%aA*fcB\u0011AlX\u0007\u0002;*\u0011alI\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0011=\u0014H-\u001a:j]\u001e,\u0012a\u0019\t\u0004w\u00114\u0017BA3F\u0005!y%\u000fZ3sS:<\u0007CA\u001bh\u0013\tAgGA\u0002B]fD#a\u00026\u0011\u0005UZ\u0017B\u000177\u0005%!(/\u00198tS\u0016tG/A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001p!\t\u00018/D\u0001r\u0015\t\u0011\u0018%\u0001\u0005b]\u0006d\u0017p]5t\u0013\t!\u0018OA\bUsB,7\t[3dWJ+7/\u001e7u\u0003%!wnR3o\u0007>$W\r\u0006\u0003x{\u0006\u0015\u0001C\u0001=|\u001b\u0005I(B\u0001> \u0003\u001d\u0019w\u000eZ3hK:L!\u0001`=\u0003\u0011\u0015C\bO]\"pI\u0016DQA`\u0005A\u0002}\f1a\u0019;y!\rA\u0018\u0011A\u0005\u0004\u0003\u0007I(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u000fI\u0001\u0019A<\u0002\u0005\u00154\u0018\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGc\u00014\u0002\u000e!1\u0011q\u0002\u0006A\u0002\u0019\fQ!\u001b8qkR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003+\u00012\u0001XA\f\u0013\r\tI\"\u0018\u0002\t\t\u0006$\u0018\rV=qK\"\u00121B[\u0001\u000baJ,G\u000f^=OC6,WCAA\u0011!\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012q\u0005\t\u0003{YJ1!!\u000b7\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0006\u001c\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\rq\u0015Q\u0007\u0005\u0007\u0003oi\u0001\u0019\u0001%\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0019a*!\u0010\t\u000f\u0019s\u0001\u0013!a\u0001\u0011\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\"U\rA\u0015QI\u0016\u0003\u0003\u000f\u0002B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u000b\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002V\u0005-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005!A.\u00198h\u0015\t\t)'\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u0003?\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u001c\u0011\u0007U\ny'C\u0002\u0002rY\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2AZA<\u0011%\tIHEA\u0001\u0002\u0004\ti'A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0002R!!!\u0002\b\u001al!!a!\u000b\u0007\u0005\u0015e'\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0004\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\u0011\u0016q\u0012\u0005\t\u0003s\"\u0012\u0011!a\u0001M\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY&!&\t\u0013\u0005eT#!AA\u0002\u00055\u0014AB3rk\u0006d7\u000fF\u0002S\u00037C\u0001\"!\u001f\u0017\u0003\u0003\u0005\rA\u001a\u0015\u0014\u0001\u0005}\u0015QUAT\u0003W\u000bi+!-\u00024\u0006]\u0016\u0011\u0018\t\u0004]\u0005\u0005\u0016bAAR?\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAU\u0003\u0005]\"\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA5\f\u00070[7v[\u00022\u0018\r\\;fA%t\u0007\u0005\u001e5fA\u0005\u0014(/Y=/A9\u000bg\nI5tA\u001d\u0014X-\u0019;fe\u0002\"\b.\u00198\u000bA\u0001\u0002\u0003%\u00198zA9|g.\f(b\u001d\u0002*G.Z7f]R\u001c\bEZ8sA\u0011|WO\u00197f_\u0019dw.\u0019;!if\u0004XM\f\u0011O+2c\u0005%\u001a7f[\u0016tGo\u001d\u0011be\u0016\u00043o[5qa\u0016$g&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ty+A%\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)c1\u0002#\u0007\r\u0017!]VdG\u000e\f\u00114S%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u0019\u000bA\u0001\nQa\u001a:pkB\f#!!.\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003w\u000bQA\r\u00185]A\n\u0001\"\u0011:sCfl\u0015\r\u001f\t\u0003]a\u0019R\u0001GAb\u0003\u001f\u0004b!!2\u0002L\"sUBAAd\u0015\r\tIMN\u0001\beVtG/[7f\u0013\u0011\ti-a2\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002R\u0006]WBAAj\u0015\u0011\t).a\u0019\u0002\u0005%|\u0017b\u0001#\u0002TR\u0011\u0011qX\u0001\ti>\u001cFO]5oOR\u0011\u00111L\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001d\u0006\r\b\"\u0002$\u001c\u0001\u0004A\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003S\fy\u000f\u0005\u00036\u0003WD\u0015bAAwm\t1q\n\u001d;j_:D\u0001\"!=\u001d\u0003\u0003\u0005\rAT\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAA|!\u0011\ti&!?\n\t\u0005m\u0018q\f\u0002\u0007\u001f\nTWm\u0019;")
public class ArrayMax
extends UnaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private final Expression child;
    private volatile transient byte bitmap$trans$0;

    public static Option<Expression> unapply(ArrayMax x$0) {
        return ArrayMax$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<ArrayMax, A> g) {
        return ArrayMax$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, ArrayMax> compose(Function1<A$, Expression> g) {
        return ArrayMax$.MODULE$.compose(g);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)ArrayType$.MODULE$, (List)Nil$.MODULE$);
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayMax arrayMax = this;
        synchronized (arrayMax) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.ordering$lzycompute();
        }
        return this.ordering;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult = ExpectsInputTypes.checkInputDataTypes$(this);
        if (typeCheckResult.isSuccess()) {
            return TypeUtils$.MODULE$.checkForOrderingExpr(this.dataType(), this.prettyName());
        }
        return typeCheckResult;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode childGen = this.child().genCode(ctx);
        String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String i = ctx.freshName("i");
        ExprCode item = new ExprCode(EmptyBlock$.MODULE$, JavaCode$.MODULE$.isNullExpression(childGen.value() + ".isNullAt(" + i + ")"), JavaCode$.MODULE$.expression(CodeGenerator$.MODULE$.getValue(ExprValue$.MODULE$.exprValueToString(childGen.value()), this.dataType(), i), this.dataType()));
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |boolean ", " = true;\n         |", " ", " = ", ";\n         |if (!", ") {\n         |  for (int ", " = 0; ", " < ", ".numElements(); ", " ++) {\n         |    ", "\n         |  }\n         |}\n      "}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{childGen.code(), ev.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), childGen.isNull(), i, i, childGen.value(), i, ctx.reassignIfGreater(this.dataType(), ev, item)})).stripMargin(), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public Object nullSafeEval(Object input) {
        ObjectRef max = ObjectRef.create(null);
        ((ArrayData)input).foreach(this.dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable)(x$40, item) -> {
            ArrayMax.$anonfun$nullSafeEval$7(this, max, BoxesRunTime.unboxToInt((Object)x$40), item);
            return BoxedUnit.UNIT;
        });
        return max.elem;
    }

    private DataType dataType$lzycompute() {
        ArrayMax arrayMax = this;
        synchronized (arrayMax) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                DataType dataType = this.child().dataType();
                if (!(dataType instanceof ArrayType)) {
                    throw SparkException$.MODULE$.internalError(this.prettyName() + " accepts only arrays.");
                }
                ArrayType arrayType = (ArrayType)dataType;
                DataType dt = arrayType.elementType();
                this.dataType = dt;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    @Override
    public String prettyName() {
        return "array_max";
    }

    @Override
    public ArrayMax withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public ArrayMax copy(Expression child) {
        return new ArrayMax(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "ArrayMax";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayMax;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayMax)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayMax arrayMax = (ArrayMax)x$1;
        Expression expression = this.child();
        Expression expression2 = arrayMax.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!arrayMax.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$7(ArrayMax $this, ObjectRef max$1, int x$40, Object item) {
        if (item != null && (max$1.elem == null || $this.ordering().gt(item, max$1.elem))) {
            max$1.elem = item;
            return;
        }
    }

    public ArrayMax(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

