/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ExecuteGrpcResponseSender;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.ExecuteKey$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh!\u0002\u000f\u001e\u0001}I\u0003\"\u0002\u001c\u0001\t\u0003A\u0004bB\u001e\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u001b\u0002\u0001\u000b\u0011B\u001f\t\u000f9\u0003!\u0019!C\u0005\u001f\"1q\f\u0001Q\u0001\nACq\u0001\u0019\u0001C\u0002\u0013%\u0011\r\u0003\u0004i\u0001\u0001\u0006IA\u0019\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\t\b\u0001)A\u0005W\"1!\u000f\u0001C\u0001?MDqA\u001d\u0001\u0005\u0002}\tI\u0001\u0003\u0005\u0002\u0010\u0001!\taHA\t\u0011)\t9\u0003AI\u0001\n\u0003y\u0012\u0011\u0006\u0005\t\u0003\u007f\u0001A\u0011A\u0010\u0002B!A\u00111\n\u0001\u0005\u0002}\ti\u0005\u0003\u0005\u0002t\u0001!\taHA;\u0011!\tI\n\u0001C\u0001?\u0005m\u0005\u0002CAS\u0001\u0011\u0005q$a*\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007\u0002CAj\u0001\u0011\u0005q$!6\t\u000f\u0005]\u0007\u0001\"\u0003\u0002V\"9\u0011\u0011\u001c\u0001\u0005\n\u0005U\u0007\u0002CAn\u0001\u0011\u0005q$!8\t\u0011\u0005\r\b\u0001\"\u0001 \u0003KD\u0001\"a;\u0001\t\u0003y\u0012Q\u001b\u0005\t\u0003[\u0004A\u0011A\u0010\u0002p\na2\u000b]1sW\u000e{gN\\3di\u0016CXmY;uS>tW*\u00198bO\u0016\u0014(B\u0001\u0010 \u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001I\u0011\u0002\u000f\r|gN\\3di*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cQj\u0011A\r\u0006\u0003g\r\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGOP\u0002\u0001)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005i\u0012AC3yK\u000e,H/[8ogV\tQ\b\u0005\u0003?\u000b\u001eSU\"A \u000b\u0005\u0001\u000b\u0015AC2p]\u000e,(O]3oi*\u0011!iQ\u0001\u0005kRLGNC\u0001E\u0003\u0011Q\u0017M^1\n\u0005\u0019{$!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002;\u0011&\u0011\u0011*\b\u0002\u000b\u000bb,7-\u001e;f\u0017\u0016L\bC\u0001\u001eL\u0013\taUDA\u0007Fq\u0016\u001cW\u000f^3I_2$WM]\u0001\fKb,7-\u001e;j_:\u001c\b%A\nbE\u0006tGm\u001c8fIR{WNY:u_:,7/F\u0001Q!\u0011\t&l\u0012/\u000e\u0003IS!a\u0015+\u0002\u000b\r\f7\r[3\u000b\u0005U3\u0016AB2p[6|gN\u0003\u0002X1\u00061qm\\8hY\u0016T\u0011!W\u0001\u0004G>l\u0017BA.S\u0005\u0015\u0019\u0015m\u00195f!\tQT,\u0003\u0002_;\tYQ\t_3dkR,\u0017J\u001c4p\u0003Q\t'-\u00198e_:,G\rV8nEN$xN\\3tA\u0005\u0019B.Y:u\u000bb,7-\u001e;j_:$\u0016.\\3OgV\t!\r\u0005\u0002dM6\tAM\u0003\u0002f\u007f\u00051\u0011\r^8nS\u000eL!a\u001a3\u0003\u0015\u0005#x.\\5d\u0019>tw-\u0001\u000bmCN$X\t_3dkRLwN\u001c+j[\u0016t5\u000fI\u0001\u0012g\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u0014X#A6\u0011\u0007\rdg.\u0003\u0002nI\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002?_&\u0011\u0001o\u0010\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AE:dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;pe\u0002\n1c\u0019:fCR,W\t_3dkR,\u0007j\u001c7eKJ$BA\u0013;w\u007f\")QO\u0003a\u0001\u000f\u0006QQ\r_3dkR,7*Z=\t\u000b]T\u0001\u0019\u0001=\u0002\u000fI,\u0017/^3tiB\u0011\u00110`\u0007\u0002u*\u00111\u0010`\u0001\u0006aJ|Go\u001c\u0006\u0003A\rJ!A >\u0003%\u0015CXmY;uKBc\u0017M\u001c*fcV,7\u000f\u001e\u0005\b\u0003\u0003Q\u0001\u0019AA\u0002\u00035\u0019Xm]:j_:Du\u000e\u001c3feB\u0019!(!\u0002\n\u0007\u0005\u001dQDA\u0007TKN\u001c\u0018n\u001c8I_2$WM\u001d\u000b\u0004\u0015\u0006-\u0001BBA\u0007\u0017\u0001\u0007\u00010A\u0001w\u0003M\u0011X-\\8wK\u0016CXmY;uK\"{G\u000eZ3s)\u0019\t\u0019\"!\u0007\u0002\u001eA\u00191&!\u0006\n\u0007\u0005]AF\u0001\u0003V]&$\bBBA\u000e\u0019\u0001\u0007q)A\u0002lKfD\u0011\"a\b\r!\u0003\u0005\r!!\t\u0002\u0013\u0005\u0014\u0017M\u001c3p]\u0016$\u0007cA\u0016\u0002$%\u0019\u0011Q\u0005\u0017\u0003\u000f\t{w\u000e\\3b]\u0006i\"/Z7pm\u0016,\u00050Z2vi\u0016Du\u000e\u001c3fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002,)\"\u0011\u0011EA\u0017W\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001dY\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00121\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E4fi\u0016CXmY;uK\"{G\u000eZ3s)\u0011\t\u0019%!\u0013\u0011\t-\n)ES\u0005\u0004\u0003\u000fb#AB(qi&|g\u000e\u0003\u0004\u0002\u001c9\u0001\raR\u0001\u001dGJ,\u0017\r^3Fq\u0016\u001cW\u000f^3I_2$WM]!oI\u0006#H/Y2i)%Q\u0015qJA)\u0003'\n)\u0006C\u0003v\u001f\u0001\u0007q\tC\u0003x\u001f\u0001\u0007\u0001\u0010C\u0004\u0002\u0002=\u0001\r!a\u0001\t\u000f\u0005]s\u00021\u0001\u0002Z\u0005\u0001\"/Z:q_:\u001cXm\u00142tKJ4XM\u001d\t\u0007\u00037\nI'!\u001c\u000e\u0005\u0005u#\u0002BA0\u0003C\nAa\u001d;vE*!\u00111MA3\u0003\u00119'\u000f]2\u000b\u0005\u0005\u001d\u0014AA5p\u0013\u0011\tY'!\u0018\u0003\u001dM#(/Z1n\u001f\n\u001cXM\u001d<feB\u0019\u00110a\u001c\n\u0007\u0005E$PA\nFq\u0016\u001cW\u000f^3QY\u0006t'+Z:q_:\u001cX-A\u000bsK\u0006$H/Y2i\u000bb,7-\u001e;f\u0011>dG-\u001a:\u0015\u0011\u0005M\u0011qOA>\u0003{Ba!!\u001f\u0011\u0001\u0004Q\u0015!D3yK\u000e,H/\u001a%pY\u0012,'\u000fC\u0004\u0002XA\u0001\r!!\u0017\t\u000f\u0005}\u0004\u00031\u0001\u0002\u0002\u00061B.Y:u\u0007>t7/^7fIJ+7\u000f]8og\u0016LE\rE\u0003,\u0003\u000b\n\u0019\t\u0005\u0003\u0002\u0006\u0006Me\u0002BAD\u0003\u001f\u00032!!#-\u001b\t\tYIC\u0002\u0002\u000e^\na\u0001\u0010:p_Rt\u0014bAAIY\u00051\u0001K]3eK\u001aLA!!&\u0002\u0018\n11\u000b\u001e:j]\u001eT1!!%-\u0003u\u0011X-\\8wK\u0006cG.\u0012=fGV$\u0018n\u001c8t\r>\u00148+Z:tS>tG\u0003BA\n\u0003;Cq!a\u0007\u0012\u0001\u0004\ty\nE\u0002;\u0003CK1!a)\u001e\u0005)\u0019Vm]:j_:\\U-_\u0001\u0016O\u0016$\u0018IY1oI>tW\r\u001a+p[\n\u001cHo\u001c8f)\u0011\tI+a+\u0011\t-\n)\u0005\u0018\u0005\u0007\u00037\u0011\u0002\u0019A$\u0002)1L7\u000f^!di&4X-\u0012=fGV$\u0018n\u001c8t+\t\t\t\f\u0005\u0005\u00024\u0006u\u00161YAe\u001d\u0011\t),!/\u000f\t\u0005%\u0015qW\u0005\u0002[%\u0019\u00111\u0018\u0017\u0002\u000fA\f7m[1hK&!\u0011qXAa\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u00111\u0018\u0017\u0011\u0007-\n)-C\u0002\u0002H2\u0012A\u0001T8oOB)\u00111WAf9&!\u0011QZAa\u0005\r\u0019V-]\u0001\u0018Y&\u001cH/\u00112b]\u0012|g.\u001a3Fq\u0016\u001cW\u000f^5p]N,\"!!3\u0002\u0011MDW\u000f\u001e3po:$\"!a\u0005\u0002/U\u0004H-\u0019;f\u0019\u0006\u001cH/\u0012=fGV$\u0018n\u001c8US6,\u0017AF:dQ\u0016$W\u000f\\3QKJLw\u000eZ5d\u0007\",7m[:\u0002'A,'/[8eS\u000el\u0015-\u001b8uK:\fgnY3\u0015\t\u0005M\u0011q\u001c\u0005\b\u0003CD\u0002\u0019AAb\u0003%!\u0018.\\3pkRt5/\u0001\ntKR\fE\u000e\u001c*Q\u0007N$U-\u00193mS:,G\u0003BA\n\u0003ODq!!;\u001a\u0001\u0004\t\u0019-\u0001\u0006eK\u0006$G.\u001b8f\u001dN\f\u0001#\u001b8uKJ\u0014X\u000f\u001d;BY2\u0014\u0006kQ:\u0002%1L7\u000f^#yK\u000e,H/\u001a%pY\u0012,'o]\u000b\u0003\u0003c\u0004R!a-\u0002L*\u0003")
public class SparkConnectExecutionManager
implements Logging {
    private final ConcurrentMap<ExecuteKey, ExecuteHolder> executions;
    private final Cache<ExecuteKey, ExecuteInfo> abandonedTombstones;
    private final AtomicLong lastExecutionTimeNs;
    private final AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<ExecuteKey, ExecuteHolder> executions() {
        return this.executions;
    }

    private Cache<ExecuteKey, ExecuteInfo> abandonedTombstones() {
        return this.abandonedTombstones;
    }

    private AtomicLong lastExecutionTimeNs() {
        return this.lastExecutionTimeNs;
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    public ExecuteHolder createExecuteHolder(ExecuteKey executeKey2, ExecutePlanRequest request, SessionHolder sessionHolder) {
        ExecuteHolder executeHolder = this.executions().compute(executeKey2, (executeKey, oldExecuteHolder) -> {
            if (oldExecuteHolder != null) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            if (this.getAbandonedTombstone((ExecuteKey)executeKey).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ABANDONED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            return new ExecuteHolder((ExecuteKey)executeKey, request, sessionHolder);
        });
        sessionHolder.addOperationId(executeHolder.operationId());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is created."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)executeHolder.key())}))));
        this.schedulePeriodicChecks();
        return executeHolder;
    }

    public ExecuteHolder createExecuteHolder(ExecutePlanRequest v) {
        Some some;
        boolean bl = v.hasClientObservedServerSideSessionId();
        if (bl) {
            some = new Some((Object)v.getClientObservedServerSideSessionId());
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Some previousSessionId = some;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(v.getUserContext().getUserId(), v.getSessionId(), (Option<String>)previousSessionId);
        ExecuteKey executeKey = ExecuteKey$.MODULE$.apply(v, sessionHolder);
        return this.createExecuteHolder(executeKey, v, sessionHolder);
    }

    public void removeExecuteHolder(ExecuteKey key, boolean abandoned) {
        ExecuteHolder executeHolder = (ExecuteHolder)this.executions().get(key);
        if (executeHolder == null) {
            return;
        }
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
        }
        this.executions().remove(key);
        executeHolder.sessionHolder().removeOperationId(executeHolder.operationId());
        this.updateLastExecutionTime();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is removed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)key)}))));
        executeHolder.close();
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
            return;
        }
    }

    public boolean removeExecuteHolder$default$2() {
        return false;
    }

    public Option<ExecuteHolder> getExecuteHolder(ExecuteKey key) {
        return Option$.MODULE$.apply(this.executions().get(key));
    }

    public ExecuteHolder createExecuteHolderAndAttach(ExecuteKey executeKey, ExecutePlanRequest request, SessionHolder sessionHolder, StreamObserver<ExecutePlanResponse> responseObserver) {
        ExecuteHolder executeHolder = this.createExecuteHolder(executeKey, request, sessionHolder);
        try {
            executeHolder.eventsManager().postStarted();
            executeHolder.start();
        }
        catch (Throwable t2) {
            this.removeExecuteHolder(executeHolder.key(), this.removeExecuteHolder$default$2());
            throw t2;
        }
        try {
            ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender = new ExecuteGrpcResponseSender<ExecutePlanResponse>(executeHolder, responseObserver);
            executeHolder.runGrpcResponseSender(responseSender);
        }
        finally {
            executeHolder.afterInitialRPC();
        }
        return executeHolder;
    }

    public void reattachExecuteHolder(ExecuteHolder executeHolder, StreamObserver<ExecutePlanResponse> responseObserver, Option<String> lastConsumedResponseId) {
        if (!executeHolder.reattachable()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reattach to not reattachable operation."}))).log((Seq)Nil$.MODULE$)));
            throw new SparkSQLException("INVALID_CURSOR.NOT_REATTACHABLE", Predef$.MODULE$.Map().empty());
        }
        if (executeHolder.isOrphan()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reattach to an orphan operation."}))).log((Seq)Nil$.MODULE$)));
            this.removeExecuteHolder(executeHolder.key(), this.removeExecuteHolder$default$2());
            throw new IllegalStateException("Operation was orphaned because of an internal error.");
        }
        ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender = new ExecuteGrpcResponseSender<ExecutePlanResponse>(executeHolder, responseObserver);
        Option<String> option = lastConsumedResponseId;
        if (option instanceof Some) {
            Some some = (Some)option;
            String lastResponseId = (String)some.value();
            executeHolder.runGrpcResponseSender(responseSender, lastResponseId);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            executeHolder.runGrpcResponseSender(responseSender);
            return;
        }
        throw new MatchError(option);
    }

    public void removeAllExecutionsForSession(SessionKey key) {
        this.executions().forEach((x$1, executeHolder) -> {
            SessionKey sessionKey = executeHolder.sessionHolder().key();
            SessionKey sessionKey2 = key;
            if (!(sessionKey != null ? !((Object)sessionKey).equals(sessionKey2) : sessionKey2 != null)) {
                ExecuteInfo info = executeHolder.getExecuteInfo();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Execution ", " removed in removeSessionExecutions."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)}))));
                this.removeExecuteHolder(executeHolder.key(), true);
                return;
            }
        });
    }

    public Option<ExecuteInfo> getAbandonedTombstone(ExecuteKey key) {
        return Option$.MODULE$.apply((Object)this.abandonedTombstones().getIfPresent(key));
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        if (this.executions().isEmpty()) {
            return new Left((Object)BoxesRunTime.boxToLong((long)this.lastExecutionTimeNs().getAcquire()));
        }
        return new Right((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().map((Function1 & Serializable)x$2 -> x$2.getExecuteInfo())).toBuffer().toSeq());
    }

    public Seq<ExecuteInfo> listAbandonedExecutions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.abandonedTombstones().asMap()).asScala().values().toSeq();
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.executions().clear();
        this.abandonedTombstones().invalidateAll();
        this.updateLastExecutionTime();
    }

    private void updateLastExecutionTime() {
        this.lastExecutionTimeNs().getAndUpdate(prev -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(prev), System.nanoTime()));
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of abandoned executions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long timeoutNs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT())) * 1000000L;
                        this.periodicMaintenance(timeoutNs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long timeoutNs) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectExecutionManager maintenance.");
        long nowNs = System.nanoTime();
        this.executions().forEach((x$3, executeHolder) -> {
            Option<Object> option = executeHolder.lastAttachedRpcTimeNs();
            if (option instanceof Some) {
                Some some = (Some)option;
                long detachedNs = BoxesRunTime.unboxToLong((Object)some.value());
                if (detachedNs + timeoutNs <= nowNs) {
                    ExecuteInfo info = executeHolder.getExecuteInfo();
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found execution ", " that was abandoned "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and expired and will be removed."}))).log((Seq)Nil$.MODULE$))));
                    this.removeExecuteHolder(executeHolder.key(), true);
                    return;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectExecutionManager maintenance.");
    }

    public void setAllRPCsDeadline(long deadlineNs) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$4 -> {
            x$4.setGrpcResponseSendersDeadline(deadlineNs);
            return BoxedUnit.UNIT;
        });
    }

    public void interruptAllRPCs() {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$5 -> {
            x$5.interruptGrpcResponseSenders();
            return BoxedUnit.UNIT;
        });
    }

    public Seq<ExecuteHolder> listExecuteHolders() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().toSeq();
    }

    public SparkConnectExecutionManager() {
        Logging.$init$((Logging)this);
        this.executions = new ConcurrentHashMap<ExecuteKey, ExecuteHolder>();
        this.abandonedTombstones = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE()))).build();
        this.lastExecutionTimeNs = new AtomicLong(System.nanoTime());
        this.scheduledExecutor = new AtomicReference();
    }
}

