/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.util;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Edge$mcD$sp;
import org.apache.spark.graphx.Edge$mcI$sp;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2;
import scala.util.Random;

public final class GraphGenerators$
implements Logging {
    public static final GraphGenerators$ MODULE$ = new GraphGenerators$();
    private static final double RMATa;
    private static final double RMATb;
    private static final double RMATd;
    private static final double RMATc;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        RMATa = 0.45;
        RMATb = 0.15;
        RMATd = 0.25;
        RMATc = 0.15;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double RMATa() {
        return RMATa;
    }

    public double RMATb() {
        return RMATb;
    }

    public double RMATd() {
        return RMATd;
    }

    public Graph<Object, Object> logNormalGraph(SparkContext sc, int numVertices, int numEParts, double mu, double sigma, long seed) {
        int evalNumEParts = numEParts == 0 ? sc.defaultParallelism() : numEParts;
        Random seedRand = seed == -1L ? new Random() : new Random(seed);
        int seed1 = seedRand.nextInt();
        int seed2 = seedRand.nextInt();
        RDD vertices = sc.parallelize((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numVertices), evalNumEParts, (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)src -> GraphGenerators$.$anonfun$logNormalGraph$1(mu, sigma, numVertices, seed1, BoxesRunTime.unboxToInt((Object)src)), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = vertices.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long src = tuple2._1$mcJ$sp();
                long degree = tuple2._2$mcJ$sp();
                return Predef$.MODULE$.wrapRefArray((Object[])MODULE$.generateRandomEdges((int)src, (int)degree, numVertices, (long)seed2 ^ src));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, BoxesRunTime.boxToLong((long)0L), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int());
    }

    public int logNormalGraph$default$3() {
        return 0;
    }

    public double logNormalGraph$default$4() {
        return 4.0;
    }

    public double logNormalGraph$default$5() {
        return 1.3;
    }

    public long logNormalGraph$default$6() {
        return -1L;
    }

    public double RMATc() {
        return RMATc;
    }

    public Edge<Object>[] generateRandomEdges(int src, int numEdges, int maxVertexId, long seed) {
        Random rand = seed == -1L ? new Random() : new Random(seed);
        return (Edge[])Array$.MODULE$.fill(numEdges, (Function0 & Serializable)() -> new Edge$mcI$sp((long)src, (long)rand.nextInt(maxVertexId), 1), ClassTag$.MODULE$.apply(Edge.class));
    }

    public long generateRandomEdges$default$4() {
        return -1L;
    }

    public int sampleLogNormal(double mu, double sigma, int maxVal, long seed) {
        Random rand = seed == -1L ? new Random() : new Random(seed);
        double X = maxVal;
        while (X >= (double)maxVal) {
            double Z = rand.nextGaussian();
            X = scala.math.package$.MODULE$.exp(mu + sigma * Z);
        }
        return (int)scala.math.package$.MODULE$.floor(X);
    }

    public long sampleLogNormal$default$4() {
        return -1L;
    }

    public Graph<Object, Object> rmatGraph(SparkContext sc, int requestedNumVertices, int numEdges) {
        int numVertices = (int)scala.math.package$.MODULE$.round(scala.math.package$.MODULE$.pow(2.0, scala.math.package$.MODULE$.ceil(scala.math.package$.MODULE$.log((double)requestedNumVertices) / scala.math.package$.MODULE$.log(2.0))));
        int numEdgesUpperBound = (int)scala.math.package$.MODULE$.pow(2.0, (double)2 * (scala.math.package$.MODULE$.log((double)numVertices) / scala.math.package$.MODULE$.log(2.0) - 1.0));
        if (numEdgesUpperBound < numEdges) {
            throw new IllegalArgumentException("numEdges must be <= " + numEdgesUpperBound + " but was " + numEdges);
        }
        Set edges = (Set)Set$.MODULE$.empty();
        while (edges.size() < numEdges) {
            if (edges.size() % 100 == 0) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> edges.size() + " edges");
            }
            edges.$plus$eq(this.addEdge(numVertices));
        }
        return this.outDegreeFromEdges((RDD)sc.parallelize((Seq)edges.toList(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), (ClassTag)ClassTag$.MODULE$.Int());
    }

    private <ED> Graph<Object, ED> outDegreeFromEdges(RDD<Edge<ED>> edges, ClassTag<ED> evidence$1) {
        RDD vertices = RDD$.MODULE$.rddToPairRDDFunctions(edges.flatMap((Function1 & Serializable)edge -> new .colon.colon((Object)new Tuple2.mcJI.sp(edge.srcId(), 1), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Long.TYPE), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.Long$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable)(x$1, x$2) -> x$1 + x$2).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long vid = tuple2._1$mcJ$sp();
                int degree = tuple2._2$mcI$sp();
                return new Tuple2.mcJI.sp(vid, degree);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return Graph$.MODULE$.apply(vertices, edges, BoxesRunTime.boxToInteger((int)0), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Int(), evidence$1);
    }

    private Edge<Object> addEdge(int numVertices) {
        int v = (int)scala.math.package$.MODULE$.round((double)numVertices / 2.0);
        Tuple2<Object, Object> tuple2 = this.chooseCell(v, v, v);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int src = tuple2._1$mcI$sp();
        int dst = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(src, dst);
        int src2 = sp2._1$mcI$sp();
        int dst2 = sp2._2$mcI$sp();
        return new Edge$mcI$sp((long)src2, (long)dst2, 1);
    }

    private Tuple2<Object, Object> chooseCell(int x, int y, int t) {
        int n;
        block6: while (true) {
            if (t <= 1) {
                return new Tuple2.mcII.sp(x, y);
            }
            int newT = (int)scala.math.package$.MODULE$.round((double)t / 2.0);
            n = this.pickQuadrant(this.RMATa(), this.RMATb(), this.RMATc(), this.RMATd());
            switch (n) {
                case 0: {
                    t = newT;
                    continue block6;
                }
                case 1: {
                    t = newT;
                    x += newT;
                    continue block6;
                }
                case 2: {
                    t = newT;
                    y += newT;
                    continue block6;
                }
                case 3: {
                    t = newT;
                    y += newT;
                    x += newT;
                    continue block6;
                }
            }
            break;
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private int pickQuadrant(double a, double b, double c, double d) {
        if (a + b + c + d != 1.0) {
            throw new IllegalArgumentException("R-MAT probability parameters sum to " + (a + b + c + d) + ", should sum to 1.0");
        }
        Random rand = new Random();
        double result = rand.nextDouble();
        double d2 = result;
        if (d2 < a) {
            return 0;
        }
        if (d2 >= a && d2 < a + b) {
            return 1;
        }
        if (d2 >= a + b && d2 < a + b + c) {
            return 2;
        }
        return 3;
    }

    public Graph<Tuple2<Object, Object>, Object> gridGraph(SparkContext sc, int rows, int cols) {
        RDD vertices = sc.parallelize((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rows), sc.parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).flatMap((Function1 & Serializable)r -> GraphGenerators$.$anonfun$gridGraph$1(cols, BoxesRunTime.unboxToInt((Object)r)), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = vertices.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                int r = tuple2._1$mcI$sp();
                int c = tuple2._2$mcI$sp();
                return (Seq)(r + 1 < rows ? new .colon.colon((Object)new Tuple2.mcJJ.sp(GraphGenerators$.sub2ind$1(r, c, cols), GraphGenerators$.sub2ind$1(r + 1, c, cols)), (List)Nil$.MODULE$) : package$.MODULE$.Seq().empty()).$plus$plus((IterableOnce)(c + 1 < cols ? new .colon.colon((Object)new Tuple2.mcJJ.sp(GraphGenerators$.sub2ind$1(r, c, cols), GraphGenerators$.sub2ind$1(r, c + 1, cols)), (List)Nil$.MODULE$) : package$.MODULE$.Seq().empty()));
            }
            throw new MatchError((Object)tuple22);
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                long src = tuple2._1$mcJ$sp();
                long dst = tuple2._2$mcJ$sp();
                return new Edge$mcD$sp(src, dst, 1.0);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double());
    }

    public Graph<Object, Object> starGraph(SparkContext sc, int nverts) {
        RDD edges = sc.parallelize((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), nverts), sc.parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)vid -> GraphGenerators$.$anonfun$starGraph$1(BoxesRunTime.unboxToInt((Object)vid)), ClassTag$.MODULE$.apply(Tuple2.class));
        return Graph$.MODULE$.fromEdgeTuples((RDD<Tuple2<Object, Object>>)edges, BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
    }

    public static final /* synthetic */ Tuple2 $anonfun$logNormalGraph$1(double mu$1, double sigma$1, int numVertices$1, int seed1$1, int src) {
        return new Tuple2.mcJJ.sp((long)src, (long)MODULE$.sampleLogNormal(mu$1, sigma$1, numVertices$1, seed1$1 ^ src));
    }

    private static final long sub2ind$1(int r, int c, int cols$1) {
        return r * cols$1 + c;
    }

    public static final /* synthetic */ Tuple2 $anonfun$gridGraph$2(int r$1, int cols$1, int c) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)GraphGenerators$.sub2ind$1(r$1, c, cols$1)), (Object)new Tuple2.mcII.sp(r$1, c));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$gridGraph$1(int cols$1, int r) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), cols$1).map((Function1 & Serializable)c -> GraphGenerators$.$anonfun$gridGraph$2(r, cols$1, BoxesRunTime.unboxToInt((Object)c)));
    }

    public static final /* synthetic */ Tuple2 $anonfun$starGraph$1(int vid) {
        return new Tuple2.mcJJ.sp((long)vid, 0L);
    }

    private GraphGenerators$() {
    }
}

