/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.zip.Checksum;
import javax.annotation.Nullable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TooLargePageException;
import org.apache.spark.serializer.DummySerializerInstance;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.checksum.ShuffleChecksumSupport;
import org.apache.spark.shuffle.sort.ShuffleInMemorySorter;
import org.apache.spark.shuffle.sort.SpillInfo;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.DiskBlockObjectWriter;
import org.apache.spark.storage.FileSegment;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UnsafeAlignedOffset;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.Utils;
import org.sparkproject.guava.annotations.VisibleForTesting;
import scala.Tuple2;

final class ShuffleExternalSorter
extends MemoryConsumer
implements ShuffleChecksumSupport {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(ShuffleExternalSorter.class);
    @VisibleForTesting
    static final int DISK_WRITE_BUFFER_SIZE = 0x100000;
    private final int numPartitions;
    private final TaskMemoryManager taskMemoryManager;
    private final BlockManager blockManager;
    private final TaskContext taskContext;
    private final ShuffleWriteMetricsReporter writeMetrics;
    private final int numElementsForSpillThreshold;
    private final long recordsSizeForSpillThreshold;
    private final int fileBufferSizeBytes;
    private final int diskWriteBufferSize;
    private final LinkedList<MemoryBlock> allocatedPages = new LinkedList();
    private final LinkedList<SpillInfo> spills = new LinkedList();
    private long peakMemoryUsedBytes;
    @Nullable
    private ShuffleInMemorySorter inMemSorter;
    @Nullable
    private MemoryBlock currentPage = null;
    private long pageCursor = -1L;
    private long inMemRecordsSize = 0L;
    private final Checksum[] partitionChecksums;

    ShuffleExternalSorter(TaskMemoryManager memoryManager, BlockManager blockManager, TaskContext taskContext, int initialSize, int numPartitions, SparkConf conf, ShuffleWriteMetricsReporter writeMetrics) throws SparkException {
        super(memoryManager, (int)Math.min(0x8000000L, memoryManager.pageSizeBytes()), memoryManager.getTungstenMemoryMode());
        this.taskMemoryManager = memoryManager;
        this.blockManager = blockManager;
        this.taskContext = taskContext;
        this.numPartitions = numPartitions;
        this.fileBufferSizeBytes = (int)((Long)conf.get(package$.MODULE$.SHUFFLE_FILE_BUFFER_SIZE())).longValue() * 1024;
        this.numElementsForSpillThreshold = (Integer)conf.get(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD());
        this.recordsSizeForSpillThreshold = (Long)conf.get(package$.MODULE$.SHUFFLE_SPILL_MAX_SIZE_FORCE_SPILL_THRESHOLD());
        this.writeMetrics = writeMetrics;
        this.inMemSorter = new ShuffleInMemorySorter(this, initialSize, (Boolean)conf.get(package$.MODULE$.SHUFFLE_SORT_USE_RADIXSORT()));
        this.peakMemoryUsedBytes = this.getMemoryUsage();
        this.diskWriteBufferSize = (int)((Long)conf.get(package$.MODULE$.SHUFFLE_DISK_WRITE_BUFFER_SIZE())).longValue();
        this.partitionChecksums = this.createPartitionChecksums(numPartitions, conf);
    }

    public long[] getChecksums() {
        return this.getChecksumValues(this.partitionChecksums);
    }

    private void writeSortedFile(boolean isFinalFile) {
        FileSegment committedSegment;
        ShuffleInMemorySorter.ShuffleSorterIterator sortedRecords;
        if (!isFinalFile) {
            logger.info("Task {} on Thread {} spilling sort data of {} to disk ({} {} so far)", new MDC[]{MDC.of((LogKey)LogKeys.TASK_ATTEMPT_ID$.MODULE$, (Object)this.taskContext.taskAttemptId()), MDC.of((LogKey)LogKeys.THREAD_ID$.MODULE$, (Object)Thread.currentThread().getId()), MDC.of((LogKey)LogKeys.MEMORY_SIZE$.MODULE$, (Object)Utils.bytesToString(this.getMemoryUsage())), MDC.of((LogKey)LogKeys.NUM_SPILLS$.MODULE$, (Object)this.spills.size()), MDC.of((LogKey)LogKeys.SPILL_TIMES$.MODULE$, (Object)(this.spills.size() != 1 ? "times" : "time"))});
        }
        if (!(sortedRecords = this.inMemSorter.getSortedIterator()).hasNext()) {
            return;
        }
        ShuffleWriteMetricsReporter writeMetricsToUse = isFinalFile ? this.writeMetrics : new ShuffleWriteMetrics();
        byte[] writeBuffer = new byte[this.diskWriteBufferSize];
        Tuple2<TempShuffleBlockId, File> spilledFileInfo = this.blockManager.diskBlockManager().createTempShuffleBlock();
        File file = (File)spilledFileInfo._2();
        TempShuffleBlockId blockId = (TempShuffleBlockId)spilledFileInfo._1();
        SpillInfo spillInfo = new SpillInfo(this.numPartitions, file, blockId);
        DummySerializerInstance ser = DummySerializerInstance.INSTANCE;
        int currentPartition = -1;
        try (DiskBlockObjectWriter writer = this.blockManager.getDiskWriter(blockId, file, ser, this.fileBufferSizeBytes, writeMetricsToUse);){
            int uaoSize = UnsafeAlignedOffset.getUaoSize();
            while (sortedRecords.hasNext()) {
                int toTransfer;
                sortedRecords.loadNext();
                int partition = sortedRecords.packedRecordPointer.getPartitionId();
                assert (partition >= currentPartition);
                if (partition != currentPartition) {
                    if (currentPartition != -1) {
                        FileSegment fileSegment = writer.commitAndGet();
                        spillInfo.partitionLengths[currentPartition] = fileSegment.length();
                    }
                    currentPartition = partition;
                    if (this.partitionChecksums.length > 0) {
                        writer.setChecksum(this.partitionChecksums[currentPartition]);
                    }
                }
                long recordPointer = sortedRecords.packedRecordPointer.getRecordPointer();
                Object recordPage = this.taskMemoryManager.getPage(recordPointer);
                long recordOffsetInPage = this.taskMemoryManager.getOffsetInPage(recordPointer);
                long recordReadPosition = recordOffsetInPage + (long)uaoSize;
                for (int dataRemaining = UnsafeAlignedOffset.getSize((Object)recordPage, (long)recordOffsetInPage); dataRemaining > 0; dataRemaining -= toTransfer) {
                    toTransfer = Math.min(this.diskWriteBufferSize, dataRemaining);
                    Platform.copyMemory((Object)recordPage, (long)recordReadPosition, (Object)writeBuffer, (long)Platform.BYTE_ARRAY_OFFSET, (long)toTransfer);
                    writer.write(writeBuffer, 0, toTransfer);
                    recordReadPosition += (long)toTransfer;
                }
                writer.recordWritten();
            }
            committedSegment = writer.commitAndGet();
        }
        if (currentPartition != -1) {
            spillInfo.partitionLengths[currentPartition] = committedSegment.length();
            this.spills.add(spillInfo);
        }
        if (!isFinalFile) {
            this.writeMetrics.incRecordsWritten(((ShuffleWriteMetrics)writeMetricsToUse).recordsWritten());
            this.taskContext.taskMetrics().incDiskBytesSpilled(((ShuffleWriteMetrics)writeMetricsToUse).bytesWritten());
        }
    }

    @Override
    public long spill(long size, MemoryConsumer trigger) throws IOException {
        if (trigger != this || this.inMemSorter == null || this.inMemSorter.numRecords() == 0) {
            return 0L;
        }
        this.writeSortedFile(false);
        long spillSize = this.freeMemory();
        this.inMemSorter.reset();
        this.taskContext.taskMetrics().incMemoryBytesSpilled(spillSize);
        return spillSize;
    }

    private long getMemoryUsage() {
        long totalPageSize = 0L;
        for (MemoryBlock page : this.allocatedPages) {
            totalPageSize += page.size();
        }
        return (this.inMemSorter == null ? 0L : this.inMemSorter.getMemoryUsage()) + totalPageSize;
    }

    private void updatePeakMemoryUsed() {
        long mem = this.getMemoryUsage();
        if (mem > this.peakMemoryUsedBytes) {
            this.peakMemoryUsedBytes = mem;
        }
    }

    long getPeakMemoryUsedBytes() {
        this.updatePeakMemoryUsed();
        return this.peakMemoryUsedBytes;
    }

    private long freeMemory() {
        this.updatePeakMemoryUsed();
        long memoryFreed = 0L;
        for (MemoryBlock block : this.allocatedPages) {
            memoryFreed += block.size();
            this.freePage(block);
        }
        this.allocatedPages.clear();
        this.currentPage = null;
        this.pageCursor = 0L;
        this.inMemRecordsSize = 0L;
        return memoryFreed;
    }

    public void cleanupResources() {
        this.freeMemory();
        if (this.inMemSorter != null) {
            this.inMemSorter.free();
            this.inMemSorter = null;
        }
        for (SpillInfo spill : this.spills) {
            if (!spill.file.exists() || spill.file.delete()) continue;
            logger.error("Unable to delete spill file {}", new MDC[]{MDC.of((LogKey)LogKeys.PATH$.MODULE$, (Object)spill.file.getPath())});
        }
    }

    private void growPointerArrayIfNecessary() throws IOException {
        assert (this.inMemSorter != null);
        if (!this.inMemSorter.hasSpaceForAnotherRecord()) {
            LongArray array;
            long used = this.inMemSorter.getMemoryUsage();
            try {
                array = this.allocateArray(used / 8L * 2L);
            }
            catch (TooLargePageException e) {
                this.spill();
                return;
            }
            catch (SparkOutOfMemoryError e) {
                if (!this.inMemSorter.hasSpaceForAnotherRecord()) {
                    logger.error("Unable to grow the pointer array");
                    throw e;
                }
                return;
            }
            if (this.inMemSorter.hasSpaceForAnotherRecord()) {
                this.freeArray(array);
            } else {
                this.inMemSorter.expandPointerArray(array);
            }
        }
    }

    private void acquireNewPageIfNecessary(int required) {
        if (this.currentPage == null || this.pageCursor + (long)required > this.currentPage.getBaseOffset() + this.currentPage.size()) {
            this.currentPage = this.allocatePage(required);
            this.pageCursor = this.currentPage.getBaseOffset();
            this.allocatedPages.add(this.currentPage);
        }
    }

    public void insertRecord(Object recordBase, long recordOffset, int length, int partitionId) throws IOException {
        assert (this.inMemSorter != null);
        if (this.inMemSorter.numRecords() >= this.numElementsForSpillThreshold) {
            logger.info("Spilling data because number of spilledRecords ({}) crossed the threshold {}", new MDC[]{MDC.of((LogKey)LogKeys.NUM_ELEMENTS_SPILL_RECORDS$.MODULE$, (Object)this.inMemSorter.numRecords()), MDC.of((LogKey)LogKeys.NUM_ELEMENTS_SPILL_THRESHOLD$.MODULE$, (Object)this.numElementsForSpillThreshold)});
            this.spill();
        } else if (this.inMemRecordsSize >= this.recordsSizeForSpillThreshold) {
            logger.info("Spilling data because size of spilledRecords ({}) crossed the size threshold {}", new MDC[]{MDC.of((LogKey)LogKeys.SPILL_RECORDS_SIZE$.MODULE$, (Object)this.inMemRecordsSize), MDC.of((LogKey)LogKeys.SPILL_RECORDS_SIZE_THRESHOLD$.MODULE$, (Object)this.recordsSizeForSpillThreshold)});
            this.spill();
        }
        this.growPointerArrayIfNecessary();
        int uaoSize = UnsafeAlignedOffset.getUaoSize();
        int required = length + uaoSize;
        this.acquireNewPageIfNecessary(required);
        assert (this.currentPage != null);
        Object base = this.currentPage.getBaseObject();
        long recordAddress = this.taskMemoryManager.encodePageNumberAndOffset(this.currentPage, this.pageCursor);
        UnsafeAlignedOffset.putSize((Object)base, (long)this.pageCursor, (int)length);
        this.pageCursor += (long)uaoSize;
        Platform.copyMemory((Object)recordBase, (long)recordOffset, (Object)base, (long)this.pageCursor, (long)length);
        this.pageCursor += (long)length;
        this.inMemSorter.insertRecord(recordAddress, partitionId);
        this.inMemRecordsSize += (long)required;
    }

    public SpillInfo[] closeAndGetSpills() throws IOException {
        if (this.inMemSorter != null) {
            this.writeSortedFile(this.spills.isEmpty());
            this.freeMemory();
            this.inMemSorter.free();
            this.inMemSorter = null;
        }
        return this.spills.toArray(new SpillInfo[this.spills.size()]);
    }
}

