/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class OneHotEncoderCommon$ {
    public static final OneHotEncoderCommon$ MODULE$ = new OneHotEncoderCommon$();

    private Option<String[]> genOutputAttrNames(StructField inputCol) {
        Attribute inputAttr = Attribute$.MODULE$.fromStructField(inputCol);
        Attribute attribute = inputAttr;
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            if (nominalAttribute.values().isDefined()) {
                return nominalAttribute.values();
            }
            if (nominalAttribute.numValues().isDefined()) {
                return nominalAttribute.numValues().map((Function1 & Serializable)n -> OneHotEncoderCommon$.$anonfun$genOutputAttrNames$1(BoxesRunTime.unboxToInt((Object)n)));
            }
            return None$.MODULE$;
        }
        if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            if (binaryAttribute.values().isDefined()) {
                return binaryAttribute.values();
            }
            return new Some(Array$.MODULE$.tabulate(2, (Function1 & Serializable)x$11 -> OneHotEncoderCommon$.$anonfun$genOutputAttrNames$3(BoxesRunTime.unboxToInt((Object)x$11)), ClassTag$.MODULE$.apply(String.class)));
        }
        if (attribute instanceof NumericAttribute) {
            throw new RuntimeException("The input column " + inputCol.name() + " cannot be continuous-value.");
        }
        return None$.MODULE$;
    }

    private AttributeGroup genOutputAttrGroup(Option<String[]> outputAttrNames, String outputColName) {
        return (AttributeGroup)outputAttrNames.map((Function1 & Serializable)attrNames -> {
            Attribute[] attrs = (Attribute[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attrNames), (Function1 & Serializable)name -> BinaryAttribute$.MODULE$.defaultAttr().withName((String)name), ClassTag$.MODULE$.apply(Attribute.class));
            return new AttributeGroup(outputColName, attrs);
        }).getOrElse((Function0 & Serializable)() -> new AttributeGroup(outputColName));
    }

    public StructField transformOutputColumnSchema(StructField inputCol, String outputColName, boolean dropLast, boolean keepInvalid) {
        Option<String[]> outputAttrNames = this.genOutputAttrNames(inputCol);
        Option filteredOutputAttrNames = outputAttrNames.map((Function1 & Serializable)names -> {
            if (dropLast && !keepInvalid) {
                Predef$.MODULE$.require(((String[])names).length > 1, (Function0 & Serializable)() -> "The input column " + inputCol.name() + " should have at least two distinct values.");
                return (String[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])names), 1);
            }
            if (!dropLast && keepInvalid) {
                return (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])names), (IterableOnce)new .colon.colon((Object)"invalidValues", (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(String.class));
            }
            return names;
        });
        return this.genOutputAttrGroup((Option<String[]>)filteredOutputAttrNames, outputColName).toStructField();
    }

    public boolean transformOutputColumnSchema$default$4() {
        return false;
    }

    public Seq<AttributeGroup> getOutputAttrGroupFromData(Dataset<?> dataset, Seq<String> inputColNames, Seq<String> outputColNames, boolean dropLast) {
        Seq columns = (Seq)inputColNames.map((Function1 & Serializable)inputColName -> functions$.MODULE$.col(inputColName).cast((DataType)DoubleType$.MODULE$));
        int numOfColumns = columns.length();
        RDD qual$1 = dataset.select(columns).rdd().map((Function1 & Serializable)row -> (double[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numOfColumns).map((Function1)(JFunction1.mcDI.sp & Serializable)idx -> row.getDouble(idx)).toArray((ClassTag)ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        double[] x$1 = new double[numOfColumns];
        Function2 & Serializable x$2 = (Function2 & Serializable)(maxValues, curValues) -> {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numOfColumns).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                double x = curValues[idx];
                Predef$.MODULE$.assert(x <= (double)Integer.MAX_VALUE, (Function0 & Serializable)() -> "OneHotEncoder only supports up to " + Integer.MAX_VALUE + " indices, but got " + x + ".");
                Predef$.MODULE$.assert(x >= 0.0 && x == (double)((int)x), (Function0 & Serializable)() -> "Values from column " + inputColNames.apply(idx) + " must be indices, but got " + x + ".");
                maxValues$1[idx] = package$.MODULE$.max(maxValues[idx], x);
            });
            return maxValues;
        };
        Function2 & Serializable x$3 = (Function2 & Serializable)(m0, m1) -> {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numOfColumns).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
                m0$1[idx] = package$.MODULE$.max(m0[idx], m1[idx]);
            });
            return m0;
        };
        int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
        int[] numAttrsArray = (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps((double[])qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))), (Function1)(JFunction1.mcID.sp & Serializable)x$12 -> (int)x$12 + 1, (ClassTag)ClassTag$.MODULE$.Int());
        return (Seq)((IterableOps)outputColNames.zip((IterableOnce)Predef$.MODULE$.wrapIntArray(numAttrsArray))).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String outputColName = (String)tuple2._1();
                int numAttrs = tuple2._2$mcI$sp();
                return MODULE$.createAttrGroupForAttrNames(outputColName, numAttrs, dropLast, false);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public AttributeGroup createAttrGroupForAttrNames(String outputColName, int numAttrs, boolean dropLast, boolean keepInvalid) {
        String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(numAttrs, (Function1 & Serializable)x$13 -> OneHotEncoderCommon$.$anonfun$createAttrGroupForAttrNames$1(BoxesRunTime.unboxToInt((Object)x$13)), ClassTag$.MODULE$.apply(String.class));
        String[] filtered = dropLast && !keepInvalid ? (String[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])outputAttrNames), 1) : (!dropLast && keepInvalid ? (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])outputAttrNames), (IterableOnce)new .colon.colon((Object)"invalidValues", (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(String.class)) : outputAttrNames);
        return this.genOutputAttrGroup((Option<String[]>)new Some((Object)filtered), outputColName);
    }

    public static final /* synthetic */ String $anonfun$genOutputAttrNames$2(int x$10) {
        return Integer.toString(x$10);
    }

    public static final /* synthetic */ String[] $anonfun$genOutputAttrNames$1(int n) {
        return (String[])Array$.MODULE$.tabulate(n, (Function1 & Serializable)x$10 -> OneHotEncoderCommon$.$anonfun$genOutputAttrNames$2(BoxesRunTime.unboxToInt((Object)x$10)), ClassTag$.MODULE$.apply(String.class));
    }

    public static final /* synthetic */ String $anonfun$genOutputAttrNames$3(int x$11) {
        return Integer.toString(x$11);
    }

    public static final /* synthetic */ String $anonfun$createAttrGroupForAttrNames$1(int x$13) {
        return Integer.toString(x$13);
    }

    private OneHotEncoderCommon$() {
    }
}

