/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.catalyst.streaming.WriteToStream;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.AsyncCommitLog;
import org.apache.spark.sql.execution.streaming.AsyncOffsetSeqLog;
import org.apache.spark.sql.execution.streaming.AsyncProgressTrackingMicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.AsyncStreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.AvailableNowTrigger$;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.CommitMetadata$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.MicroBatchExecutionContext;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001B\u0016-\u0001eB\u0011B\u0010\u0001\u0003\u0002\u0003\u0006IaP#\t\u0013!\u0003!\u0011!Q\u0001\n%s\u0005\"C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002)W\u0011!9\u0006A!A!\u0002\u0013A\u0006\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u000bA\u0004A\u0011A9\t\u000fa\u0004!\u0019!C\ts\"1a\u0010\u0001Q\u0001\niD\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0004!I\u0011Q\u0004\u0001C\u0002\u0013%\u0011q\u0004\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\"!I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011\u0007\u0005\n\u0003s\u0001\u0001\u0019!C\u0005\u0003wA\u0001\"a\u0012\u0001A\u0003&\u00111\u0007\u0005\n\u0003\u0013\u0002!\u0019!C\t\u0003\u0017B\u0001\"a\u0015\u0001A\u0003%\u0011Q\n\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003/B\u0001\"a\u0018\u0001A\u0003%\u0011\u0011\f\u0005\u000b\u0003C\u0002\u0001R1A\u0005B\u0005\r\u0004BCA6\u0001!\u0015\r\u0011\"\u0011\u0002n!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003#\u0003A\u0011IAJ\u0011\u001d\t9\n\u0001C!\u00033Cq!!(\u0001\t\u0003\ny\nC\u0004\u0002$\u0002!\t%!*\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBAZ\u0001\u0011E\u0013Q\u0017\u0005\b\u0003{\u0003A\u0011BA[\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003<q!a1-\u0011\u0003\t)M\u0002\u0004,Y!\u0005\u0011q\u0019\u0005\u0007a\n\"\t!a4\t\u0013\u0005E'E1A\u0005\u0002\u0005M\u0007\u0002CApE\u0001\u0006I!!6\t\u0013\u0005\u0005(E1A\u0005\u0002\u0005M\u0007\u0002CArE\u0001\u0006I!!6\t\u0013\u0005\u0015(E1A\u0005\u0002\u0005M\u0007\u0002CAtE\u0001\u0006I!!6\t\u000f\u0005%(\u0005\"\u0003\u0002l\nA\u0013i]=oGB\u0013xn\u001a:fgN$&/Y2lS:<W*[2s_\n\u000bGo\u00195Fq\u0016\u001cW\u000f^5p]*\u0011QFL\u0001\ngR\u0014X-Y7j]\u001eT!a\f\u0019\u0002\u0013\u0015DXmY;uS>t'BA\u00193\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003gQ\nQa\u001d9be.T!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO\u000e\u00011C\u0001\u0001;!\tYD(D\u0001-\u0013\tiDFA\nNS\u000e\u0014xNQ1uG\",\u00050Z2vi&|g.\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002A\u00076\t\u0011I\u0003\u0002Ca\u000591\r\\1tg&\u001c\u0017B\u0001#B\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0013\tqd)\u0003\u0002HY\ty1\u000b\u001e:fC6,\u00050Z2vi&|g.A\u0004ue&<w-\u001a:\u0011\u0005)cU\"A&\u000b\u00055\u0002\u0014BA'L\u0005\u001d!&/[4hKJL!\u0001\u0013$\u0002\u0019Q\u0014\u0018nZ4fe\u000ecwnY6\u0011\u0005E#V\"\u0001*\u000b\u0005M\u0013\u0014\u0001B;uS2L!!\u0016*\u0003\u000b\rcwnY6\n\u0005=3\u0015\u0001D3yiJ\fw\n\u001d;j_:\u001c\b\u0003B-cK\u0016t!A\u00171\u0011\u0005msV\"\u0001/\u000b\u0005uC\u0014A\u0002\u001fs_>$hHC\u0001`\u0003\u0015\u00198-\u00197b\u0013\t\tg,\u0001\u0004Qe\u0016$WMZ\u0005\u0003G\u0012\u00141!T1q\u0015\t\tg\f\u0005\u0002ZM&\u0011q\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\tAd\u0017M\u001c\t\u0003U:l\u0011a\u001b\u0006\u0003[1T!!\u001c\u0019\u0002\u0011\r\fG/\u00197zgRL!a\\6\u0003\u001b]\u0013\u0018\u000e^3U_N#(/Z1n\u0003\u0019a\u0014N\\5u}Q1!o\u001d;vm^\u0004\"a\u000f\u0001\t\u000by2\u0001\u0019A \t\u000b!3\u0001\u0019A%\t\u000b=3\u0001\u0019\u0001)\t\u000b]3\u0001\u0019\u0001-\t\u000b!4\u0001\u0019A5\u0002Y\u0005\u001c\u0018P\\2Qe><'/Z:t)J\f7m[5oO\u000eCWmY6q_&tG/\u001b8h\u0013:$XM\u001d<bY6\u001bX#\u0001>\u0011\u0005mdX\"\u00010\n\u0005ut&\u0001\u0002'p]\u001e\fQ&Y:z]\u000e\u0004&o\\4sKN\u001cHK]1dW&twm\u00115fG.\u0004x.\u001b8uS:<\u0017J\u001c;feZ\fG.T:!\u0003E\u0019x.\u001e:dK\u000e{W.\\5u#V,W/Z\u000b\u0003\u0003\u0007\u0001b!!\u0002\u0002\u0012\u0005UQBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0015\r|gnY;se\u0016tGOC\u0002T\u0003\u001bQ!!a\u0004\u0002\t)\fg/Y\u0005\u0005\u0003'\t9AA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0007m\n9\"C\u0002\u0002\u001a1\u0012\u0011b\u00144gg\u0016$8+Z9\u0002%M|WO]2f\u0007>lW.\u001b;Rk\u0016,X\rI\u0001#Y\u0006\u001cHOQ1uG\"\u0004VM]:jgR,G\rV8EkJ\f'\r\\3Ti>\u0014\u0018mZ3\u0016\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\t\u0005\u001d\u0012qA\u0001\u0007CR|W.[2\n\t\u0005-\u0012Q\u0005\u0002\u000b\u0003R|W.[2M_:<\u0017a\t7bgR\u0014\u0015\r^2i!\u0016\u00148/[:uK\u0012$v\u000eR;sC\ndWm\u0015;pe\u0006<W\rI\u0001\rSN4\u0015N]:u\u0005\u0006$8\r[\u000b\u0003\u0003g\u00012a_A\u001b\u0013\r\t9D\u0018\u0002\b\u0005>|G.Z1o\u0003AI7OR5sgR\u0014\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005\r\u0003cA>\u0002@%\u0019\u0011\u0011\t0\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u000br\u0011\u0011!a\u0001\u0003g\t1\u0001\u001f\u00132\u00035I7OR5sgR\u0014\u0015\r^2iA\u0005Q\u0012m]=oG^\u0013\u0018\u000e^3t\u000bb,7-\u001e;peN+'O^5dKV\u0011\u0011Q\n\t\u0005\u0003\u000b\ty%\u0003\u0003\u0002R\u0005\u001d!A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_J\f1$Y:z]\u000e<&/\u001b;fg\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013aF1ts:\u001c7\t[3dWB|\u0017N\u001c;NKR\fG-\u0019;b+\t\tI\u0006E\u0002<\u00037J1!!\u0018-\u0005\u0015\n5/\u001f8d'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0007\",7m\u001b9pS:$X*\u001a;bI\u0006$\u0018-\u0001\rbgft7m\u00115fG.\u0004x.\u001b8u\u001b\u0016$\u0018\rZ1uC\u0002\n\u0011b\u001c4gg\u0016$Hj\\4\u0016\u0005\u0005\u0015\u0004cA\u001e\u0002h%\u0019\u0011\u0011\u000e\u0017\u0003#\u0005\u001b\u0018P\\2PM\u001a\u001cX\r^*fc2{w-A\u0005d_6l\u0017\u000e\u001e'pOV\u0011\u0011q\u000e\t\u0004w\u0005E\u0014bAA:Y\tq\u0011i]=oG\u000e{W.\\5u\u0019><\u0017!\t<bY&$\u0017\r^3PM\u001a\u001cX\r\u001e'pO\u0006sGmR3u!J,go\u00144gg\u0016$H\u0003BA=\u0003\u007f\u0002Ra_A>\u0003+I1!! _\u0005\u0019y\u0005\u000f^5p]\"1\u0011\u0011\u0011\fA\u0002i\fQ\u0002\\1uKN$()\u0019;dQ&#\u0017\u0001H7be.l\u0015n\u0019:p\u0005\u0006$8\r[#yK\u000e,H/[8o'R\f'\u000f\u001e\u000b\u0005\u0003{\t9\tC\u0004\u0002\n^\u0001\r!a#\u0002\u000f\u0015DXmY\"uqB\u00191(!$\n\u0007\u0005=EF\u0001\u000eNS\u000e\u0014xNQ1uG\",\u00050Z2vi&|gnQ8oi\u0016DH/A\u000fdY\u0016\fg.\u00169MCN$X\t_3dkR,G-T5de>\u0014\u0015\r^2i)\u0011\ti$!&\t\u000f\u0005%\u0005\u00041\u0001\u0002\f\u0006\u0019R.\u0019:l\u001b&\u001c'o\u001c\"bi\u000eD7\u000b^1siR!\u0011QHAN\u0011\u001d\tI)\u0007a\u0001\u0003\u0017\u000b\u0011#\\1sW6K7M]8CCR\u001c\u0007.\u00128e)\u0011\ti$!)\t\u000f\u0005%%\u00041\u0001\u0002\f\u0006)\u0001/\u001e:hKR!\u0011QHAT\u0011\u0019\tIk\u0007a\u0001u\u0006IA\u000f\u001b:fg\"|G\u000eZ\u0001\bG2,\u0017M\\;q)\t\ti$\u0001\u000fbe\u0016<&/\u001b;fgB+g\u000eZ5oO>\u0013\u0018J\u001c)s_\u001e\u0014Xm]:\u0015\u0005\u0005M\u0012AC4fiR\u0013\u0018nZ4feR\u0011\u0011q\u0017\t\u0004w\u0005e\u0016bAA^Y\tyAK]5hO\u0016\u0014X\t_3dkR|'/A\u000bwC2LG-\u0019;f\u0003:$w)\u001a;Ue&<w-\u001a:\u0002=\rDWmY6O_R\u001cF/\u0019;fMVd7\u000b\u001e:fC6LgnZ)vKJLXCAA\u001f\u0003!\n5/\u001f8d!J|wM]3tgR\u0013\u0018mY6j]\u001el\u0015n\u0019:p\u0005\u0006$8\r[#yK\u000e,H/[8o!\tY$eE\u0002#\u0003\u0013\u00042a_Af\u0013\r\tiM\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005\u0015\u0017aH!T3:\u001bu\f\u0015*P\u000fJ+5kU0U%\u0006\u001b5*\u0013(H?\u0016s\u0015I\u0011'F\tV\u0011\u0011Q\u001b\t\u0005\u0003/\fi.\u0004\u0002\u0002Z*!\u00111\\A\u0007\u0003\u0011a\u0017M\\4\n\u0007\u001d\fI.\u0001\u0011B'fs5i\u0018)S\u001f\u001e\u0013ViU*`)J\u000b5iS%O\u000f~+e*\u0011\"M\u000b\u0012\u0003\u0013!M!T3:\u001bu\f\u0015*P\u000fJ+5kU0U%\u0006\u001b5*\u0013(H?\u000eCUiQ&Q\u001f&sE+\u0013(H?&sE+\u0012*W\u00032{VjU\u00013\u0003NKfjQ0Q%>;%+R*T?R\u0013\u0016iQ&J\u001d\u001e{6\tS#D\u0017B{\u0015J\u0014+J\u001d\u001e{\u0016J\u0014+F%Z\u000bEjX'TA\u0005\u0019\u0014iU-O\u0007~\u0003&kT$S\u000bN\u001bv\f\u0016*B\u0007.KejR0P-\u0016\u0013&+\u0013#F?NKejS0T+B\u0003vJ\u0015+`\u0007\"+5iS\u00015\u0003NKfjQ0Q%>;%+R*T?R\u0013\u0016iQ&J\u001d\u001e{vJV#S%&#UiX*J\u001d.{6+\u0016)Q\u001fJ#vl\u0011%F\u0007.\u0003\u0013aL4fi\u0006\u001b\u0018P\\2Qe><'/Z:t)J\f7m[5oO\u000eCWmY6q_&tG/\u001b8h\u0013:$XM\u001d<bY6\u001bHc\u0001>\u0002n\")qK\u000ba\u00011\u0002")
public class AsyncProgressTrackingMicroBatchExecution
extends MicroBatchExecution {
    private AsyncOffsetSeqLog offsetLog;
    private AsyncCommitLog commitLog;
    private final Map<String, String> extraOptions;
    private final WriteToStream plan;
    private final long asyncProgressTrackingCheckpointingIntervalMs;
    private final ConcurrentLinkedQueue<OffsetSeq> sourceCommitQueue;
    private final AtomicLong lastBatchPersistedToDurableStorage;
    private boolean isFirstBatch;
    private final ThreadPoolExecutor asyncWritesExecutorService;
    private final AsyncStreamingQueryCheckpointMetadata asyncCheckpointMetadata;
    private volatile byte bitmap$0;

    public static String ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK();
    }

    public static String ASYNC_PROGRESS_TRACKING_CHECKPOINTING_INTERVAL_MS() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_CHECKPOINTING_INTERVAL_MS();
    }

    public static String ASYNC_PROGRESS_TRACKING_ENABLED() {
        return AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_ENABLED();
    }

    public long asyncProgressTrackingCheckpointingIntervalMs() {
        return this.asyncProgressTrackingCheckpointingIntervalMs;
    }

    private ConcurrentLinkedQueue<OffsetSeq> sourceCommitQueue() {
        return this.sourceCommitQueue;
    }

    private AtomicLong lastBatchPersistedToDurableStorage() {
        return this.lastBatchPersistedToDurableStorage;
    }

    private boolean isFirstBatch() {
        return this.isFirstBatch;
    }

    private void isFirstBatch_$eq(boolean x$1) {
        this.isFirstBatch = x$1;
    }

    public ThreadPoolExecutor asyncWritesExecutorService() {
        return this.asyncWritesExecutorService;
    }

    private AsyncStreamingQueryCheckpointMetadata asyncCheckpointMetadata() {
        return this.asyncCheckpointMetadata;
    }

    private AsyncOffsetSeqLog offsetLog$lzycompute() {
        AsyncProgressTrackingMicroBatchExecution asyncProgressTrackingMicroBatchExecution = this;
        synchronized (asyncProgressTrackingMicroBatchExecution) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.offsetLog = this.asyncCheckpointMetadata().offsetLog();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.offsetLog;
    }

    @Override
    public AsyncOffsetSeqLog offsetLog() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.offsetLog$lzycompute();
        }
        return this.offsetLog;
    }

    private AsyncCommitLog commitLog$lzycompute() {
        AsyncProgressTrackingMicroBatchExecution asyncProgressTrackingMicroBatchExecution = this;
        synchronized (asyncProgressTrackingMicroBatchExecution) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.commitLog = this.asyncCheckpointMetadata().commitLog();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.commitLog;
    }

    @Override
    public AsyncCommitLog commitLog() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.commitLog$lzycompute();
        }
        return this.commitLog;
    }

    @Override
    public Option<OffsetSeq> validateOffsetLogAndGetPrevOffset(long latestBatchId) {
        Option<Object> prevBatchId = this.offsetLog().getPrevBatchFromStorage(latestBatchId);
        if (latestBatchId != 0L && prevBatchId.isDefined()) {
            return new Some(this.offsetLog().get(BoxesRunTime.unboxToLong((Object)prevBatchId.get())).getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Offset metadata for batch " + prevBatchId + " cannot be found.  This should not happen.");
            }));
        }
        return None$.MODULE$;
    }

    @Override
    public void markMicroBatchExecutionStart(MicroBatchExecutionContext execCtx) {
        this.checkNotStatefulStreamingQuery();
    }

    @Override
    public void cleanUpLastExecutedMicroBatch(MicroBatchExecutionContext execCtx) {
    }

    @Override
    public void markMicroBatchStart(MicroBatchExecutionContext execCtx) {
        Object object = new Object();
        try {
            ((CompletableFuture)this.offsetLog().addAsync(execCtx.batchId(), execCtx.endOffsets().toOffsetSeq(this.sources(), execCtx.offsetSeqMetadata())).thenAccept(tuple -> {
                Tuple2 tuple2 = tuple;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long batchId = tuple2._1$mcJ$sp();
                boolean persistedToDurableStorage = tuple2._2$mcZ$sp();
                Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(batchId, persistedToDurableStorage);
                long batchId2 = sp2._1$mcJ$sp();
                boolean persistedToDurableStorage2 = sp2._2$mcZ$sp();
                if (persistedToDurableStorage2) {
                    if (this.lastBatchPersistedToDurableStorage().get() == -1L) {
                        this.lastBatchPersistedToDurableStorage().set(BoxesRunTime.unboxToLong((Object)this.offsetLog().getPrevBatchFromStorage(batchId2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)));
                    }
                    if (batchId2 != 0L && this.lastBatchPersistedToDurableStorage().get() != -1L) {
                        Predef$.MODULE$.assert(this.lastBatchPersistedToDurableStorage().get() < batchId2);
                        Option prevBatchOff = this.offsetLog().get(this.lastBatchPersistedToDurableStorage().get());
                        if (!prevBatchOff.isDefined()) {
                            throw new IllegalStateException("Failed to commit processed data in the source because batch " + this.lastBatchPersistedToDurableStorage().get() + " doesn't exist in the offset log.  This should not happen.");
                        }
                        v0 = BoxesRunTime.boxToBoolean((boolean)this.sourceCommitQueue().add((OffsetSeq)prevBatchOff.get()));
                    } else {
                        v0 = BoxedUnit.UNIT;
                    }
                    this.lastBatchPersistedToDurableStorage().set(batchId2);
                    return;
                }
            })).exceptionally(th -> {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error while performing async offset write for batch "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)execCtx.batchId()))})))), (Throwable)th);
                this.errorNotifier().markError((Throwable)th);
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            OffsetSeq offset = this.sourceCommitQueue().poll();
            while (offset != null) {
                this.commitSources(offset);
                offset = this.sourceCommitQueue().poll();
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void markMicroBatchEnd(MicroBatchExecutionContext execCtx) {
        Object object = new Object();
        try {
            this.watermarkTracker().updateWatermark(execCtx.executionPlan().executedPlan());
            execCtx.reportTimeTaken("commitOffsets", (JFunction0.mcV.sp & Serializable)() -> {
                if (this.offsetLog().getAsyncOffsetWrite(execCtx.batchId()).nonEmpty() || this.isFirstBatch()) {
                    this.isFirstBatch_$eq(false);
                    v0 = this.commitLog().addAsync(execCtx.batchId(), new CommitMetadata(this.watermarkTracker().currentWatermark(), CommitMetadata$.MODULE$.apply$default$2())).exceptionally(th -> BoxesRunTime.boxToLong((long)AsyncProgressTrackingMicroBatchExecution.$anonfun$markMicroBatchEnd$2(this, execCtx, object, th)));
                } else {
                    if (!this.commitLog().addInMemory(execCtx.batchId(), new CommitMetadata(this.watermarkTracker().currentWatermark(), CommitMetadata$.MODULE$.apply$default$2()))) {
                        throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(execCtx.batchId());
                    }
                    v0 = BoxedUnit.UNIT;
                }
                this.offsetLog().removeAsyncOffsetWrite(execCtx.batchId());
            });
            this.committedOffsets_$eq((StreamProgress)this.committedOffsets().$plus$plus((IterableOnce)execCtx.endOffsets()));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    @Override
    public void purge(long threshold) {
        while (this.offsetLog().writtenToDurableStorage().size() > this.minLogEntriesToMaintain()) {
            this.offsetLog().writtenToDurableStorage().poll();
        }
        this.offsetLog().purge(BoxesRunTime.unboxToLong((Object)this.offsetLog().writtenToDurableStorage().peek()));
        while (this.commitLog().writtenToDurableStorage().size() > this.minLogEntriesToMaintain()) {
            this.commitLog().writtenToDurableStorage().poll();
        }
        this.commitLog().purge(BoxesRunTime.unboxToLong((Object)this.commitLog().writtenToDurableStorage().peek()));
    }

    @Override
    public void cleanup() {
        super.cleanup();
        ThreadUtils$.MODULE$.shutdown((ExecutorService)this.asyncWritesExecutorService(), ThreadUtils$.MODULE$.shutdown$default$2());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Async progress tracking executor pool for query "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " has been shutdown"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.PRETTY_ID_STRING$.MODULE$, (Object)this.prettyIdString())})))));
    }

    public boolean areWritesPendingOrInProgress() {
        return this.asyncWritesExecutorService().getQueue().size() > 0 || this.asyncWritesExecutorService().getActiveCount() > 0;
    }

    @Override
    public TriggerExecutor getTrigger() {
        return this.validateAndGetTrigger();
    }

    private TriggerExecutor validateAndGetTrigger() {
        Trigger trigger;
        block13: {
            if (!StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)this.extraOptions.getOrElse((Object)AsyncProgressTrackingMicroBatchExecution$.MODULE$.ASYNC_PROGRESS_TRACKING_OVERRIDE_SINK_SUPPORT_CHECK(), (Function0 & Serializable)() -> "false")))) {
                try {
                    String string = this.plan.sink().name();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -1007587933: {
                            if (!"noop-table".equals(string)) break;
                            break block13;
                        }
                        case -373802904: {
                            if (!"KafkaTable".equals(string)) break;
                            break block13;
                        }
                        case -316439724: {
                            if (!"MemorySink".equals(string)) break;
                            break block13;
                        }
                        case 951510359: {
                            if (!"console".equals(string)) break;
                            break block13;
                        }
                    }
                    throw new IllegalArgumentException("Sink " + this.plan.sink().name() + " does not support async progress tracking");
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("should not be called.")) {
                        throw new IllegalArgumentException("Sink " + this.plan.sink() + " does not support async progress tracking");
                    }
                    throw e;
                }
            }
        }
        if ((trigger = super.trigger()) instanceof ProcessingTimeTrigger) {
            ProcessingTimeTrigger processingTimeTrigger = (ProcessingTimeTrigger)trigger;
            return new ProcessingTimeExecutor(processingTimeTrigger, super.triggerClock());
        }
        if (OneTimeTrigger$.MODULE$.equals(trigger)) {
            throw new IllegalArgumentException("Async progress tracking cannot be used with Once trigger");
        }
        if (AvailableNowTrigger$.MODULE$.equals(trigger)) {
            throw new IllegalArgumentException("Async progress tracking cannot be used with AvailableNow trigger");
        }
        throw new IllegalStateException("Unknown type of trigger: " + super.trigger());
    }

    private void checkNotStatefulStreamingQuery() {
        if (this.isFirstBatch()) {
            this.lastExecution().executedPlan().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof StateStoreWriter) {
                        throw new IllegalArgumentException("Stateful streaming queries does not support async progress tracking at this moment.");
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    return sparkPlan instanceof StateStoreWriter;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$markMicroBatchEnd$2(AsyncProgressTrackingMicroBatchExecution $this, MicroBatchExecutionContext execCtx$2, Object nonLocalReturnKey2$1, Throwable th) {
        $this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Got exception during async write to commit log for batch "}))).log((Seq)Nil$.MODULE$).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.BATCH_ID$.MODULE$, (Object)BoxesRunTime.boxToLong((long)execCtx$2.batchId()))})))), th);
        $this.errorNotifier().markError(th);
        throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey2$1, BoxedUnit.UNIT);
    }

    public AsyncProgressTrackingMicroBatchExecution(SparkSession sparkSession, Trigger trigger, Clock triggerClock, Map<String, String> extraOptions, WriteToStream plan) {
        this.extraOptions = extraOptions;
        this.plan = plan;
        super(sparkSession, trigger, triggerClock, extraOptions, plan);
        this.asyncProgressTrackingCheckpointingIntervalMs = AsyncProgressTrackingMicroBatchExecution$.MODULE$.org$apache$spark$sql$execution$streaming$AsyncProgressTrackingMicroBatchExecution$$getAsyncProgressTrackingCheckpointingIntervalMs(extraOptions);
        this.sourceCommitQueue = new ConcurrentLinkedQueue();
        this.lastBatchPersistedToDurableStorage = new AtomicLong(-1L);
        this.isFirstBatch = true;
        this.asyncWritesExecutorService = ThreadUtils$.MODULE$.newDaemonSingleThreadExecutorWithRejectedExecutionHandler("async-log-write", 2, new RejectedExecutionHandler(this){
            private final /* synthetic */ AsyncProgressTrackingMicroBatchExecution $outer;

            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                block3: {
                    try {
                        if (executor.isShutdown()) break block3;
                        long start = System.currentTimeMillis();
                        executor.getQueue().put(r);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Async write paused execution for " + (System.currentTimeMillis() - start) + " due to task queue being full.");
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RejectedExecutionException("Producer interrupted", e);
                    }
                    catch (Throwable e) {
                        this.$outer.logError((Function0<String>)(Function0 & Serializable)() -> "Encountered error in async write executor service", e);
                        this.$outer.errorNotifier().markError(e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$rejectedExecution$1(long ), $anonfun$rejectedExecution$2()}, serializedLambda);
            }
        });
        this.asyncCheckpointMetadata = new AsyncStreamingQueryCheckpointMetadata(this.sparkSessionForStream(), this.resolvedCheckpointRoot(), this.asyncWritesExecutorService(), this.asyncProgressTrackingCheckpointingIntervalMs(), super.triggerClock());
        this.validateAndGetTrigger();
    }
}

