/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.spark.SparkUnsupportedOperationException;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.jdbc.OracleDialect$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rEd\u0001B\"E\t>CQa\u001c\u0001\u0005\u0002ADQA\u001d\u0001\u0005BMD\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u000fA\u0011\"a\n\u0001\u0005\u0004%I!!\u0002\t\u0011\u0005%\u0002\u0001)A\u0005\u0003\u000fA\u0011\"a\u000b\u0001\u0005\u0004%I!!\u0002\t\u0011\u00055\u0002\u0001)A\u0005\u0003\u000fAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u00028\u0001!\t%!\u000f\u0007\r\u0005%\u0003\u0001AA&\u0011\u0019y7\u0002\"\u0001\u0002V!9\u0011\u0011L\u0006\u0005B\u0005m\u0003bBA7\u0017\u0011\u0005\u0013q\u000e\u0005\b\u0003\u001b[A\u0011BAH\u0011\u001d\ti\n\u0001C!\u0003?Cq!a+\u0001\t\u0003\ni\u000bC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005%\b\u0001\"\u0011\u0002l\"9\u0011q\u001f\u0001\u0005B\u0005e\bbBA\u007f\u0001\u0011\u0005\u0013q \u0005\b\u0005\u000b\u0001A\u0011\tB\u0004\u0011%\u0011\t\u0002AI\u0001\n\u0003\u0011\u0019\u0002C\u0004\u0003*\u0001!\tEa\u000b\t\u000f\te\u0002\u0001\"\u0011\u0003<!9!Q\t\u0001\u0005B\t\u001d\u0003b\u0002B)\u0001\u0011\u0005#1\u000b\u0005\b\u0005?\u0002A\u0011\tB1\r\u0019\u00119\u0007\u0001\u0001\u0003j!I!\u0011O\u000f\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u000b\u0005gj\"\u0011!Q\u0001\n\tU\u0004BB8\u001e\t\u0003\u00119\tC\u0004\u0003\u0010v!\tE!%\t\u000f\tM\u0005\u0001\"\u0011\u0003\u0016\"9!\u0011\u0014\u0001\u0005B\tm\u0005b\u0002BO\u0001\u0011\u0005#1\u0014\u0005\b\u0005?\u0003A\u0011\tBN\u0011\u001d\u0011\t\u000b\u0001C!\u0005GC\u0001B!5\u0001\u0003\u0003%\t\u0001\u001d\u0005\n\u0005'\u0004\u0011\u0011!C!\u0005+D\u0011Ba6\u0001\u0003\u0003%\tA!7\t\u0013\tm\u0007!!A\u0005\u0002\tu\u0007\"\u0003Br\u0001\u0005\u0005I\u0011\tBs\u0011%\u0011y\u000fAA\u0001\n\u0003\u0011\t\u0010C\u0005\u0003v\u0002\t\t\u0011\"\u0011\u0003x\"I!1 \u0001\u0002\u0002\u0013\u0005#Q \u0005\n\u0005\u007f\u0004\u0011\u0011!C!\u0007\u0003A\u0011ba\u0001\u0001\u0003\u0003%\te!\u0002\b\u0011\r%A\t#\u0001E\u0007\u00171qa\u0011#\t\u0002\u0011\u001bi\u0001\u0003\u0004pe\u0011\u00051q\u0004\u0005\n\u0007C\u0011$\u0019!C\u0003\u0007GA\u0001b!\u000b3A\u000351Q\u0005\u0005\n\u0007W\u0011$\u0019!C\u0003\u0007[A\u0001ba\r3A\u000351q\u0006\u0005\n\u0007k\u0011$\u0019!C\u0003\u0007oA\u0001b!\u00103A\u000351\u0011\b\u0005\n\u0007\u007f\u0011$\u0019!C\u0003\u0007\u0003B\u0001ba\u00123A\u0003511\t\u0005\n\u0007\u0013\u0012$\u0019!C\u0003\u0007\u0017B\u0001b!\u00153A\u000351Q\n\u0005\n\u0007'\u0012$\u0019!C\u0003\u0007+B\u0001ba\u00173A\u000351q\u000b\u0005\t\u0007;\u0012\u0014\u0011!CAa\"I1q\f\u001a\u0002\u0002\u0013\u00055\u0011\r\u0005\n\u0007O\u0012\u0014\u0011!C\u0005\u0007S\u0012Qb\u0014:bG2,G)[1mK\u000e$(BA#G\u0003\u0011QGMY2\u000b\u0005\u001dC\u0015aA:rY*\u0011\u0011JS\u0001\u0006gB\f'o\u001b\u0006\u0003\u00172\u000ba!\u00199bG\",'\"A'\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001FKW/d!\t\t&+D\u0001E\u0013\t\u0019FIA\u0006KI\n\u001cG)[1mK\u000e$\bCA+Y\u001b\u00051&BA,G\u0003!\u0019\u0017\r^1msN$\u0018BA-W\u00055\u0019\u0016\u000bT\"p]\u001aDU\r\u001c9feB\u0011\u0011kW\u0005\u00039\u0012\u0013\u0011CT8MK\u001e\f7-\u001f&E\u0005\u000e+%O]8s!\tq\u0016-D\u0001`\u0015\u0005\u0001\u0017!B:dC2\f\u0017B\u00012`\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u001a7\u000f\u0005\u0015TgB\u00014j\u001b\u00059'B\u00015O\u0003\u0019a$o\\8u}%\t\u0001-\u0003\u0002l?\u00069\u0001/Y2lC\u001e,\u0017BA7o\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tYw,\u0001\u0004=S:LGO\u0010\u000b\u0002cB\u0011\u0011\u000bA\u0001\nG\u0006t\u0007*\u00198eY\u0016$\"\u0001^<\u0011\u0005y+\u0018B\u0001<`\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u001f\u0002A\u0002e\f1!\u001e:m!\tQhP\u0004\u0002|yB\u0011amX\u0005\u0003{~\u000ba\u0001\u0015:fI\u00164\u0017bA@\u0002\u0002\t11\u000b\u001e:j]\u001eT!!`0\u0002K\u0011L7\u000f^5oGR,fn];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001cXCAA\u0004!\u0019\tI!a\u0005\u0002\u00185\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011C0\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0016\u0005-!aA*fiB!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011\u0001\u00027b]\u001eT!!!\t\u0002\t)\fg/Y\u0005\u0004\u007f\u0006m\u0011A\n3jgRLgn\u0019;V]N,\b\u000f]8si\u0016$\u0017iZ4sK\u001e\fG/\u001a$v]\u000e$\u0018n\u001c8tA\u0005Y2/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N\fAd];qa>\u0014H/\u001a3BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:\u001c\b%\u0001\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\u0018aE:vaB|'\u000f^3e\rVt7\r^5p]N\u0004\u0013aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGc\u0001;\u00024!1\u0011QG\u0005A\u0002e\f\u0001BZ;oG:\u000bW.Z\u0001\u001aSN|%M[3di:{GOR8v]\u0012,\u0005pY3qi&|g\u000eF\u0002u\u0003wAq!!\u0010\u000b\u0001\u0004\ty$A\u0001f!\u0011\t\t%!\u0012\u000e\u0005\u0005\r#bA$\u0002 %!\u0011qIA\"\u00051\u0019\u0016\u000bT#yG\u0016\u0004H/[8o\u0005Ay%/Y2mKN\u000bFJQ;jY\u0012,'oE\u0002\f\u0003\u001b\u0002B!a\u0014\u0002R5\t\u0001!C\u0002\u0002TI\u0013aB\u0013#C\u0007N\u000bFJQ;jY\u0012,'\u000f\u0006\u0002\u0002XA\u0019\u0011qJ\u0006\u0002-YL7/\u001b;BO\u001e\u0014XmZ1uK\u001a+hn\u0019;j_:$r!_A/\u0003?\n\u0019\u0007\u0003\u0004\u000265\u0001\r!\u001f\u0005\u0007\u0003Cj\u0001\u0019\u0001;\u0002\u0015%\u001cH)[:uS:\u001cG\u000fC\u0004\u0002f5\u0001\r!a\u001a\u0002\r%t\u0007/\u001e;t!\u0011q\u0016\u0011N=\n\u0007\u0005-tLA\u0003BeJ\f\u00170A\u000bwSNLGOQ5oCJL8i\\7qCJL7o\u001c8\u0015\u000fe\f\t(!\u001e\u0002\n\"1\u00111\u000f\bA\u0002e\fAA\\1nK\"9\u0011q\u000f\bA\u0002\u0005e\u0014A\u00017f!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u00111\u0011$\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BAD\u0003{\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\tYI\u0004a\u0001\u0003s\n!A]3\u0002\u0017\r|W\u000e]1sK\ncwN\u0019\u000b\bs\u0006E\u0015QSAM\u0011\u001d\t\u0019j\u0004a\u0001\u0003s\n1\u0001\u001c5t\u0011\u0019\t9j\u0004a\u0001s\u0006Aq\u000e]3sCR|'\u000fC\u0004\u0002\u001c>\u0001\r!!\u001f\u0002\u0007ID7/A\td_6\u0004\u0018\u000e\\3FqB\u0014Xm]:j_:$B!!)\u0002(B!a,a)z\u0013\r\t)k\u0018\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005%\u0006\u00031\u0001\u0002z\u0005!Q\r\u001f9s\u0003=9W\r^\"bi\u0006d\u0017p\u001d;UsB,GCCAX\u0003{\u000b9-a3\u0002PB)a,a)\u00022B!\u00111WA]\u001b\t\t)LC\u0002\u00028\u001a\u000bQ\u0001^=qKNLA!a/\u00026\nAA)\u0019;b)f\u0004X\rC\u0004\u0002@F\u0001\r!!1\u0002\u000fM\fH\u000eV=qKB\u0019a,a1\n\u0007\u0005\u0015wLA\u0002J]RDa!!3\u0012\u0001\u0004I\u0018\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\u00055\u0017\u00031\u0001\u0002B\u0006!1/\u001b>f\u0011\u001d\t\t.\u0005a\u0001\u0003'\f!!\u001c3\u0011\t\u0005M\u0016Q[\u0005\u0005\u0003/\f)LA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\t\u0005u\u0017Q\u001d\t\u0006=\u0006\r\u0016q\u001c\t\u0004#\u0006\u0005\u0018bAAr\t\nA!\n\u001a2d)f\u0004X\rC\u0004\u0002hJ\u0001\r!!-\u0002\u0005\u0011$\u0018\u0001D2p[BLG.\u001a,bYV,G\u0003BAw\u0003g\u00042AXAx\u0013\r\t\tp\u0018\u0002\u0004\u0003:L\bbBA{'\u0001\u0007\u0011Q^\u0001\u0006m\u0006dW/Z\u0001\u0019SN\u001c\u0015m]2bI&tw\r\u0016:v]\u000e\fG/\u001a+bE2,GCAA~!\u0011q\u00161\u0015;\u0002/%\u001c8+\u001f8uCb,%O]8s\u0005\u0016\u001cH/\u00124g_J$Hc\u0001;\u0003\u0002!9!1A\u000bA\u0002\u0005}\u0012!C3yG\u0016\u0004H/[8o\u0003A9W\r\u001e+sk:\u001c\u0017\r^3Rk\u0016\u0014\u0018\u0010F\u0003z\u0005\u0013\u0011i\u0001\u0003\u0004\u0003\fY\u0001\r!_\u0001\u0006i\u0006\u0014G.\u001a\u0005\n\u0005\u001f1\u0002\u0013!a\u0001\u0003w\fqaY1tG\u0006$W-\u0001\u000ehKR$&/\u001e8dCR,\u0017+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0016)\"\u00111 B\fW\t\u0011I\u0002\u0005\u0003\u0003\u001c\t\u0015RB\u0001B\u000f\u0015\u0011\u0011yB!\t\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0012?\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d\"Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E4fi\u0006#GmQ8mk6t\u0017+^3ssR9\u0011P!\f\u00032\tU\u0002B\u0002B\u00181\u0001\u0007\u00110A\u0005uC\ndWMT1nK\"1!1\u0007\rA\u0002e\f!bY8mk6tg*Y7f\u0011\u0019\u00119\u0004\u0007a\u0001s\u0006AA-\u0019;b)f\u0004X-\u0001\rhKR,\u0006\u000fZ1uK\u000e{G.^7o)f\u0004X-U;fef$r!\u001fB\u001f\u0005\u007f\u0011\t\u0005\u0003\u0004\u00030e\u0001\r!\u001f\u0005\u0007\u0005gI\u0002\u0019A=\t\r\t\r\u0013\u00041\u0001z\u0003-qWm\u001e#bi\u0006$\u0016\u0010]3\u0002?\u001d,G/\u00169eCR,7i\u001c7v[:tU\u000f\u001c7bE&d\u0017\u000e^=Rk\u0016\u0014\u0018\u0010F\u0004z\u0005\u0013\u0012YE!\u0014\t\r\t=\"\u00041\u0001z\u0011\u0019\u0011\u0019D\u0007a\u0001s\"1!q\n\u000eA\u0002Q\f!\"[:Ok2d\u0017M\u00197f\u000399W\r\u001e'j[&$8\t\\1vg\u0016$2!\u001fB+\u0011\u001d\u00119f\u0007a\u0001\u00053\nQ\u0001\\5nSR\u0004B!!\u0007\u0003\\%!!QLA\u000e\u0005\u001dIe\u000e^3hKJ\fqbZ3u\u001f\u001a47/\u001a;DY\u0006,8/\u001a\u000b\u0004s\n\r\u0004b\u0002B39\u0001\u0007!\u0011L\u0001\u0007_\u001a47/\u001a;\u0003+=\u0013\u0018m\u00197f'Fc\u0015+^3ss\n+\u0018\u000e\u001c3feN\u0019QDa\u001b\u0011\u0007E\u0013i'C\u0002\u0003p\u0011\u00131C\u00133cGN\u000bF*U;fef\u0014U/\u001b7eKJ\fq\u0001Z5bY\u0016\u001cG/A\u0004paRLwN\\:\u0011\t\t]$1Q\u0007\u0003\u0005sR1!\u0012B>\u0015\u0011\u0011iHa \u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0004\u0005\u00033\u0015!C3yK\u000e,H/[8o\u0013\u0011\u0011)I!\u001f\u0003\u0017)#%iQ(qi&|gn\u001d\u000b\u0007\u0005\u0013\u0013YI!$\u0011\u0007\u0005=S\u0004\u0003\u0004\u0003r\u0001\u0002\r\u0001\u0015\u0005\b\u0005g\u0002\u0003\u0019\u0001B;\u0003\u0015\u0011W/\u001b7e)\u0005I\u0018AF4fi*#'mY*R\u0019F+XM]=Ck&dG-\u001a:\u0015\t\t-$q\u0013\u0005\b\u0005g\u0012\u0003\u0019\u0001B;\u00035\u0019X\u000f\u001d9peR\u001cH*[7jiV\tA/\u0001\btkB\u0004xN\u001d;t\u001f\u001a47/\u001a;\u0002\u0019M,\b\u000f]8siND\u0015N\u001c;\u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0007\u0003&\ne&1\u0018B`\u0005\u0013\u0014iM\u0005\u0004\u0003(\n-&\u0011\u0017\u0004\u0007\u0005S\u0003\u0001A!*\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007\u0011\u0014i+C\u0002\u00030:\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0011\t\tM&QW\u0007\u0002\u0011&\u0019!q\u0017%\u0003\u001dM\u0003\u0018M]6UQJ|w/\u00192mK\"9\u0011Q\b\u0014A\u0002\t-\u0006B\u0002B_M\u0001\u0007\u00110A\u0005d_:$\u0017\u000e^5p]\"9!\u0011\u0019\u0014A\u0002\t\r\u0017!E7fgN\fw-\u001a)be\u0006lW\r^3sgB)!P!2zs&!!qYA\u0001\u0005\ri\u0015\r\u001d\u0005\u0007\u0005\u00174\u0003\u0019A=\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\u0007\u0005\u001f4\u0003\u0019\u0001;\u0002\u0013%\u001c(+\u001e8uS6,\u0017\u0001B2paf\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\f\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t-\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u00055(q\u001c\u0005\n\u0005CT\u0013\u0011!a\u0001\u0003\u0003\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001Bt!\u0019\u0011IOa;\u0002n6\u0011\u0011qB\u0005\u0005\u0005[\fyA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001;\u0003t\"I!\u0011\u001d\u0017\u0002\u0002\u0003\u0007\u0011Q^\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0018\te\b\"\u0003Bq[\u0005\u0005\t\u0019AAa\u0003!A\u0017m\u001d5D_\u0012,GCAAa\u0003!!xn\u0015;sS:<GCAA\f\u0003\u0019)\u0017/^1mgR\u0019Aoa\u0002\t\u0013\t\u0005\b'!AA\u0002\u00055\u0018!D(sC\u000edW\rR5bY\u0016\u001cG\u000f\u0005\u0002ReM)!ga\u0004\u0004\u0016A\u0019al!\u0005\n\u0007\rMqL\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0007/\u0019i\"\u0004\u0002\u0004\u001a)!11DA\u0010\u0003\tIw.C\u0002n\u00073!\"aa\u0003\u0002\u0019\tKe*\u0011*Z?\u001acu*\u0011+\u0016\u0005\r\u0015rBAB\u0014;\u0005!\u0017!\u0004\"J\u001d\u0006\u0013\u0016l\u0018$M\u001f\u0006#\u0006%A\u0007C\u0013:\u000b%+W0E\u001fV\u0013E*R\u000b\u0003\u0007_y!a!\r\u001e\u0003\u0015\faBQ%O\u0003JKv\fR(V\u00052+\u0005%\u0001\u0007U\u00136+5\u000bV!N!~#&,\u0006\u0002\u0004:=\u001111H\u000f\u00027\u0007iA+S'F'R\u000bU\nU0U5\u0002\nQ\u0002V%N\u000bN#\u0016)\u0014)`\u0019RSVCAB\"\u001f\t\u0019)%H\u0001\u001b\u00049!\u0016*T#T)\u0006k\u0005k\u0018'U5\u0002\n1\"\u0013(U\u000bJ3\u0016\tT0Z\u001bV\u00111QJ\b\u0003\u0007\u001fj\u0012!g\u0001\r\u0013:#VI\u0015,B\u0019~KV\nI\u0001\f\u0013:#VI\u0015,B\u0019~#5+\u0006\u0002\u0004X=\u00111\u0011L\u000f\u00021\u0007a\u0011J\u0014+F%Z\u000bEj\u0018#TA\u0005)\u0011\r\u001d9ms\u00069QO\\1qa2LHc\u0001;\u0004d!A1QM!\u0002\u0002\u0003\u0007\u0011/A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"aa\u001b\u0011\t\u0005e1QN\u0005\u0005\u0007_\nYB\u0001\u0004PE*,7\r\u001e")
public class OracleDialect
extends JdbcDialect
implements SQLConfHelper,
NoLegacyJDBCError,
Product {
    private final Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(OracleDialect x$0) {
        return OracleDialect$.MODULE$.unapply(x$0);
    }

    public static OracleDialect apply() {
        return OracleDialect$.MODULE$.apply();
    }

    public static int INTERVAL_DS() {
        return OracleDialect$.MODULE$.INTERVAL_DS();
    }

    public static int INTERVAL_YM() {
        return OracleDialect$.MODULE$.INTERVAL_YM();
    }

    public static int TIMESTAMP_LTZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_LTZ();
    }

    public static int TIMESTAMP_TZ() {
        return OracleDialect$.MODULE$.TIMESTAMP_TZ();
    }

    public static int BINARY_DOUBLE() {
        return OracleDialect$.MODULE$.BINARY_DOUBLE();
    }

    public static int BINARY_FLOAT() {
        return OracleDialect$.MODULE$.BINARY_FLOAT();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLConfHelper.withSQLConf$((SQLConfHelper)this, pairs, f);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:oracle");
    }

    public Set<String> org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions() {
        return this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions;
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return e.getMessage().contains("ORA-00942") || e.getMessage().contains("ORA-39165");
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        OracleSQLBuilder oracleSQLBuilder = new OracleSQLBuilder(this);
        try {
            some = new Some((Object)oracleSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                long scale = md != null ? md.build().getLong("scale") : 0L;
                int n2 = size;
                switch (n2) {
                    case 0: {
                        return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                    }
                }
                if (scale == -127L) {
                    return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                }
                return None$.MODULE$;
            }
            case -102: 
            case -101: {
                return new Some((Object)TimestampType$.MODULE$);
            }
            case 100: {
                return new Some((Object)FloatType$.MODULE$);
            }
            case 101: {
                return new Some((Object)DoubleType$.MODULE$);
            }
            case -103: {
                return new Some((Object)YearMonthIntervalType$.MODULE$.apply());
            }
            case -104: {
                return new Some((Object)DayTimeIntervalType$.MODULE$.apply());
            }
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(1)", 16));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(10)", 4));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19)", -5));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 8));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(3)", 5));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(5)", 5));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR2(255)", 12));
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int n = varcharType.length();
            return new Some((Object)new JdbcType("VARCHAR2(" + n + ")", 12));
        }
        if (TimestampType$.MODULE$.equals(dataType) && !this.conf().legacyOracleTimestampMappingEnabled()) {
            return new Some((Object)new JdbcType("TIMESTAMP WITH LOCAL TIME ZONE", -102));
        }
        return None$.MODULE$;
    }

    @Override
    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return "'" + this.escapeSql(string) + "'";
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return "{ts '" + timestamp + "'}";
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return "{d '" + date + "'}";
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericWrapArray(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)objectArray), (Function1 & Serializable)value -> this.compileValue(value), ClassTag$.MODULE$.Any())).mkString(", ");
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("HEXTORAW('", "", "')");
        }
        return value2;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        return "42000".equals(exception.getSQLState());
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return "TRUNCATE TABLE " + table + " CASCADE";
        }
        return "TRUNCATE TABLE " + table;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + newDataType;
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return "ALTER TABLE " + tableName + " MODIFY " + this.quoteIdentifier(columnName) + " " + nullable;
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "WHERE rownum <= " + limit;
        }
        return "";
    }

    @Override
    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return "WHERE rn > " + offset;
        }
        return "";
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new OracleSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public boolean supportsHint() {
        return true;
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 955: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    public OracleDialect copy() {
        return new OracleDialect();
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof OracleDialect && ((OracleDialect)x$1).canEqual(this);
    }

    public OracleDialect() {
        SQLConfHelper.$init$((SQLConfHelper)this);
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXY"}));
        this.supportedAggregateFunctions = (Set)((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG"}))).$plus$plus(this.org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions());
        this.supportedFunctions = this.supportedAggregateFunctions();
    }

    public class OracleSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        @Override
        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (isDistinct && this.org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer().org$apache$spark$sql$jdbc$OracleDialect$$distinctUnsupportedAggregateFunctions().contains((Object)funcName)) {
                throw new SparkUnsupportedOperationException("_LEGACY_ERROR_TEMP_3184", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.getClass().getSimpleName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)funcName)})));
            }
            return super.visitAggregateFunction(funcName, isDistinct, inputs);
        }

        public String visitBinaryComparison(String name, Expression le, Expression re) {
            Expression lit;
            Expression lit2;
            Tuple2 tuple2 = new Tuple2((Object)le, (Object)re);
            if (tuple2 != null && (lit2 = (Expression)tuple2._1()) instanceof Literal) {
                Literal literal = (Literal)lit2;
                DataType dataType = literal.dataType();
                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null)) {
                    return this.compareBlob((Expression)literal, name, re);
                }
            }
            if (tuple2 != null && (lit = (Expression)tuple2._2()) instanceof Literal) {
                Literal literal = (Literal)lit;
                DataType dataType = literal.dataType();
                BinaryType$ binaryType$ = BinaryType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null)) {
                    return this.compareBlob(le, name, (Expression)literal);
                }
            }
            return super.visitBinaryComparison(name, le, re);
        }

        private String compareBlob(Expression lhs, String operator, Expression rhs) {
            String l = this.inputToSQL(lhs);
            String r = this.inputToSQL(rhs);
            String string = operator;
            String string2 = "<=>";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String compare = "DBMS_LOB.COMPARE(" + l + ", " + r + ") = 0";
                return "((" + l + " IS NOT NULL AND " + r + " IS NOT NULL AND " + compare + ") OR (" + l + " IS NULL AND " + r + " IS NULL))";
            }
            return "DBMS_LOB.COMPARE(" + l + ", " + r + ") " + operator + " 0";
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLBuilder$$$outer() {
            return (OracleDialect)this.$outer;
        }

        public OracleSQLBuilder(OracleDialect $outer) {
        }
    }

    public class OracleSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ OracleDialect $outer;

        @Override
        public String build() {
            String string;
            String selectStmt = "SELECT " + this.hintClause() + this.columnList() + " FROM " + this.options.tableOrQuery() + " " + this.tableSampleClause() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause();
            if (this.limit() > 0) {
                if (this.offset() > 0) {
                    string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) WHERE rn > " + this.offset() + " AND rn <= " + (this.limit() + this.offset());
                } else {
                    String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
                    string = "SELECT tab.* FROM (" + selectStmt + ") tab " + limitClause;
                }
            } else if (this.offset() > 0) {
                String offsetClause = this.dialect.getOffsetClause(Predef$.MODULE$.int2Integer(this.offset()));
                string = "SELECT " + this.columnList() + " FROM (SELECT tab.*, rownum rn FROM (" + selectStmt + ") tab) " + offsetClause;
            } else {
                string = selectStmt;
            }
            String finalSelectStmt = string;
            return this.options.prepareQuery() + finalSelectStmt;
        }

        public /* synthetic */ OracleDialect org$apache$spark$sql$jdbc$OracleDialect$OracleSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public OracleSQLQueryBuilder(OracleDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

