/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.CurrentOrigin$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t5\u0002\u0011\t\u0012)A\u0005s!A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005a\u0001\tE\t\u0015!\u0003^\u0011!\t\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B2\t\u00115\u0004!Q3A\u0005\u00029D\u0001B\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\tu\u0002A)\u0019!C!3\")1\u000f\u0001C\u0001w\")1\u000f\u0001C\u0001}\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002X\u0001!\t&!\u0017\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA9\u0001E\u0005I\u0011AA:\u0011%\tI\tAI\u0001\n\u0003\tY\tC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\"I\u0011Q\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u00037\u0003\u0011\u0011!C!\u0003;C\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005]\u0006!!A\u0005\u0002\u0005e\u0006\"CAc\u0001\u0005\u0005I\u0011IAd\u0011%\t)\u000eAA\u0001\n\u0003\t9\u000eC\u0005\u0002\\\u0002\t\t\u0011\"\u0011\u0002^\"I\u0011\u0011\u001d\u0001\u0002\u0002\u0013\u0005\u00131]\u0004\n\u0005\u001bY\u0013\u0011!E\u0001\u0005\u001f1\u0001BK\u0016\u0002\u0002#\u0005!\u0011\u0003\u0005\u0007g\u0002\"\tA!\u000b\t\u0013\t-\u0002%!A\u0005F\t5\u0002\"\u0003B\u0018A\u0005\u0005I\u0011\u0011B\u0019\u0011%\u0011Y\u0004II\u0001\n\u0003\t\t\nC\u0005\u0003>\u0001\n\n\u0011\"\u0001\u0002\u0018\"I!q\b\u0011\u0002\u0002\u0013\u0005%\u0011\t\u0005\n\u0005\u001f\u0002\u0013\u0013!C\u0001\u0003#C\u0011B!\u0015!#\u0003%\t!a&\t\u0013\tM\u0003%!A\u0005\n\tU#a\u0003)beN,Gk\u001c#bi\u0016T!\u0001L\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003]=\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003aE\n1a]9m\u0015\t\u00114'A\u0003ta\u0006\u00148N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\b\u0001ej\u0004i\u0011$M!\tQ4(D\u0001,\u0013\ta4F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"A\u000f \n\u0005}Z#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"AO!\n\u0005\t[#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005i\"\u0015BA#,\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005JA\u0004Qe>$Wo\u0019;\u0011\u00055+fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tv'\u0001\u0004=e>|GOP\u0005\u0002\u0013&\u0011A\u000bS\u0001\ba\u0006\u001c7.Y4f\u0013\t1vK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002U\u0011\u0006!A.\u001a4u+\u0005I\u0014!\u00027fMR\u0004\u0013A\u00024pe6\fG/F\u0001^!\r9e,O\u0005\u0003?\"\u0013aa\u00149uS>t\u0017a\u00024pe6\fG\u000fI\u0001\u000bi&lWMW8oK&#W#A2\u0011\u0007\u001dsF\r\u0005\u0002fS:\u0011am\u001a\t\u0003\u001f\"K!\u0001\u001b%\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003Q\"\u000b1\u0002^5nKj{g.Z%eA\u0005Y\u0011M\\:j\u000b:\f'\r\\3e+\u0005y\u0007CA$q\u0013\t\t\bJA\u0004C_>dW-\u00198\u0002\u0019\u0005t7/[#oC\ndW\r\u001a\u0011\u0002\rqJg.\u001b;?)\u0015)ho\u001e=z!\tQ\u0004\u0001C\u0003Y\u0013\u0001\u0007\u0011\bC\u0003\\\u0013\u0001\u0007Q\fC\u0004b\u0013A\u0005\t\u0019A2\t\u000f5L\u0001\u0013!a\u0001_\u0006Y!/\u001a9mC\u000e,W.\u001a8u)\r)H0 \u0005\u00061.\u0001\r!\u000f\u0005\u00067.\u0001\r!\u000f\u000b\u0003k~DQ\u0001\u0017\u0007A\u0002e\n\u0001B\\8eK:\u000bW.Z\u000b\u0002I\u0006aq/\u001b;i)&lWMW8oKR\u00191)!\u0003\t\u000b\u0005t\u0001\u0019\u00013\u0002)9|G-\u001a)biR,'O\\:J]R,'O\\1m)\t\ty\u0001E\u0003N\u0003#\t)\"C\u0002\u0002\u0014]\u00131aU3r!\u0011\t9\"!\u000f\u000f\t\u0005e\u00111\u0007\b\u0005\u00037\tyC\u0004\u0003\u0002\u001e\u00055b\u0002BA\u0010\u0003WqA!!\t\u0002*9!\u00111EA\u0014\u001d\ry\u0015QE\u0005\u0002m%\u0011A'N\u0005\u0003eMJ!\u0001M\u0019\n\u00059z\u0013bAA\u0019[\u0005)AO]3fg&!\u0011QGA\u001c\u0003-!&/Z3QCR$XM\u001d8\u000b\u0007\u0005ER&\u0003\u0003\u0002<\u0005u\"a\u0003+sK\u0016\u0004\u0016\r\u001e;fe:TA!!\u000e\u00028\u0005A1\r[5mIJ,g.\u0006\u0002\u0002DA!Q*!\u0005:\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003\u0013\u0002R!TA\t\u0003\u0017\u0002B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#z\u0013!\u0002;za\u0016\u001c\u0018\u0002BA+\u0003\u001f\u0012\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA\u001d\u0002\\!9\u0011Q\f\nA\u0002\u0005}\u0013a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u0004B!TA1s%\u0019\u00111M,\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0003d_BLH#C;\u0002j\u0005-\u0014QNA8\u0011\u001dA6\u0003%AA\u0002eBqaW\n\u0011\u0002\u0003\u0007Q\fC\u0004b'A\u0005\t\u0019A2\t\u000f5\u001c\u0002\u0013!a\u0001_\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA;U\rI\u0014qO\u0016\u0003\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0011%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\b\u0006u$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAGU\ri\u0016qO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019JK\u0002d\u0003o\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u001a*\u001aq.a\u001e\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\n\u0005\u0003\u0002\"\u0006-VBAAR\u0015\u0011\t)+a*\u0002\t1\fgn\u001a\u0006\u0003\u0003S\u000bAA[1wC&\u0019!.a)\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005E\u0006cA$\u00024&\u0019\u0011Q\u0017%\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0016\u0011\u0019\t\u0004\u000f\u0006u\u0016bAA`\u0011\n\u0019\u0011I\\=\t\u0013\u0005\r'$!AA\u0002\u0005E\u0016a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JB1\u00111ZAi\u0003wk!!!4\u000b\u0007\u0005=\u0007*\u0001\u0006d_2dWm\u0019;j_:LA!a5\u0002N\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ry\u0017\u0011\u001c\u0005\n\u0003\u0007d\u0012\u0011!a\u0001\u0003w\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011qTAp\u0011%\t\u0019-HA\u0001\u0002\u0004\t\t,\u0001\u0004fcV\fGn\u001d\u000b\u0004_\u0006\u0015\b\"CAb=\u0005\u0005\t\u0019AA^Q]\u0001\u0011\u0011^Ax\u0003c\f)0a>\u0002|\u0006u(\u0011\u0001B\u0002\u0005\u000f\u0011I\u0001E\u0002;\u0003WL1!!<,\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a=\u0002\u0003sS\u0001\u0005\t\u0011!?\u001a+fjQ0)I\u0006$XmX:uenc\u0003EZ7u;&\u0002S\u0006\t)beN,7\u000f\t;iK\u0002\u0002G-\u0019;f?N$(\u000f\u0019\u0011fqB\u0014Xm]:j_:\u0004s/\u001b;iAQDW\r\t1g[R\u0004\u0007%\u001a=qe\u0016\u001c8/[8oAQ|'\u0002\t\u0011!A\u0001\u0002\u0013\r\t3bi\u0016t\u0003EU3ukJt7\u000f\t8vY2\u0004s/\u001b;iA%tg/\u00197jI\u0002Jg\u000e];u]\u0001\u0012\u0015\u0010\t3fM\u0006,H\u000e\u001e\u0017!SR\u0004cm\u001c7m_^\u001c\beY1ti&tw\r\t:vY\u0016\u001c\b\u0005^8!C\u0002\"\u0017\r^3!S\u001aT\u0001\u0005\t\u0011!A\u0001\"\b.\u001a\u0011aM6$\b\rI5tA=l\u0017\u000e\u001e;fI:R\u0001\u0005I\u0001\nCJ<W/\\3oiN\f#!!?\u0002\u0005?Q\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006\t3bi\u0016|6\u000f\u001e:![\u0001\n\u0005e\u001d;sS:<\u0007\u0005^8!E\u0016\u0004\u0003/\u0019:tK\u0012\u0004Co\u001c\u0011eCR,gF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011g[R\u0004S\u0006\t#bi\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt\u0007\u0005^8!M>dGn\\</AM+W\r\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC-\u0019;fi&lW-\f9biR,'O\u001c\u0018ii6d'E\u0010#bi\u0016$\u0018.\\3!!\u0006$H/\u001a:ogrz\u0013M\u0010\u0011g_J\u0004c/\u00197jI*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0017\r^3!C:$\u0007\u0005^5nK\u00022wN]7bi\u0002\u0002\u0018\r\u001e;fe:\u001chF\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u0000\u0003\u00055\"\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aAJT\u0006M\u001c.gA\u0002\u0003\u0007\u000e\u001e2oi*$gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0004'O\u00171o5\u001a\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(eA\nd'L\u00193[M\nt\u0005\f\u0011(sfL\u00180L'N[\u0011$w%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nd'L\u00193[M\n$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t\u0015\u0011A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0017\tQ!\r\u00186]A\n1\u0002U1sg\u0016$v\u000eR1uKB\u0011!\bI\n\u0006A\tM!q\u0004\t\n\u0005+\u0011Y\"O/d_Vl!Aa\u0006\u000b\u0007\te\u0001*A\u0004sk:$\u0018.\\3\n\t\tu!q\u0003\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004\u0003\u0002B\u0011\u0005Oi!Aa\t\u000b\t\t\u0015\u0012qU\u0001\u0003S>L1A\u0016B\u0012)\t\u0011y!\u0001\u0005u_N#(/\u001b8h)\t\ty*A\u0003baBd\u0017\u0010F\u0005v\u0005g\u0011)Da\u000e\u0003:!)\u0001l\ta\u0001s!)1l\ta\u0001;\"9\u0011m\tI\u0001\u0002\u0004\u0019\u0007bB7$!\u0003\u0005\ra\\\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\r#1\n\t\u0005\u000fz\u0013)\u0005E\u0004H\u0005\u000fJTlY8\n\u0007\t%\u0003J\u0001\u0004UkBdW\r\u000e\u0005\t\u0005\u001b2\u0013\u0011!a\u0001k\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\u000b\t\u0005\u0003C\u0013I&\u0003\u0003\u0003\\\u0005\r&AB(cU\u0016\u001cG\u000f")
public class ParseToDate
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final Option<String> timeZoneId;
    private final boolean ansiEnabled;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Option<Expression>, Option<String>, Object>> unapply(ParseToDate x$0) {
        return ParseToDate$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return ParseToDate$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return ParseToDate$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, Option<String>, Object>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, ParseToDate>>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean ansiEnabled() {
        return this.ansiEnabled;
    }

    private Expression replacement$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)CurrentOrigin$.MODULE$.withOrigin(this.origin(), (Function0 & Serializable)() -> (Cast)this.format().map((Function1 & Serializable)f -> new Cast(new GetTimestamp(this.left(), (Expression)f, (DataType)TimestampType$.MODULE$, "try_to_date", this.timeZoneId(), this.ansiEnabled()), (DataType)DateType$.MODULE$, this.timeZoneId(), EvalMode$.MODULE$.fromBoolean(this.ansiEnabled()))).getOrElse((Function0 & Serializable)() -> new Cast(this.left(), (DataType)DateType$.MODULE$, this.timeZoneId(), EvalMode$.MODULE$.fromBoolean(this.ansiEnabled()))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String nodeName() {
        return "to_date";
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)Nil$.MODULE$);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable)x$8 -> StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()))).toSeq().$plus$colon((Object)typeCollection);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3(), this.copy$default$4());
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Option<String> timeZoneId, boolean ansiEnabled) {
        return new ParseToDate(left, format, timeZoneId, ansiEnabled);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.ansiEnabled();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.timeZoneId();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ansiEnabled());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "format";
            }
            case 2: {
                return "timeZoneId";
            }
            case 3: {
                return "ansiEnabled";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        if (this.ansiEnabled() != parseToDate.ansiEnabled()) return false;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToDate.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Option<String> timeZoneId, boolean ansiEnabled) {
        this.left = left;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.ansiEnabled = ansiEnabled;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), ParseToDate$.MODULE$.$lessinit$greater$default$3(), ParseToDate$.MODULE$.$lessinit$greater$default$4());
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, ParseToDate$.MODULE$.$lessinit$greater$default$3(), ParseToDate$.MODULE$.$lessinit$greater$default$4());
    }
}

