/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005-a!B\b\u0011\u0003\u0003i\u0002\"\u0002\u0015\u0001\t\u0003I\u0003bB\u0016\u0001\u0005\u0004%\t\u0001\f\u0005\u0007u\u0001\u0001\u000b\u0011B\u0017\t\u000bm\u0002a\u0011\u0001\u001f\t\u000b\u0005\u0003a\u0011\u0003\"\t\u000b\u0019\u0003A\u0011K$\t\u000b-\u0003A\u0011\u000b\u001f\t\u000b1\u0003A\u0011\t\u001f\t\u000b5\u0003A\u0011\t(\t\u000by\u0003A\u0011I0\t\u000b\r\u0004A\u0011\t\u001f\t\u000b\u0011\u0004A\u0011B3\t\u000b-\u0004A\u0011\t7\t\u000bY\u0004A\u0011I<\u0003\u0017Q{G+[7fgR\fW\u000e\u001d\u0006\u0003#I\t1\"\u001a=qe\u0016\u001c8/[8og*\u00111\u0003F\u0001\tG\u0006$\u0018\r\\=ti*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M!\u0001A\b\u0012&!\ty\u0002%D\u0001\u0011\u0013\t\t\u0003C\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011qdI\u0005\u0003IA\u0011\u0001\u0004V5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;fe\"+G\u000e]3s!\tyb%\u0003\u0002(!\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0010\u0001\u0003M\u0019XoZ4fgR,GMR;oG>sg)Y5m+\u0005i\u0003C\u0001\u00188\u001d\tyS\u0007\u0005\u00021g5\t\u0011G\u0003\u000239\u00051AH]8pizR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\na\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011agM\u0001\u0015gV<w-Z:uK\u00124UO\\2P]\u001a\u000b\u0017\u000e\u001c\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002{A\u0011ahP\u0007\u0002g%\u0011\u0001i\r\u0002\b\u0005>|G.Z1o\u0003=!wn\u001e8TG\u0006dWMR1di>\u0014X#A\"\u0011\u0005y\"\u0015BA#4\u0005\u0011auN\\4\u0002\u0019\u0019|'/\\1u'R\u0014\u0018N\\4\u0016\u0003!\u0003\"aH%\n\u0005)\u0003\"AC#yaJ,7o]5p]\u0006I\u0011n\u001d)beNLgnZ\u0001\u0010M>\u0014H+[7fgR\fW\u000e\u001d(U5\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003=\u00032\u0001U+Y\u001d\t\t6K\u0004\u00021%&\tA'\u0003\u0002Ug\u00059\u0001/Y2lC\u001e,\u0017B\u0001,X\u0005\r\u0019V-\u001d\u0006\u0003)N\u0002\"!\u0017/\u000e\u0003iS!a\u0017\u000b\u0002\u000bQL\b/Z:\n\u0005uS&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#\u00011\u0011\u0005e\u000b\u0017B\u00012[\u0005!!\u0015\r^1UsB,\u0017\u0001\u00038vY2\f'\r\\3\u0002\u0019%\u001c\b+\u0019:tK\u0016\u0013(o\u001c:\u0015\u0005u2\u0007\"B4\r\u0001\u0004A\u0017!A3\u0011\u0005AK\u0017B\u00016X\u0005%!\u0006N]8xC\ndW-\u0001\u0003fm\u0006dGCA7q!\tqd.\u0003\u0002pg\t\u0019\u0011I\\=\t\u000fEl\u0001\u0013!a\u0001e\u0006)\u0011N\u001c9viB\u00111\u000f^\u0007\u0002%%\u0011QO\u0005\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR!\u0001P`A\u0004!\tIH0D\u0001{\u0015\tY\b#A\u0004d_\u0012,w-\u001a8\n\u0005uT(\u0001C#yaJ\u001cu\u000eZ3\t\r}t\u0001\u0019AA\u0001\u0003\r\u0019G\u000f\u001f\t\u0004s\u0006\r\u0011bAA\u0003u\nq1i\u001c3fO\u0016t7i\u001c8uKb$\bBBA\u0005\u001d\u0001\u0007\u00010\u0001\u0002fm\u0002")
public abstract class ToTimestamp
extends BinaryExpression
implements TimestampFormatterHelper,
ExpectsInputTypes {
    private final String suggestedFuncOnFail;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.formatterOption$lzycompute();
        }
        return this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ToTimestamp toTimestamp = this;
        synchronized (toTimestamp) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String suggestedFuncOnFail() {
        return this.suggestedFuncOnFail;
    }

    public abstract boolean failOnError();

    public abstract long downScaleFactor();

    @Override
    public Expression formatString() {
        return (Expression)this.right();
    }

    @Override
    public boolean isParsing() {
        return true;
    }

    @Override
    public boolean forTimestampNTZ() {
        DataType dataType = ((Expression)this.left()).dataType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        return !(dataType != null ? !dataType.equals(timestampNTZType$) : timestampNTZType$ != null);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$})), (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        if (this.failOnError()) {
            return this.children().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.nullable()));
        }
        return true;
    }

    private boolean isParseError(Throwable e) {
        Throwable throwable = e;
        return throwable instanceof DateTimeParseException ? true : (throwable instanceof DateTimeException ? true : throwable instanceof ParseException);
    }

    @Override
    public Object eval(InternalRow input) {
        Object t = ((Expression)this.left()).eval(input);
        if (t == null) {
            return null;
        }
        DataType dataType = ((Expression)this.left()).dataType();
        if (DateType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToLong((long)(DateTimeUtils$.MODULE$.daysToMicros(BoxesRunTime.unboxToInt((Object)t), this.zoneId()) / this.downScaleFactor()));
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)t) / this.downScaleFactor()));
        }
        if (dataType instanceof StringType) {
            Long l;
            Object fmt = ((Expression)this.right()).eval(input);
            if (fmt == null) {
                return null;
            }
            TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable)() -> this.getFormatter(fmt.toString()));
            try {
                l = this.forTimestampNTZ() ? BoxesRunTime.boxToLong((long)formatter.parseWithoutTimeZone(((UTF8String)t).toString())) : BoxesRunTime.boxToLong((long)(formatter.parse(((UTF8String)t).toString()) / this.downScaleFactor()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof DateTimeException) {
                    DateTimeException dateTimeException = (DateTimeException)throwable2;
                    if (this.failOnError()) {
                        throw QueryExecutionErrors$.MODULE$.ansiDateTimeParseError(dateTimeException, this.suggestedFuncOnFail());
                    }
                }
                if (throwable2 instanceof ParseException) {
                    ParseException parseException = (ParseException)throwable2;
                    if (this.failOnError()) {
                        throw QueryExecutionErrors$.MODULE$.ansiDateTimeParseError(parseException, this.suggestedFuncOnFail());
                    }
                }
                if (this.isParseError(throwable2)) {
                    l = null;
                }
                throw throwable;
            }
            return l;
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String javaType = CodeGenerator$.MODULE$.javaType(this.dataType());
        String parseErrorBranch = this.failOnError() ? "throw QueryExecutionErrors.ansiDateTimeParseError(e, \"" + this.suggestedFuncOnFail() + "\");" : ev.isNull() + " = true;";
        String parseMethod = this.forTimestampNTZ() ? "parseWithoutTimeZone" : "parse";
        String downScaleCode = this.forTimestampNTZ() ? "" : "/ " + this.downScaleFactor();
        DataType dataType = ((Expression)this.left()).dataType();
        if (dataType instanceof StringType) {
            return (ExprCode)this.formatterOption().map((Function1 & Serializable)fmt -> {
                String df = TimestampFormatter.class.getName();
                String formatterName = ctx.addReferenceObj("formatter", fmt, df);
                return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(datetimeStr, x$5) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |try {\n             |  " + ev.value() + " = " + formatterName + "." + parseMethod + "(" + datetimeStr + ".toString()) " + downScaleCode + ";\n             |} catch (java.time.DateTimeException e) {\n             |  " + parseErrorBranch + "\n             |} catch (java.text.ParseException e) {\n             |  " + parseErrorBranch + "\n             |}\n             |")));
            }).getOrElse((Function0 & Serializable)() -> {
                String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
                String tf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName()), "$");
                String ldf = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName()), "$");
                String timestampFormatter = ctx.freshName("timestampFormatter");
                return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(string, format) -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |" + tf + " " + timestampFormatter + " = " + tf + "$.MODULE$.apply(\n             |  " + format + ".toString(),\n             |  " + zid + ",\n             |  " + ldf + "$.MODULE$.SIMPLE_DATE_FORMAT(),\n             |  true);\n             |try {\n             |  " + ev.value() + " = " + timestampFormatter + "." + parseMethod + "(" + string + ".toString()) " + downScaleCode + ";\n             |} catch (java.time.DateTimeException e) {\n             |    " + parseErrorBranch + "\n             |} catch (java.text.ParseException e) {\n             |    " + parseErrorBranch + "\n             |}\n             |")));
            });
        }
        if (TimestampType$.MODULE$.equals(dataType) ? true : TimestampNTZType$.MODULE$.equals(dataType)) {
            ExprCode eval1 = ((Expression)this.left()).genCode(ctx);
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", " / ", ";\n          }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval1.code(), ev.isNull(), eval1.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), eval1.value(), BoxesRunTime.boxToLong((long)this.downScaleFactor())})), ev.copy$default$2(), ev.copy$default$3());
        }
        if (DateType$.MODULE$.equals(dataType)) {
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
            ExprCode eval1 = ((Expression)this.left()).genCode(ctx);
            return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".daysToMicros(", ", ", ") / ", ";\n          }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{eval1.code(), ev.isNull(), eval1.isNull(), javaType, ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), dtu, eval1.value(), zid, BoxesRunTime.boxToLong((long)this.downScaleFactor())})), ev.copy$default$2(), ev.copy$default$3());
        }
        throw new MatchError((Object)dataType);
    }

    public ToTimestamp() {
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.suggestedFuncOnFail = "try_to_timestamp";
        Statics.releaseFence();
    }
}

