/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.datasketches.common.ArrayOfBooleansSerDe;
import org.apache.datasketches.common.ArrayOfDoublesSerDe;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfLongsSerDe;
import org.apache.datasketches.common.ArrayOfNumbersSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.frequencies.ErrorType;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.ArrayOfDecimalsSerDe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK;
import org.apache.spark.sql.catalyst.util.CollationFactory;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple5;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class ApproxTopK$
implements Serializable {
    public static final ApproxTopK$ MODULE$ = new ApproxTopK$();
    private static final int DEFAULT_K = 5;
    private static final int DEFAULT_MAX_ITEMS_TRACKED = 10000;
    private static final int MAX_ITEMS_TRACKED_LIMIT = 1000000;

    public int $lessinit$greater$default$4() {
        return 0;
    }

    public int $lessinit$greater$default$5() {
        return 0;
    }

    public int DEFAULT_K() {
        return DEFAULT_K;
    }

    public int DEFAULT_MAX_ITEMS_TRACKED() {
        return DEFAULT_MAX_ITEMS_TRACKED;
    }

    private int MAX_ITEMS_TRACKED_LIMIT() {
        return MAX_ITEMS_TRACKED_LIMIT;
    }

    public void checkExpressionNotNull(Expression expr, String exprName) {
        if (expr == null || expr.eval(expr.eval$default$1()) == null) {
            throw QueryExecutionErrors$.MODULE$.approxTopKNullArg(exprName);
        }
    }

    public void checkK(int k) {
        if (k <= 0) {
            throw QueryExecutionErrors$.MODULE$.approxTopKNonPositiveValue("k", k);
        }
    }

    public void checkMaxItemsTracked(int maxItemsTracked) {
        if (maxItemsTracked > this.MAX_ITEMS_TRACKED_LIMIT()) {
            throw QueryExecutionErrors$.MODULE$.approxTopKMaxItemsTrackedExceedsLimit(maxItemsTracked, this.MAX_ITEMS_TRACKED_LIMIT());
        }
        if (maxItemsTracked <= 0) {
            throw QueryExecutionErrors$.MODULE$.approxTopKNonPositiveValue("maxItemsTracked", maxItemsTracked);
        }
    }

    public void checkMaxItemsTracked(int maxItemsTracked, int k) {
        this.checkMaxItemsTracked(maxItemsTracked);
        if (maxItemsTracked < k) {
            throw QueryExecutionErrors$.MODULE$.approxTopKMaxItemsTrackedLessThanK(maxItemsTracked, k);
        }
    }

    public DataType getResultDataType(DataType itemDataType) {
        StructField structField = new StructField("item", itemDataType, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("count", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructType resultEntryType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
        return new ArrayType((DataType)resultEntryType, false);
    }

    public boolean isDataTypeSupported(DataType itemType) {
        DataType dataType = itemType;
        return dataType instanceof BooleanType ? true : (dataType instanceof ByteType ? true : (dataType instanceof ShortType ? true : (dataType instanceof IntegerType ? true : (dataType instanceof LongType ? true : (dataType instanceof FloatType ? true : (dataType instanceof DoubleType ? true : (dataType instanceof DateType ? true : (dataType instanceof TimestampType ? true : (dataType instanceof TimestampNTZType ? true : (dataType instanceof StringType ? true : dataType instanceof DecimalType))))))))));
    }

    public int calMaxMapSize(int maxItemsTracked) {
        int ceilMaxMapSize = (int)package$.MODULE$.ceil((double)maxItemsTracked / 0.75);
        return (int)package$.MODULE$.pow(2.0, package$.MODULE$.ceil(package$.MODULE$.log((double)ceilMaxMapSize) / package$.MODULE$.log(2.0)));
    }

    public ItemsSketch<Object> createAggregationBuffer(Expression itemExpression, int maxMapSize) {
        DataType dataType = itemExpression.dataType();
        if (dataType instanceof BooleanType) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof ByteType ? true : (dataType instanceof ShortType ? true : (dataType instanceof IntegerType ? true : (dataType instanceof FloatType ? true : dataType instanceof DateType)))) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof LongType ? true : (dataType instanceof TimestampType ? true : dataType instanceof TimestampNTZType)) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof DoubleType) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof StringType) {
            return new ItemsSketch(maxMapSize);
        }
        if (dataType instanceof DecimalType) {
            return new ItemsSketch(maxMapSize);
        }
        throw new MatchError((Object)dataType);
    }

    public ItemsSketch<Object> updateSketchBuffer(Expression itemExpression, ItemsSketch<Object> buffer, InternalRow input) {
        Object v = itemExpression.eval(input);
        if (v != null) {
            DataType dataType = itemExpression.dataType();
            if (dataType instanceof BooleanType) {
                buffer.update((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)v)));
            } else if (dataType instanceof ByteType) {
                buffer.update((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)v)));
            } else if (dataType instanceof ShortType) {
                buffer.update((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)v)));
            } else if (dataType instanceof IntegerType) {
                buffer.update((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)v)));
            } else if (dataType instanceof LongType) {
                buffer.update((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)v)));
            } else if (dataType instanceof FloatType) {
                buffer.update((Object)BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat((Object)v)));
            } else if (dataType instanceof DoubleType) {
                buffer.update((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)v)));
            } else if (dataType instanceof DateType) {
                buffer.update((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)v)));
            } else if (dataType instanceof TimestampType) {
                buffer.update((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)v)));
            } else if (dataType instanceof TimestampNTZType) {
                buffer.update((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)v)));
            } else if (dataType instanceof StringType) {
                StringType stringType = (StringType)dataType;
                UTF8String cKey = CollationFactory.getCollationKey((UTF8String)((UTF8String)v), (int)stringType.collationId());
                buffer.update((Object)cKey.toString());
            } else if (dataType instanceof DecimalType) {
                buffer.update((Object)((Decimal)v));
            } else {
                throw new MatchError((Object)dataType);
            }
        }
        return buffer;
    }

    public GenericArrayData genEvalResult(ItemsSketch<Object> itemsSketch, int k, DataType itemDataType) {
        ItemsSketch.Row[] items = itemsSketch.getFrequentItems(ErrorType.NO_FALSE_POSITIVES);
        int resultLength = package$.MODULE$.min(items.length, k);
        Object[] result = new Object[resultLength];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), resultLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            ItemsSketch.Row row = items[i];
            DataType dataType = itemDataType;
            if (dataType instanceof BooleanType ? true : (dataType instanceof ByteType ? true : (dataType instanceof ShortType ? true : (dataType instanceof IntegerType ? true : (dataType instanceof LongType ? true : (dataType instanceof FloatType ? true : (dataType instanceof DoubleType ? true : (dataType instanceof DecimalType ? true : (dataType instanceof DateType ? true : (dataType instanceof TimestampType ? true : dataType instanceof TimestampNTZType)))))))))) {
                result$1[i] = InternalRow$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{row.getItem(), BoxesRunTime.boxToLong((long)row.getEstimate())}));
                return;
            }
            if (dataType instanceof StringType) {
                UTF8String item = UTF8String.fromString((String)((String)row.getItem()));
                result$1[i] = InternalRow$.MODULE$.apply((Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{item, BoxesRunTime.boxToLong((long)row.getEstimate())}));
                return;
            }
            throw new MatchError((Object)dataType);
        });
        return new GenericArrayData((Object)result);
    }

    public ArrayOfItemsSerDe<Object> genSketchSerDe(DataType dataType) {
        DataType dataType2 = dataType;
        if (dataType2 instanceof BooleanType) {
            return new ArrayOfBooleansSerDe();
        }
        if (dataType2 instanceof ByteType ? true : (dataType2 instanceof ShortType ? true : (dataType2 instanceof IntegerType ? true : (dataType2 instanceof FloatType ? true : dataType2 instanceof DateType)))) {
            return new ArrayOfNumbersSerDe();
        }
        if (dataType2 instanceof LongType ? true : (dataType2 instanceof TimestampType ? true : dataType2 instanceof TimestampNTZType)) {
            return new ArrayOfLongsSerDe();
        }
        if (dataType2 instanceof DoubleType) {
            return new ArrayOfDoublesSerDe();
        }
        if (dataType2 instanceof StringType) {
            return new ArrayOfStringsSerDe();
        }
        if (dataType2 instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType2;
            return new ArrayOfDecimalsSerDe(decimalType);
        }
        throw new MatchError((Object)dataType2);
    }

    public StructType getSketchStateDataType(DataType itemDataType) {
        StructField structField = new StructField("sketch", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("itemDataType", itemDataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("maxItemsTracked", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        return StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
    }

    public ApproxTopK apply(Expression expr, Expression k, Expression maxItemsTracked, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproxTopK(expr, k, maxItemsTracked, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public int apply$default$4() {
        return 0;
    }

    public int apply$default$5() {
        return 0;
    }

    public Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproxTopK x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple5((Object)x$0.expr(), (Object)x$0.k(), (Object)x$0.maxItemsTracked(), (Object)BoxesRunTime.boxToInteger((int)x$0.mutableAggBufferOffset()), (Object)BoxesRunTime.boxToInteger((int)x$0.inputAggBufferOffset())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ApproxTopK$.class);
    }

    private ApproxTopK$() {
    }
}

