/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical.statsEstimation;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Equality$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ColumnStatsMap;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.EstimationUtils$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.FilterEstimation$;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.NumericValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval;
import org.apache.spark.sql.catalyst.plans.logical.statsEstimation.ValueInterval$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SetOps;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Ordered;
import scala.math.Ordering;
import scala.math.ScalaNumericAnyConversions;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u0005d\u0001\u0002\u0015*\u0001jB\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t9\u0002\u0011\t\u0012)A\u00051\")Q\f\u0001C\u0001=\"9!\r\u0001b\u0001\n\u0013\u0019\u0007BB4\u0001A\u0003%A\rC\u0004i\u0001\t\u0007I\u0011B5\t\r5\u0004\u0001\u0015!\u0003k\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015\u0019\b\u0001\"\u0001u\u0011%\ti\u0001AI\u0001\n\u0003\ty\u0001C\u0004\u0002&\u0001!\t!a\n\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\n\u0003\u001b\u0004\u0011\u0011!C\u0001\u0003\u001fD\u0011\"a5\u0001#\u0003%\t!!6\t\u0013\u0005e\u0007!!A\u0005B\u0005m\u0007\"CAw\u0001\u0005\u0005I\u0011AAx\u0011%\t9\u0010AA\u0001\n\u0003\tI\u0010C\u0005\u0002\u0000\u0002\t\t\u0011\"\u0011\u0003\u0002!I!q\u0002\u0001\u0002\u0002\u0013\u0005!\u0011\u0003\u0005\n\u0005+\u0001\u0011\u0011!C!\u0005/A\u0011Ba\u0007\u0001\u0003\u0003%\tE!\b\t\u0013\t}\u0001!!A\u0005B\t\u0005\u0002\"\u0003B\u0012\u0001\u0005\u0005I\u0011\tB\u0013\u000f%\u0011I#KA\u0001\u0012\u0003\u0011YC\u0002\u0005)S\u0005\u0005\t\u0012\u0001B\u0017\u0011\u0019i&\u0005\"\u0001\u0003F!I!q\u0004\u0012\u0002\u0002\u0013\u0015#\u0011\u0005\u0005\n\u0005\u000f\u0012\u0013\u0011!CA\u0005\u0013B\u0011B!\u0014#\u0003\u0003%\tIa\u0014\t\u0013\t]#%!A\u0005\n\te#\u0001\u0005$jYR,'/R:uS6\fG/[8o\u0015\tQ3&A\bti\u0006$8/R:uS6\fG/[8o\u0015\taS&A\u0004m_\u001eL7-\u00197\u000b\u00059z\u0013!\u00029mC:\u001c(B\u0001\u00192\u0003!\u0019\u0017\r^1msN$(B\u0001\u001a4\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003iU\nQa\u001d9be.T!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sO\u000e\u00011#\u0002\u0001<\u0003\u001eS\u0005C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$AB!osJ+g\r\u0005\u0002C\u000b6\t1I\u0003\u0002Eg\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002G\u0007\n9Aj\\4hS:<\u0007C\u0001\u001fI\u0013\tIUHA\u0004Qe>$Wo\u0019;\u0011\u0005-\u001bfB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\ty\u0015(\u0001\u0004=e>|GOP\u0005\u0002}%\u0011!+P\u0001\ba\u0006\u001c7.Y4f\u0013\t!VK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002S{\u0005!\u0001\u000f\\1o+\u0005A\u0006CA-[\u001b\u0005Y\u0013BA.,\u0005\u00191\u0015\u000e\u001c;fe\u0006)\u0001\u000f\\1oA\u00051A(\u001b8jiz\"\"aX1\u0011\u0005\u0001\u0004Q\"A\u0015\t\u000bY\u001b\u0001\u0019\u0001-\u0002\u0015\rD\u0017\u000e\u001c3Ti\u0006$8/F\u0001e!\tIV-\u0003\u0002gW\tQ1\u000b^1uSN$\u0018nY:\u0002\u0017\rD\u0017\u000e\u001c3Ti\u0006$8\u000fI\u0001\fG>d7\u000b^1ug6\u000b\u0007/F\u0001k!\t\u00017.\u0003\u0002mS\tq1i\u001c7v[:\u001cF/\u0019;t\u001b\u0006\u0004\u0018\u0001D2pYN#\u0018\r^:NCB\u0004\u0013\u0001C3ti&l\u0017\r^3\u0016\u0003A\u00042\u0001P9e\u0013\t\u0011XH\u0001\u0004PaRLwN\\\u0001\u001bG\u0006d7-\u001e7bi\u00164\u0015\u000e\u001c;feN+G.Z2uSZLG/\u001f\u000b\u0005kf\f\u0019\u0001E\u0002=cZ\u0004\"\u0001P<\n\u0005al$A\u0002#pk\ndW\rC\u0003{\u0013\u0001\u000710A\u0005d_:$\u0017\u000e^5p]B\u0011Ap`\u0007\u0002{*\u0011apL\u0001\fKb\u0004(/Z:tS>t7/C\u0002\u0002\u0002u\u0014!\"\u0012=qe\u0016\u001c8/[8o\u0011%\t)!\u0003I\u0001\u0002\u0004\t9!\u0001\u0004va\u0012\fG/\u001a\t\u0004y\u0005%\u0011bAA\u0006{\t9!i\\8mK\u0006t\u0017\u0001J2bY\u000e,H.\u0019;f\r&dG/\u001a:TK2,7\r^5wSRLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005E!\u0006BA\u0004\u0003'Y#!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?i\u0014AC1o]>$\u0018\r^5p]&!\u00111EA\r\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0019G\u0006d7-\u001e7bi\u0016\u001c\u0016N\\4mK\u000e{g\u000eZ5uS>tG#B;\u0002*\u0005-\u0002\"\u0002>\f\u0001\u0004Y\bbBA\u0003\u0017\u0001\u0007\u0011qA\u0001\u0012KZ\fG.^1uK:+H\u000e\\\"iK\u000e\\GcB;\u00022\u0005m\u0012q\b\u0005\b\u0003ga\u0001\u0019AA\u001b\u0003\u0011\tG\u000f\u001e:\u0011\u0007q\f9$C\u0002\u0002:u\u0014\u0011\"\u0011;ue&\u0014W\u000f^3\t\u000f\u0005uB\u00021\u0001\u0002\b\u00051\u0011n\u001d(vY2Dq!!\u0002\r\u0001\u0004\t9!\u0001\bfm\u0006dW/\u0019;f\u0005&t\u0017M]=\u0015\u0013U\f)%a\u0014\u0002R\u0005m\u0003bBA$\u001b\u0001\u0007\u0011\u0011J\u0001\u0003_B\u00042\u0001`A&\u0013\r\ti% \u0002\u0011\u0005&t\u0017M]=D_6\u0004\u0018M]5t_:Dq!a\r\u000e\u0001\u0004\t)\u0004C\u0004\u0002T5\u0001\r!!\u0016\u0002\u000f1LG/\u001a:bYB\u0019A0a\u0016\n\u0007\u0005eSPA\u0004MSR,'/\u00197\t\u000f\u0005\u0015Q\u00021\u0001\u0002\b\u0005\u0001RM^1mk\u0006$X-R9vC2LG/\u001f\u000b\bk\u0006\u0005\u00141MA3\u0011\u001d\t\u0019D\u0004a\u0001\u0003kAq!a\u0015\u000f\u0001\u0004\t)\u0006C\u0004\u0002\u00069\u0001\r!a\u0002\u0002\u001f\u00154\u0018\r\\;bi\u0016d\u0015\u000e^3sC2$2!^A6\u0011\u001d\t\u0019f\u0004a\u0001\u0003+\nQ\"\u001a<bYV\fG/Z%o'\u0016$HcB;\u0002r\u0005M\u0014Q\u0012\u0005\b\u0003g\u0001\u0002\u0019AA\u001b\u0011\u001d\t)\b\u0005a\u0001\u0003o\nA\u0001[*fiB1\u0011\u0011PAA\u0003\u000fsA!a\u001f\u0002~A\u0011Q*P\u0005\u0004\u0003\u007fj\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0004\u0006\u0015%aA*fi*\u0019\u0011qP\u001f\u0011\u0007q\nI)C\u0002\u0002\fv\u00121!\u00118z\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000f\t\u0001$\u001a<bYV\fG/\u001a\"j]\u0006\u0014\u0018PR8s\u001dVlWM]5d)%)\u00181SAK\u0003/\u000bI\nC\u0004\u0002HE\u0001\r!!\u0013\t\u000f\u0005M\u0012\u00031\u0001\u00026!9\u00111K\tA\u0002\u0005U\u0003bBA\u0003#\u0001\u0007\u0011qA\u0001&G>l\u0007/\u001e;f\u000bF,\u0018\r\\5usB{7o]5cS2LG/\u001f\"z\u0011&\u001cHo\\4sC6$RA^AP\u0003CCq!a\u0015\u0013\u0001\u0004\t)\u0006C\u0004\u0002$J\u0001\r!!*\u0002\u000f\r|Gn\u0015;biB\u0019\u0011,a*\n\u0007\u0005%6F\u0001\u0006D_2,XN\\*uCR\fqeY8naV$XmQ8na\u0006\u0014\u0018n]8o!>\u001c8/\u001b2jY&$\u0018PQ=ISN$xn\u001a:b[R9a/a,\u00022\u0006M\u0006bBA$'\u0001\u0007\u0011\u0011\n\u0005\b\u0003'\u001a\u0002\u0019AA+\u0011\u001d\t\u0019k\u0005a\u0001\u0003K\u000b1$\u001a<bYV\fG/\u001a\"j]\u0006\u0014\u0018PR8s)^|7i\u001c7v[:\u001cH#C;\u0002:\u0006m\u0016qXAb\u0011\u001d\t9\u0005\u0006a\u0001\u0003\u0013Bq!!0\u0015\u0001\u0004\t)$\u0001\u0005biR\u0014H*\u001a4u\u0011\u001d\t\t\r\u0006a\u0001\u0003k\t\u0011\"\u0019;ueJKw\r\u001b;\t\u000f\u0005\u0015A\u00031\u0001\u0002\b\u0005\u0001\"m\\;oIB\u0013xNY1cS2LG/\u001f\u000b\u0004m\u0006%\u0007BBAf+\u0001\u0007a/A\u0001q\u0003\u0011\u0019w\u000e]=\u0015\u0007}\u000b\t\u000eC\u0004W-A\u0005\t\u0019\u0001-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001b\u0016\u00041\u0006M\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002^B!\u0011q\\Au\u001b\t\t\tO\u0003\u0003\u0002d\u0006\u0015\u0018\u0001\u00027b]\u001eT!!a:\u0002\t)\fg/Y\u0005\u0005\u0003W\f\tO\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00042\u0001PAz\u0013\r\t)0\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u000f\u000bY\u0010C\u0005\u0002~j\t\t\u00111\u0001\u0002r\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0001\u0011\r\t\u0015!1BAD\u001b\t\u00119AC\u0002\u0003\nu\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iAa\u0002\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\u0011\u0019\u0002C\u0005\u0002~r\t\t\u00111\u0001\u0002\b\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tiN!\u0007\t\u0013\u0005uX$!AA\u0002\u0005E\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005E\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\b\t\u001d\u0002\"CA\u007fA\u0005\u0005\t\u0019AAD\u0003A1\u0015\u000e\u001c;fe\u0016\u001bH/[7bi&|g\u000e\u0005\u0002aEM)!Ea\f\u0003<A1!\u0011\u0007B\u001c1~k!Aa\r\u000b\u0007\tUR(A\u0004sk:$\u0018.\\3\n\t\te\"1\u0007\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\t\t\u0005\u0013Q]\u0001\u0003S>L1\u0001\u0016B )\t\u0011Y#A\u0003baBd\u0017\u0010F\u0002`\u0005\u0017BQAV\u0013A\u0002a\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003R\tM\u0003c\u0001\u001fr1\"A!Q\u000b\u0014\u0002\u0002\u0003\u0007q,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0017\u0011\t\u0005}'QL\u0005\u0005\u0005?\n\tO\u0001\u0004PE*,7\r\u001e")
public class FilterEstimation
implements Logging,
Product,
Serializable {
    private final Filter plan;
    private final Statistics childStats;
    private final ColumnStatsMap colStatsMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Filter> unapply(FilterEstimation x$0) {
        return FilterEstimation$.MODULE$.unapply(x$0);
    }

    public static FilterEstimation apply(Filter plan2) {
        return FilterEstimation$.MODULE$.apply(plan2);
    }

    public static <A> Function1<Filter, A> andThen(Function1<FilterEstimation, A> g) {
        return FilterEstimation$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, FilterEstimation> compose(Function1<A$, Filter> g) {
        return FilterEstimation$.MODULE$.compose(g);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Filter plan() {
        return this.plan;
    }

    private Statistics childStats() {
        return this.childStats;
    }

    private ColumnStatsMap colStatsMap() {
        return this.colStatsMap;
    }

    public Option<Statistics> estimate() {
        if (this.childStats().rowCount().isEmpty()) {
            return None$.MODULE$;
        }
        double filterSelectivity = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(this.plan().condition(), this.calculateFilterSelectivity$default$2()).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0));
        BigInt filteredRowCount = EstimationUtils$.MODULE$.ceil(package$.MODULE$.BigDecimal().apply((BigInt)this.childStats().rowCount().get()).$times(BigDecimal$.MODULE$.double2bigDecimal(filterSelectivity)));
        AttributeMap<ColumnStat> newColStats = BoxesRunTime.equalsNumObject((Number)filteredRowCount, (Object)BoxesRunTime.boxToInteger((int)0)) ? AttributeMap$.MODULE$.apply(Nil$.MODULE$) : this.colStatsMap().outputColumnStats((BigInt)this.childStats().rowCount().get(), filteredRowCount);
        BigInt filteredSizeInBytes = EstimationUtils$.MODULE$.getOutputSize(this.plan().output(), filteredRowCount, newColStats);
        return new Some((Object)this.childStats().copy(filteredSizeInBytes, (Option<BigInt>)new Some((Object)filteredRowCount), newColStats, this.childStats().copy$default$4()));
    }

    public Option<Object> calculateFilterSelectivity(Expression condition, boolean update) {
        Literal literal;
        Object object;
        Expression l;
        Expression expression;
        Expression expression2;
        boolean bl = false;
        Not not = null;
        Expression expression3 = condition;
        if (expression3 instanceof And) {
            And and = (And)expression3;
            Expression cond1 = and.left();
            Expression cond2 = and.right();
            double percent1 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond1, update).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0));
            double percent2 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond2, update).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0));
            return new Some((Object)BoxesRunTime.boxToDouble((double)(percent1 * percent2)));
        }
        if (expression3 instanceof Or) {
            Or or = (Or)expression3;
            Expression cond1 = or.left();
            Expression cond2 = or.right();
            double percent1 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond1, false).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0));
            double percent2 = BoxesRunTime.unboxToDouble((Object)this.calculateFilterSelectivity(cond2, false).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0));
            return new Some((Object)BoxesRunTime.boxToDouble((double)(percent1 + percent2 - percent1 * percent2)));
        }
        if (expression3 instanceof Not) {
            bl = true;
            not = (Not)expression3;
            Expression expression4 = not.child();
            if (expression4 instanceof And) {
                And and = (And)expression4;
                Expression cond1 = and.left();
                Expression cond2 = and.right();
                return this.calculateFilterSelectivity(new Or(new Not(cond1), new Not(cond2)), false);
            }
        }
        if (bl && (expression2 = not.child()) instanceof Or) {
            Or or = (Or)expression2;
            Expression cond1 = or.left();
            Expression cond2 = or.right();
            return this.calculateFilterSelectivity(new And(new Not(cond1), new Not(cond2)), false);
        }
        if (bl && (expression = not.child()) instanceof Not) {
            Not not2 = (Not)expression;
            Expression cond = not2.child();
            return this.calculateFilterSelectivity(cond, false);
        }
        if (bl && (l = not.child()) instanceof Literal && (object = (literal = (Literal)l).value()) == null) {
            return this.calculateSingleCondition(literal, false).map((Function1)(JFunction1.mcDD.sp & Serializable)x$1 -> this.boundProbability(x$1));
        }
        if (bl) {
            Expression cond = not.child();
            Option<Object> option = this.calculateFilterSelectivity(cond, false);
            if (option instanceof Some) {
                Some some = (Some)option;
                double percent = BoxesRunTime.unboxToDouble((Object)some.value());
                return new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 - percent)));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }
        return this.calculateSingleCondition(condition, update).map((Function1)(JFunction1.mcDD.sp & Serializable)x$2 -> this.boundProbability(x$2));
    }

    public boolean calculateFilterSelectivity$default$2() {
        return true;
    }

    public Option<Object> calculateSingleCondition(Expression condition, boolean update) {
        Option<Tuple2<Expression, Expression>> option;
        IsNotNull isNotNull;
        Expression ar;
        IsNull isNull;
        Expression ar2;
        Option<Tuple2<Expression, Expression>> option2;
        boolean bl = false;
        BinaryComparison binaryComparison = null;
        boolean bl2 = false;
        LessThan lessThan = null;
        boolean bl3 = false;
        LessThanOrEqual lessThanOrEqual = null;
        boolean bl4 = false;
        GreaterThan greaterThan = null;
        boolean bl5 = false;
        GreaterThanOrEqual greaterThanOrEqual = null;
        Expression expression = condition;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            return this.evaluateLiteral(literal);
        }
        if (expression instanceof BinaryComparison) {
            bl = true;
            binaryComparison = (BinaryComparison)expression;
            Option<Tuple2<Expression, Expression>> option3 = Equality$.MODULE$.unapply(binaryComparison);
            if (!option3.isEmpty()) {
                Expression ar3 = (Expression)((Tuple2)option3.get())._1();
                Expression l = (Expression)((Tuple2)option3.get())._2();
                if (ar3 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar3;
                    if (l instanceof Literal) {
                        Literal literal = (Literal)l;
                        return this.evaluateEquality(attribute, literal, update);
                    }
                }
            }
        }
        if (bl && !(option2 = Equality$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression l = (Expression)((Tuple2)option2.get())._1();
            Expression ar4 = (Expression)((Tuple2)option2.get())._2();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar4 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar4;
                    return this.evaluateEquality(attribute, literal, update);
                }
            }
        }
        if (expression instanceof LessThan) {
            bl2 = true;
            lessThan = (LessThan)expression;
            Expression ar5 = lessThan.left();
            Expression l = lessThan.right();
            if (ar5 instanceof Attribute) {
                Attribute attribute = (Attribute)ar5;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(lessThan, attribute, literal, update);
                }
            }
        }
        if (bl2) {
            Expression l = lessThan.left();
            Expression ar6 = lessThan.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar6 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar6;
                    return this.evaluateBinary(new GreaterThan(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof LessThanOrEqual) {
            bl3 = true;
            lessThanOrEqual = (LessThanOrEqual)expression;
            Expression ar7 = lessThanOrEqual.left();
            Expression l = lessThanOrEqual.right();
            if (ar7 instanceof Attribute) {
                Attribute attribute = (Attribute)ar7;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(lessThanOrEqual, attribute, literal, update);
                }
            }
        }
        if (bl3) {
            Expression l = lessThanOrEqual.left();
            Expression ar8 = lessThanOrEqual.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar8 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar8;
                    return this.evaluateBinary(new GreaterThanOrEqual(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof GreaterThan) {
            bl4 = true;
            greaterThan = (GreaterThan)expression;
            Expression ar9 = greaterThan.left();
            Expression l = greaterThan.right();
            if (ar9 instanceof Attribute) {
                Attribute attribute = (Attribute)ar9;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(greaterThan, attribute, literal, update);
                }
            }
        }
        if (bl4) {
            Expression l = greaterThan.left();
            Expression ar10 = greaterThan.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar10 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar10;
                    return this.evaluateBinary(new LessThan(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof GreaterThanOrEqual) {
            bl5 = true;
            greaterThanOrEqual = (GreaterThanOrEqual)expression;
            Expression ar11 = greaterThanOrEqual.left();
            Expression l = greaterThanOrEqual.right();
            if (ar11 instanceof Attribute) {
                Attribute attribute = (Attribute)ar11;
                if (l instanceof Literal) {
                    Literal literal = (Literal)l;
                    return this.evaluateBinary(greaterThanOrEqual, attribute, literal, update);
                }
            }
        }
        if (bl5) {
            Expression l = greaterThanOrEqual.left();
            Expression ar12 = greaterThanOrEqual.right();
            if (l instanceof Literal) {
                Literal literal = (Literal)l;
                if (ar12 instanceof Attribute) {
                    Attribute attribute = (Attribute)ar12;
                    return this.evaluateBinary(new LessThanOrEqual(attribute, literal), attribute, literal, update);
                }
            }
        }
        if (expression instanceof In) {
            In in = (In)expression;
            Expression ar13 = in.value();
            Seq<Expression> expList = in.list();
            if (ar13 instanceof Attribute) {
                Attribute attribute = (Attribute)ar13;
                if (expList.forall((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)FilterEstimation.$anonfun$calculateSingleCondition$1(e)))) {
                    Seq hSet = (Seq)expList.map((Function1 & Serializable)e -> e.eval(e.eval$default$1()));
                    return this.evaluateInSet(attribute, (Set<Object>)((Set)((SetOps)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((IterableOnce)hSet)), update);
                }
            }
        }
        if (expression instanceof InSet) {
            InSet inSet = (InSet)expression;
            Expression ar14 = inSet.child();
            Set<Object> set = inSet.hset();
            if (ar14 instanceof Attribute) {
                Attribute attribute = (Attribute)ar14;
                return this.evaluateInSet(attribute, set, update);
            }
        }
        if (expression instanceof IsNull && (ar2 = (isNull = (IsNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)ar2;
            if (this.plan().child() instanceof LeafNode) {
                return this.evaluateNullCheck(attribute, true, update);
            }
        }
        if (expression instanceof IsNotNull && (ar = (isNotNull = (IsNotNull)expression).child()) instanceof Attribute) {
            Attribute attribute = (Attribute)ar;
            if (this.plan().child() instanceof LeafNode) {
                return this.evaluateNullCheck(attribute, false, update);
            }
        }
        if (bl && !(option = Equality$.MODULE$.unapply(binaryComparison)).isEmpty()) {
            Expression attrLeft = (Expression)((Tuple2)option.get())._1();
            Expression attrRight = (Expression)((Tuple2)option.get())._2();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute2 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(binaryComparison, attribute, attribute2, update);
                }
            }
        }
        if (bl2) {
            Expression attrLeft = lessThan.left();
            Expression attrRight = lessThan.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute3 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(lessThan, attribute, attribute3, update);
                }
            }
        }
        if (bl3) {
            Expression attrLeft = lessThanOrEqual.left();
            Expression attrRight = lessThanOrEqual.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute4 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(lessThanOrEqual, attribute, attribute4, update);
                }
            }
        }
        if (bl4) {
            Expression attrLeft = greaterThan.left();
            Expression attrRight = greaterThan.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute5 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(greaterThan, attribute, attribute5, update);
                }
            }
        }
        if (bl5) {
            Expression attrLeft = greaterThanOrEqual.left();
            Expression attrRight = greaterThanOrEqual.right();
            if (attrLeft instanceof Attribute) {
                Attribute attribute = (Attribute)attrLeft;
                if (attrRight instanceof Attribute) {
                    Attribute attribute6 = (Attribute)attrRight;
                    return this.evaluateBinaryForTwoColumns(greaterThanOrEqual, attribute, attribute6, update);
                }
            }
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] Unsupported filter condition: " + condition);
        return None$.MODULE$;
    }

    public Option<Object> evaluateNullCheck(Attribute attr, boolean isNull, boolean update) {
        double nullPercent;
        if (!this.colStatsMap().contains(attr) || this.colStatsMap().apply(attr).nullCount().isEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No statistics for " + attr);
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        BigInt rowCountValue = (BigInt)this.childStats().rowCount().get();
        double d = BoxesRunTime.equalsNumObject((Number)rowCountValue, (Object)BoxesRunTime.boxToInteger((int)0)) ? 0.0 : (nullPercent = ((Ordered)colStat.nullCount().get()).$greater((Object)rowCountValue) ? 1.0 : package$.MODULE$.BigDecimal().apply((BigInt)colStat.nullCount().get()).$div(package$.MODULE$.BigDecimal().apply(rowCountValue)).toDouble());
        if (update) {
            ColumnStat columnStat;
            if (isNull) {
                columnStat = colStat.copy((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, colStat.copy$default$4(), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
            } else {
                Some x$1 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Option<BigInt> x$2 = colStat.copy$default$1();
                Option<Object> x$3 = colStat.copy$default$2();
                Option<Object> x$4 = colStat.copy$default$3();
                Option<Object> x$5 = colStat.copy$default$5();
                Option<Object> x$6 = colStat.copy$default$6();
                Option<Histogram> x$7 = colStat.copy$default$7();
                int x$8 = colStat.copy$default$8();
                columnStat = colStat.copy(x$2, x$3, x$4, (Option<BigInt>)x$1, x$5, x$6, x$7, x$8);
            }
            ColumnStat newStats = columnStat;
            this.colStatsMap().update(attr, newStats);
        }
        double percent = isNull ? nullPercent : 1.0 - nullPercent;
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    public Option<Object> evaluateBinary(BinaryComparison op, Attribute attr, Literal literal, boolean update) {
        if (!this.colStatsMap().contains(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No statistics for " + attr);
            return None$.MODULE$;
        }
        DataType dataType = attr.dataType();
        if (dataType instanceof NumericType ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : BooleanType$.MODULE$.equals(dataType)))) {
            return this.evaluateBinaryForNumeric(op, attr, literal, update);
        }
        if (StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType)) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No range comparison statistics for String/Binary type " + attr);
            return None$.MODULE$;
        }
        throw new MatchError((Object)dataType);
    }

    public Option<Object> evaluateEquality(Attribute attr, Literal literal, boolean update) {
        if (!this.colStatsMap().contains(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No statistics for " + attr);
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        ValueInterval statsInterval = ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), attr.dataType());
        if (statsInterval.contains(literal)) {
            if (update) {
                ColumnStat columnStat;
                DataType dataType = attr.dataType();
                if (StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType)) {
                    Some x$1 = new Some((Object)BigInt$.MODULE$.int2bigInt(1));
                    Some x$2 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                    Option<Object> x$3 = colStat.copy$default$2();
                    Option<Object> x$4 = colStat.copy$default$3();
                    Option<Object> x$5 = colStat.copy$default$5();
                    Option<Object> x$6 = colStat.copy$default$6();
                    Option<Histogram> x$7 = colStat.copy$default$7();
                    int x$8 = colStat.copy$default$8();
                    columnStat = colStat.copy((Option<BigInt>)x$1, x$3, x$4, (Option<BigInt>)x$2, x$5, x$6, x$7, x$8);
                } else {
                    columnStat = colStat.copy((Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(1)), (Option<Object>)new Some(literal.value()), (Option<Object>)new Some(literal.value()), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
                }
                ColumnStat newStats = columnStat;
                this.colStatsMap().update(attr, newStats);
            }
            if (colStat.histogram().isEmpty()) {
                if (!colStat.distinctCount().isEmpty()) {
                    return new Some((Object)BoxesRunTime.boxToDouble((double)(1.0 / ((ScalaNumericAnyConversions)colStat.distinctCount().get()).toDouble())));
                }
                return None$.MODULE$;
            }
            return new Some((Object)BoxesRunTime.boxToDouble((double)this.computeEqualityPossibilityByHistogram(literal, colStat)));
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
    }

    public Option<Object> evaluateLiteral(Literal literal) {
        Object object;
        Literal literal2 = literal;
        if (literal2 != null && (object = literal2.value()) == null) {
            return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        Literal literal3 = Literal$.MODULE$.FalseLiteral();
        Literal literal4 = literal2;
        if (!(literal3 != null ? !((Object)literal3).equals(literal4) : literal4 != null)) {
            return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
        }
        Literal literal5 = Literal$.MODULE$.TrueLiteral();
        Literal literal6 = literal2;
        if (!(literal5 != null ? !((Object)literal5).equals(literal6) : literal6 != null)) {
            return new Some((Object)BoxesRunTime.boxToDouble((double)1.0));
        }
        return None$.MODULE$;
    }

    public Option<Object> evaluateInSet(Attribute attr, Set<Object> hSet, boolean update) {
        if (!this.colStatsMap().hasDistinctCount(attr)) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No statistics for " + attr);
            return None$.MODULE$;
        }
        ColumnStat colStat = this.colStatsMap().apply(attr);
        BigInt ndv = (BigInt)colStat.distinctCount().get();
        DataType dataType = attr.dataType();
        BigInt newNdv = ndv;
        DataType dataType2 = dataType;
        if (dataType2 instanceof NumericType ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2)))) {
            if (ndv.toDouble() == 0.0 || colStat.min().isEmpty() || colStat.max().isEmpty()) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            NumericValueInterval statsInterval = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), dataType);
            Set validQuerySet = (Set)hSet.filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)FilterEstimation.$anonfun$evaluateInSet$2(statsInterval, dataType, v)));
            if (validQuerySet.isEmpty()) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            Object newMax = validQuerySet.maxBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)EstimationUtils$.MODULE$.toDouble(x$3, dataType)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
            Object newMin = validQuerySet.minBy((Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)EstimationUtils$.MODULE$.toDouble(x$4, dataType)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
            newNdv = ndv.min(package$.MODULE$.BigInt().apply(validQuerySet.size()));
            if (update) {
                ColumnStat newStats = colStat.copy((Option<BigInt>)new Some((Object)newNdv), (Option<Object>)new Some(newMin), (Option<Object>)new Some(newMax), (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
                this.colStatsMap().update(attr, newStats);
            }
        } else if (StringType$.MODULE$.equals(dataType2) ? true : BinaryType$.MODULE$.equals(dataType2)) {
            if (ndv.toDouble() == 0.0) {
                return new Some((Object)BoxesRunTime.boxToDouble((double)0.0));
            }
            newNdv = ndv.min(package$.MODULE$.BigInt().apply(hSet.size()));
            if (update) {
                Some x$1 = new Some((Object)newNdv);
                Some x$2 = new Some((Object)BigInt$.MODULE$.int2bigInt(0));
                Option<Object> x$32 = colStat.copy$default$2();
                Option<Object> x$42 = colStat.copy$default$3();
                Option<Object> x$5 = colStat.copy$default$5();
                Option<Object> x$6 = colStat.copy$default$6();
                Option<Histogram> x$7 = colStat.copy$default$7();
                int x$8 = colStat.copy$default$8();
                ColumnStat newStats = colStat.copy((Option<BigInt>)x$1, x$32, x$42, (Option<BigInt>)x$2, x$5, x$6, x$7, x$8);
                this.colStatsMap().update(attr, newStats);
            }
        } else {
            throw new MatchError((Object)dataType2);
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.min(newNdv.toDouble() / ndv.toDouble(), 1.0)));
    }

    public Option<Object> evaluateBinaryForNumeric(BinaryComparison op, Attribute attr, Literal literal, boolean update) {
        boolean bl;
        boolean completeOverlap;
        double numericLiteral;
        double ndv;
        double min;
        double max;
        ColumnStat colStat;
        block32: {
            Tuple2.mcZZ.sp sp2;
            block31: {
                Tuple2.mcZZ.sp sp3;
                if (!this.colStatsMap().hasMinMaxStats(attr) || !this.colStatsMap().hasDistinctCount(attr)) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No statistics for " + attr);
                    return None$.MODULE$;
                }
                colStat = this.colStatsMap().apply(attr);
                NumericValueInterval statsInterval = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStat.min(), colStat.max(), attr.dataType());
                max = statsInterval.max();
                min = statsInterval.min();
                ndv = ((ScalaNumericAnyConversions)colStat.distinctCount().get()).toDouble();
                numericLiteral = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
                BinaryComparison binaryComparison = op;
                if (binaryComparison instanceof LessThan) {
                    sp3 = new Tuple2.mcZZ.sp(numericLiteral <= min, numericLiteral > max);
                } else if (binaryComparison instanceof LessThanOrEqual) {
                    sp3 = new Tuple2.mcZZ.sp(numericLiteral < min, numericLiteral >= max);
                } else if (binaryComparison instanceof GreaterThan) {
                    sp3 = new Tuple2.mcZZ.sp(numericLiteral >= max, numericLiteral < min);
                } else if (binaryComparison instanceof GreaterThanOrEqual) {
                    sp3 = new Tuple2.mcZZ.sp(numericLiteral > max, numericLiteral <= min);
                } else {
                    throw new MatchError((Object)binaryComparison);
                }
                sp2 = sp3;
                if (sp2 == null) break block31;
                boolean noOverlap = sp2._1$mcZ$sp();
                completeOverlap = sp2._2$mcZ$sp();
                if (!true) break block31;
                bl = noOverlap;
                if (true) break block32;
            }
            throw new MatchError((Object)sp2);
        }
        boolean bl2 = completeOverlap;
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(bl, bl2);
        boolean noOverlap = sp4._1$mcZ$sp();
        boolean completeOverlap2 = sp4._2$mcZ$sp();
        double percent = 1.0;
        if (noOverlap) {
            percent = 0.0;
        } else if (completeOverlap2) {
            percent = 1.0;
        } else {
            if (colStat.histogram().isEmpty()) {
                double d;
                Predef$.MODULE$.assert(max > min);
                BinaryComparison binaryComparison = op;
                if (binaryComparison instanceof LessThan) {
                    d = numericLiteral == max ? 1.0 - 1.0 / ndv : (numericLiteral - min) / (max - min);
                } else if (binaryComparison instanceof LessThanOrEqual) {
                    d = numericLiteral == min ? 1.0 / ndv : (numericLiteral - min) / (max - min);
                } else if (binaryComparison instanceof GreaterThan) {
                    d = numericLiteral == min ? 1.0 - 1.0 / ndv : (max - numericLiteral) / (max - min);
                } else if (binaryComparison instanceof GreaterThanOrEqual) {
                    d = numericLiteral == max ? 1.0 / ndv : (max - numericLiteral) / (max - min);
                } else {
                    throw new MatchError((Object)binaryComparison);
                }
                percent = d;
            } else {
                percent = this.computeComparisonPossibilityByHistogram(op, literal, colStat);
            }
            if (update) {
                Some newValue = new Some(literal.value());
                Some newMax = colStat.max();
                Some newMin = colStat.min();
                BinaryComparison binaryComparison = op;
                if (binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual) {
                    newMin = newValue;
                } else if (binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual) {
                    newMax = newValue;
                } else {
                    throw new MatchError((Object)binaryComparison);
                }
                ColumnStat newStats = colStat.copy((Option<BigInt>)new Some((Object)EstimationUtils$.MODULE$.ceil(BigDecimal$.MODULE$.double2bigDecimal(ndv * percent))), (Option<Object>)newMin, (Option<Object>)newMax, (Option<BigInt>)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), colStat.copy$default$5(), colStat.copy$default$6(), colStat.copy$default$7(), colStat.copy$default$8());
                this.colStatsMap().update(attr, newStats);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    private double computeEqualityPossibilityByHistogram(Literal literal, ColumnStat colStat) {
        double datum = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        Histogram histogram = (Histogram)colStat.histogram().get();
        double min = EstimationUtils$.MODULE$.toDouble(colStat.min().get(), literal.dataType());
        double max = EstimationUtils$.MODULE$.toDouble(colStat.max().get(), literal.dataType());
        double numBinsHoldingEntireRange = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, min, true, histogram.bins());
        double numBinsHoldingDatum = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, true, datum, true, histogram.bins());
        return numBinsHoldingDatum / numBinsHoldingEntireRange;
    }

    private double computeComparisonPossibilityByHistogram(BinaryComparison op, Literal literal, ColumnStat colStat) {
        double d;
        double datum = EstimationUtils$.MODULE$.toDouble(literal.value(), literal.dataType());
        Histogram histogram = (Histogram)colStat.histogram().get();
        double min = EstimationUtils$.MODULE$.toDouble(colStat.min().get(), literal.dataType());
        double max = EstimationUtils$.MODULE$.toDouble(colStat.max().get(), literal.dataType());
        double numBinsHoldingEntireRange = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, min, true, histogram.bins());
        BinaryComparison binaryComparison = op;
        if (binaryComparison instanceof LessThan) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, false, min, true, histogram.bins());
        } else if (binaryComparison instanceof LessThanOrEqual) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(datum, true, min, true, histogram.bins());
        } else if (binaryComparison instanceof GreaterThan) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, datum, false, histogram.bins());
        } else if (binaryComparison instanceof GreaterThanOrEqual) {
            d = EstimationUtils$.MODULE$.numBinsHoldingRange(max, true, datum, true, histogram.bins());
        } else {
            throw new MatchError((Object)binaryComparison);
        }
        double numBinsHoldingRange = d;
        return numBinsHoldingRange / numBinsHoldingEntireRange;
    }

    public Option<Object> evaluateBinaryForTwoColumns(BinaryComparison op, Attribute attrLeft, Attribute attrRight, boolean update) {
        boolean bl;
        boolean completeOverlap;
        double minRight;
        double maxRight;
        ColumnStat colStatRight;
        double minLeft;
        double maxLeft;
        ColumnStat colStatLeft;
        block41: {
            Tuple2.mcZZ.sp sp2;
            block40: {
                Tuple2.mcZZ.sp sp3;
                if (!this.colStatsMap().hasCountStats(attrLeft)) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No statistics for " + attrLeft);
                    return None$.MODULE$;
                }
                if (!this.colStatsMap().hasCountStats(attrRight)) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No statistics for " + attrRight);
                    return None$.MODULE$;
                }
                DataType dataType = attrLeft.dataType();
                if (StringType$.MODULE$.equals(dataType) ? true : BinaryType$.MODULE$.equals(dataType)) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No range comparison statistics for String/Binary type " + attrLeft);
                    return None$.MODULE$;
                }
                if (!this.colStatsMap().hasMinMaxStats(attrLeft)) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No min/max statistics for " + attrLeft);
                    return None$.MODULE$;
                }
                if (!this.colStatsMap().hasMinMaxStats(attrRight)) {
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "[CBO] No min/max statistics for " + attrRight);
                    return None$.MODULE$;
                }
                colStatLeft = this.colStatsMap().apply(attrLeft);
                NumericValueInterval statsIntervalLeft = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStatLeft.min(), colStatLeft.max(), attrLeft.dataType());
                maxLeft = statsIntervalLeft.max();
                minLeft = statsIntervalLeft.min();
                colStatRight = this.colStatsMap().apply(attrRight);
                NumericValueInterval statsIntervalRight = (NumericValueInterval)ValueInterval$.MODULE$.apply(colStatRight.min(), colStatRight.max(), attrRight.dataType());
                maxRight = statsIntervalRight.max();
                minRight = statsIntervalRight.min();
                boolean allNotNull = BoxesRunTime.equals((Object)colStatLeft.nullCount().get(), (Object)BoxesRunTime.boxToInteger((int)0)) && BoxesRunTime.equals((Object)colStatRight.nullCount().get(), (Object)BoxesRunTime.boxToInteger((int)0));
                BinaryComparison binaryComparison = op;
                if (binaryComparison instanceof LessThan) {
                    sp3 = new Tuple2.mcZZ.sp(minLeft >= maxRight, maxLeft < minRight && allNotNull);
                } else if (binaryComparison instanceof LessThanOrEqual) {
                    sp3 = new Tuple2.mcZZ.sp(minLeft > maxRight, maxLeft <= minRight && allNotNull);
                } else if (binaryComparison instanceof GreaterThan) {
                    sp3 = new Tuple2.mcZZ.sp(maxLeft <= minRight, minLeft > maxRight && allNotNull);
                } else if (binaryComparison instanceof GreaterThanOrEqual) {
                    sp3 = new Tuple2.mcZZ.sp(maxLeft < minRight, minLeft >= maxRight && allNotNull);
                } else if (binaryComparison instanceof EqualTo) {
                    sp3 = new Tuple2.mcZZ.sp(maxLeft < minRight || maxRight < minLeft, minLeft == minRight && maxLeft == maxRight && allNotNull && BoxesRunTime.equals((Object)colStatLeft.distinctCount().get(), (Object)colStatRight.distinctCount().get()));
                } else if (binaryComparison instanceof EqualNullSafe) {
                    sp3 = new Tuple2.mcZZ.sp((maxLeft < minRight || maxRight < minLeft) && allNotNull, minLeft == minRight && maxLeft == maxRight && allNotNull && BoxesRunTime.equals((Object)colStatLeft.distinctCount().get(), (Object)colStatRight.distinctCount().get()));
                } else {
                    throw new MatchError((Object)binaryComparison);
                }
                sp2 = sp3;
                if (sp2 == null) break block40;
                boolean noOverlap = sp2._1$mcZ$sp();
                completeOverlap = sp2._2$mcZ$sp();
                if (!true) break block40;
                bl = noOverlap;
                if (true) break block41;
            }
            throw new MatchError((Object)sp2);
        }
        boolean bl2 = completeOverlap;
        Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(bl, bl2);
        boolean noOverlap = sp4._1$mcZ$sp();
        boolean completeOverlap2 = sp4._2$mcZ$sp();
        double percent = 1.0;
        if (noOverlap) {
            percent = 0.0;
        } else if (completeOverlap2) {
            percent = 1.0;
        } else {
            percent = 0.3333333333333333;
            if (update) {
                BigDecimal ndvLeft = package$.MODULE$.BigDecimal().apply((BigInt)colStatLeft.distinctCount().get());
                BigInt newNdvLeft = EstimationUtils$.MODULE$.ceil(ndvLeft.$times(BigDecimal$.MODULE$.double2bigDecimal(percent)));
                BigDecimal ndvRight = package$.MODULE$.BigDecimal().apply((BigInt)colStatRight.distinctCount().get());
                BigInt newNdvRight = EstimationUtils$.MODULE$.ceil(ndvRight.$times(BigDecimal$.MODULE$.double2bigDecimal(percent)));
                Option<Object> newMaxLeft = colStatLeft.max();
                Option<Object> newMinLeft = colStatLeft.min();
                Option<Object> newMaxRight = colStatRight.max();
                Option<Object> newMinRight = colStatRight.min();
                BinaryComparison binaryComparison = op;
                if (binaryComparison instanceof LessThan ? true : binaryComparison instanceof LessThanOrEqual) {
                    if (minLeft > minRight) {
                        newMinRight = colStatLeft.min();
                    }
                    if (maxLeft > maxRight) {
                        newMaxLeft = colStatRight.max();
                    }
                } else if (binaryComparison instanceof GreaterThan ? true : binaryComparison instanceof GreaterThanOrEqual) {
                    if (minLeft < minRight) {
                        newMinLeft = colStatRight.min();
                    }
                    if (maxLeft < maxRight) {
                        newMaxRight = colStatLeft.max();
                    }
                } else if (binaryComparison instanceof EqualTo ? true : binaryComparison instanceof EqualNullSafe) {
                    if (minLeft < minRight) {
                        newMinLeft = colStatRight.min();
                    } else {
                        newMinRight = colStatLeft.min();
                    }
                    if (maxLeft < maxRight) {
                        newMaxRight = colStatLeft.max();
                    } else {
                        newMaxLeft = colStatRight.max();
                    }
                } else {
                    throw new MatchError((Object)binaryComparison);
                }
                ColumnStat newStatsLeft = colStatLeft.copy((Option<BigInt>)new Some((Object)newNdvLeft), newMinLeft, newMaxLeft, colStatLeft.copy$default$4(), colStatLeft.copy$default$5(), colStatLeft.copy$default$6(), colStatLeft.copy$default$7(), colStatLeft.copy$default$8());
                this.colStatsMap().update(attrLeft, newStatsLeft);
                ColumnStat newStatsRight = colStatRight.copy((Option<BigInt>)new Some((Object)newNdvRight), newMinRight, newMaxRight, colStatRight.copy$default$4(), colStatRight.copy$default$5(), colStatRight.copy$default$6(), colStatRight.copy$default$7(), colStatRight.copy$default$8());
                this.colStatsMap().update(attrRight, newStatsRight);
            }
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)percent));
    }

    private double boundProbability(double p) {
        return Math.max(0.0, Math.min(1.0, p));
    }

    public FilterEstimation copy(Filter plan2) {
        return new FilterEstimation(plan2);
    }

    public Filter copy$default$1() {
        return this.plan();
    }

    public String productPrefix() {
        return "FilterEstimation";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.plan();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FilterEstimation;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "plan";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FilterEstimation)) return false;
        boolean bl = true;
        if (!bl) return false;
        FilterEstimation filterEstimation = (FilterEstimation)x$1;
        Filter filter = this.plan();
        Filter filter2 = filterEstimation.plan();
        if (filter == null) {
            if (filter2 != null) {
                return false;
            }
        } else if (!((Object)filter).equals(filter2)) return false;
        if (!filterEstimation.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$calculateSingleCondition$1(Expression e) {
        return e instanceof Literal;
    }

    public static final /* synthetic */ boolean $anonfun$evaluateInSet$2(NumericValueInterval statsInterval$1, DataType dataType$1, Object v) {
        return v != null && statsInterval$1.contains(new Literal(v, dataType$1));
    }

    public FilterEstimation(Filter plan2) {
        this.plan = plan2;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.childStats = plan2.child().stats();
        this.colStatsMap = new ColumnStatsMap(this.childStats().attributeStats());
    }
}

