/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.types;

import org.apache.spark.sql.catalyst.types.PhysicalArrayType;
import org.apache.spark.sql.catalyst.types.PhysicalBinaryType$;
import org.apache.spark.sql.catalyst.types.PhysicalBooleanType$;
import org.apache.spark.sql.catalyst.types.PhysicalByteType$;
import org.apache.spark.sql.catalyst.types.PhysicalCalendarIntervalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDataType;
import org.apache.spark.sql.catalyst.types.PhysicalDecimalType$;
import org.apache.spark.sql.catalyst.types.PhysicalDoubleType$;
import org.apache.spark.sql.catalyst.types.PhysicalFloatType$;
import org.apache.spark.sql.catalyst.types.PhysicalIntegerType$;
import org.apache.spark.sql.catalyst.types.PhysicalLongType$;
import org.apache.spark.sql.catalyst.types.PhysicalMapType;
import org.apache.spark.sql.catalyst.types.PhysicalNullType$;
import org.apache.spark.sql.catalyst.types.PhysicalShortType$;
import org.apache.spark.sql.catalyst.types.PhysicalStringType$;
import org.apache.spark.sql.catalyst.types.PhysicalStructType;
import org.apache.spark.sql.catalyst.types.PhysicalVariantType$;
import org.apache.spark.sql.catalyst.types.UninitializedPhysicalType$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.VariantType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import scala.Option;
import scala.Tuple2;
import scala.math.Ordering;

public final class PhysicalDataType$ {
    public static final PhysicalDataType$ MODULE$ = new PhysicalDataType$();

    public PhysicalDataType apply(DataType dt) {
        DecimalType decimalType;
        Option option;
        DataType dataType = dt;
        if (NullType$.MODULE$.equals(dataType)) {
            return PhysicalNullType$.MODULE$;
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return PhysicalByteType$.MODULE$;
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return PhysicalShortType$.MODULE$;
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return PhysicalIntegerType$.MODULE$;
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return PhysicalLongType$.MODULE$;
        }
        if (dataType instanceof VarcharType) {
            return PhysicalStringType$.MODULE$.apply(StringType$.MODULE$.collationId());
        }
        if (dataType instanceof CharType) {
            return PhysicalStringType$.MODULE$.apply(StringType$.MODULE$.collationId());
        }
        if (dataType instanceof StringType) {
            StringType stringType = (StringType)dataType;
            return PhysicalStringType$.MODULE$.apply(stringType.collationId());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return PhysicalFloatType$.MODULE$;
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return PhysicalDoubleType$.MODULE$;
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int p = ((Tuple2)option.get())._1$mcI$sp();
            int s = ((Tuple2)option.get())._2$mcI$sp();
            return PhysicalDecimalType$.MODULE$.apply(p, s);
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return PhysicalBooleanType$.MODULE$;
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return PhysicalBinaryType$.MODULE$;
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return PhysicalLongType$.MODULE$;
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return PhysicalLongType$.MODULE$;
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return PhysicalCalendarIntervalType$.MODULE$;
        }
        if (dataType instanceof DayTimeIntervalType) {
            return PhysicalLongType$.MODULE$;
        }
        if (dataType instanceof YearMonthIntervalType) {
            return PhysicalIntegerType$.MODULE$;
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return PhysicalIntegerType$.MODULE$;
        }
        if (dataType instanceof TimeType) {
            return PhysicalLongType$.MODULE$;
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            return new PhysicalArrayType(elementType, containsNull);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return new PhysicalStructType(fields);
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            return new PhysicalMapType(keyType, valueType, valueContainsNull);
        }
        if (VariantType$.MODULE$.equals(dataType)) {
            return PhysicalVariantType$.MODULE$;
        }
        return UninitializedPhysicalType$.MODULE$;
    }

    public Ordering<Object> ordering(DataType dt) {
        return this.apply(dt).ordering();
    }

    private PhysicalDataType$() {
    }
}

