/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.spark.api.r.JVMObjectId;
import org.apache.spark.api.r.JVMObjectTracker;
import org.apache.spark.util.collection.Utils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.mutable.ArraySeq;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class SerDe$ {
    public static final SerDe$ MODULE$ = new SerDe$();
    private static Function2<DataInputStream, Object, Object> sqlReadObject;
    private static Function2<DataOutputStream, Object, Object> sqlWriteObject;

    public SerDe$ setSQLReadObject(Function2<DataInputStream, Object, Object> value) {
        sqlReadObject = value;
        return this;
    }

    public SerDe$ setSQLWriteObject(Function2<DataOutputStream, Object, Object> value) {
        sqlWriteObject = value;
        return this;
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public Object readObject(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        char dataType = this.readObjectType(dis);
        return this.readTypedObject(dis, dataType, jvmObjectTracker);
    }

    public Object readTypedObject(DataInputStream dis, char dataType, JVMObjectTracker jvmObjectTracker) {
        char c = dataType;
        switch (c) {
            case 'n': {
                return null;
            }
            case 'i': {
                return this.readInt(dis);
            }
            case 'd': {
                return this.readDouble(dis);
            }
            case 'b': {
                return this.readBoolean(dis);
            }
            case 'c': {
                return this.readString(dis);
            }
            case 'e': {
                return this.readMap(dis, jvmObjectTracker);
            }
            case 'r': {
                return this.readBytes(dis);
            }
            case 'a': {
                return this.readArray(dis, jvmObjectTracker);
            }
            case 'l': {
                return this.readList(dis, jvmObjectTracker);
            }
            case 'D': {
                return this.readDate(dis);
            }
            case 't': {
                return this.readTime(dis);
            }
            case 'j': {
                return jvmObjectTracker.apply(new JVMObjectId(this.readString(dis)));
            }
        }
        if (sqlReadObject == null) {
            throw new IllegalArgumentException("Invalid type " + dataType);
        }
        Object obj = sqlReadObject.apply((Object)dis, (Object)BoxesRunTime.boxToCharacter((char)dataType));
        if (obj == null) {
            throw new IllegalArgumentException("Invalid type " + dataType);
        }
        return obj;
    }

    public byte[] readBytes(DataInputStream in) {
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        return out;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        Predef$.MODULE$.assert(bytes[len - 1] == 0);
        String str = new String((byte[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.byteArrayOps(bytes), 1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        return in.readInt() != 0;
    }

    public Date readDate(DataInputStream in) {
        String inStr;
        String string = inStr = this.readString(in);
        String string2 = "NA";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return null;
        }
        return Date.valueOf(inStr);
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        if (Double.isNaN(seconds)) {
            return null;
        }
        long sec = (long)Math.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        return (byte[][])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)x$3 -> SerDe$.MODULE$.readBytes(in)).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        return (int[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcII.sp & Serializable)x$4 -> MODULE$.readInt(in)).toArray((ClassTag)ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        return (double[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcDI.sp & Serializable)x$5 -> MODULE$.readDouble(in)).toArray((ClassTag)ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        return (boolean[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> MODULE$.readBoolean(in)).toArray((ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        return (String[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)x$7 -> SerDe$.MODULE$.readString(in)).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Object readArray(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        char arrType;
        char c = arrType = this.readObjectType(dis);
        switch (c) {
            case 'i': {
                return this.readIntArr(dis);
            }
            case 'c': {
                return this.readStringArr(dis);
            }
            case 'd': {
                return this.readDoubleArr(dis);
            }
            case 'b': {
                return this.readBooleanArr(dis);
            }
            case 'j': {
                return ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.readStringArr(dis)), (Function1 & Serializable)x -> jvmObjectTracker.apply(new JVMObjectId((String)x)), ClassTag$.MODULE$.Object());
            }
            case 'r': {
                return this.readBytesArr(dis);
            }
            case 'a': {
                int len = this.readInt(dis);
                return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)x$8 -> SerDe$.MODULE$.readArray(dis, jvmObjectTracker)).toArray(ClassTag$.MODULE$.apply(Object.class));
            }
            case 'l': {
                int len = this.readInt(dis);
                return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)x$9 -> SerDe$.MODULE$.readList(dis, jvmObjectTracker)).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
            }
        }
        if (sqlReadObject == null) {
            throw new IllegalArgumentException("Invalid array type " + arrType);
        }
        int len = this.readInt(dis);
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)x$10 -> SerDe$.$anonfun$readArray$4(dis, arrType, BoxesRunTime.unboxToInt((Object)x$10))).toArray(ClassTag$.MODULE$.Object());
    }

    public Object[] readList(DataInputStream dis, JVMObjectTracker jvmObjectTracker) {
        int len = this.readInt(dis);
        return (Object[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable)x$11 -> SerDe$.MODULE$.readObject(dis, jvmObjectTracker)).toArray(ClassTag$.MODULE$.Object());
    }

    public java.util.Map<Object, Object> readMap(DataInputStream in, JVMObjectTracker jvmObjectTracker) {
        int len = this.readInt(in);
        if (len > 0) {
            Object[] keys = (Object[])this.readArray(in, jvmObjectTracker);
            Object[] values = this.readList(in, jvmObjectTracker);
            return Utils$.MODULE$.toJavaMap(Predef$.MODULE$.wrapRefArray(keys), Predef$.MODULE$.wrapRefArray(values));
        }
        return new HashMap<Object, Object>();
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        block14: {
            String string = typeStr;
            switch (string == null ? 0 : string.hashCode()) {
                case -1325958191: {
                    if (!"double".equals(string)) break;
                    dos.writeByte(100);
                    break block14;
                }
                case 107868: {
                    if (!"map".equals(string)) break;
                    dos.writeByte(101);
                    break block14;
                }
                case 112680: {
                    if (!"raw".equals(string)) break;
                    dos.writeByte(114);
                    break block14;
                }
                case 3076014: {
                    if (!"date".equals(string)) break;
                    dos.writeByte(68);
                    break block14;
                }
                case 3267661: {
                    if (!"jobj".equals(string)) break;
                    dos.writeByte(106);
                    break block14;
                }
                case 3322014: {
                    if (!"list".equals(string)) break;
                    dos.writeByte(108);
                    break block14;
                }
                case 3560141: {
                    if (!"time".equals(string)) break;
                    dos.writeByte(116);
                    break block14;
                }
                case 3625364: {
                    if (!"void".equals(string)) break;
                    dos.writeByte(110);
                    break block14;
                }
                case 93090393: {
                    if (!"array".equals(string)) break;
                    dos.writeByte(97);
                    break block14;
                }
                case 342334473: {
                    if (!"logical".equals(string)) break;
                    dos.writeByte(98);
                    break block14;
                }
                case 1564195625: {
                    if (!"character".equals(string)) break;
                    dos.writeByte(99);
                    break block14;
                }
                case 1958052158: {
                    if (!"integer".equals(string)) break;
                    dos.writeByte(105);
                    break block14;
                }
            }
            throw new IllegalArgumentException("Invalid type " + typeStr);
        }
    }

    private void writeKeyValue(DataOutputStream dos, Object key, Object value, JVMObjectTracker jvmObjectTracker) {
        if (key == null) {
            throw new IllegalArgumentException("Key in map can't be null.");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Invalid map key type: " + key.getClass().getName());
        }
        this.writeString(dos, (String)key);
        this.writeObject(dos, value, jvmObjectTracker);
    }

    public void writeObject(DataOutputStream dos, Object obj, JVMObjectTracker jvmObjectTracker) {
        boolean sqlWriteSucceeded;
        Object value;
        Object object;
        if (obj == null) {
            this.writeType(dos, "void");
            return;
        }
        Object object2 = obj;
        if (object2 instanceof ArraySeq) {
            ArraySeq arraySeq = (ArraySeq)object2;
            object = arraySeq.array();
        } else {
            object = object2;
        }
        Object object3 = value = object;
        if (object3 instanceof Character) {
            Character c = (Character)object3;
            this.writeType(dos, "character");
            this.writeString(dos, c.toString());
            return;
        }
        if (object3 instanceof String) {
            String string = (String)object3;
            this.writeType(dos, "character");
            this.writeString(dos, string);
            return;
        }
        if (object3 instanceof Long) {
            Long l = (Long)object3;
            this.writeType(dos, "double");
            this.writeDouble(dos, Predef$.MODULE$.Long2long(l));
            return;
        }
        if (object3 instanceof Float) {
            Float f = (Float)object3;
            this.writeType(dos, "double");
            this.writeDouble(dos, Predef$.MODULE$.Float2float(f));
            return;
        }
        if (object3 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object3;
            this.writeType(dos, "double");
            this.writeDouble(dos, BigDecimal$.MODULE$.apply(bigDecimal).toDouble());
            return;
        }
        if (object3 instanceof Double) {
            Double d = (Double)object3;
            this.writeType(dos, "double");
            this.writeDouble(dos, Predef$.MODULE$.Double2double(d));
            return;
        }
        if (object3 instanceof Byte) {
            Byte by = (Byte)object3;
            this.writeType(dos, "integer");
            this.writeInt(dos, Predef$.MODULE$.Byte2byte(by));
            return;
        }
        if (object3 instanceof Short) {
            Short s = (Short)object3;
            this.writeType(dos, "integer");
            this.writeInt(dos, Predef$.MODULE$.Short2short(s));
            return;
        }
        if (object3 instanceof Integer) {
            Integer n = (Integer)object3;
            this.writeType(dos, "integer");
            this.writeInt(dos, Predef$.MODULE$.Integer2int(n));
            return;
        }
        if (object3 instanceof Boolean) {
            Boolean bl = (Boolean)object3;
            this.writeType(dos, "logical");
            this.writeBoolean(dos, Predef$.MODULE$.Boolean2boolean(bl));
            return;
        }
        if (object3 instanceof Date) {
            Date date = (Date)object3;
            this.writeType(dos, "date");
            this.writeDate(dos, date);
            return;
        }
        if (object3 instanceof Time) {
            Time time = (Time)object3;
            this.writeType(dos, "time");
            this.writeTime(dos, time);
            return;
        }
        if (object3 instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object3;
            this.writeType(dos, "time");
            this.writeTime(dos, timestamp);
            return;
        }
        if (object3 instanceof byte[]) {
            byte[] byArray = (byte[])object3;
            this.writeType(dos, "raw");
            this.writeBytes(dos, byArray);
            return;
        }
        if (object3 instanceof char[]) {
            char[] cArray = (char[])object3;
            this.writeType(dos, "array");
            this.writeStringArr(dos, (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.charArrayOps(cArray), (Function1 & Serializable)x$12 -> SerDe$.$anonfun$writeObject$1(BoxesRunTime.unboxToChar((Object)x$12)), ClassTag$.MODULE$.apply(String.class)));
            return;
        }
        if (object3 instanceof short[]) {
            short[] sArray = (short[])object3;
            this.writeType(dos, "array");
            this.writeIntArr(dos, (int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.shortArrayOps(sArray), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToShort((Object)x$13)), (ClassTag)ClassTag$.MODULE$.Int()));
            return;
        }
        if (object3 instanceof int[]) {
            int[] nArray = (int[])object3;
            this.writeType(dos, "array");
            this.writeIntArr(dos, nArray);
            return;
        }
        if (object3 instanceof long[]) {
            long[] lArray = (long[])object3;
            this.writeType(dos, "array");
            this.writeDoubleArr(dos, (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.longArrayOps(lArray), (Function1)(JFunction1.mcDJ.sp & Serializable)x$14 -> x$14, (ClassTag)ClassTag$.MODULE$.Double()));
            return;
        }
        if (object3 instanceof float[]) {
            float[] fArray = (float[])object3;
            this.writeType(dos, "array");
            this.writeDoubleArr(dos, (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.floatArrayOps(fArray), (Function1)(JFunction1.mcDF.sp & Serializable)x$15 -> x$15, (ClassTag)ClassTag$.MODULE$.Double()));
            return;
        }
        if (object3 instanceof double[]) {
            double[] dArray = (double[])object3;
            this.writeType(dos, "array");
            this.writeDoubleArr(dos, dArray);
            return;
        }
        if (object3 instanceof boolean[]) {
            boolean[] blArray = (boolean[])object3;
            this.writeType(dos, "array");
            this.writeBooleanArr(dos, blArray);
            return;
        }
        if (object3 instanceof Object[]) {
            Object[] objectArray = (Object[])object3;
            this.writeType(dos, "list");
            this.writeInt(dos, objectArray.length);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectArray), (Function1 & Serializable)elem -> {
                SerDe$.MODULE$.writeObject(dos, elem, jvmObjectTracker);
                return BoxedUnit.UNIT;
            });
            return;
        }
        if (object3 instanceof Properties) {
            this.writeType(dos, "jobj");
            this.writeJObj(dos, value, jvmObjectTracker);
            return;
        }
        if (object3 instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object3;
            this.writeType(dos, "map");
            this.writeInt(dos, map.size());
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value2 = entry.getValue();
                this.writeKeyValue(dos, key, value2, jvmObjectTracker);
            }
            return;
        }
        if (object3 instanceof Map) {
            Map map = (Map)object3;
            this.writeType(dos, "map");
            this.writeInt(dos, map.size());
            map.foreach((Function1 & Serializable)x0$1 -> {
                SerDe$.$anonfun$writeObject$6(dos, jvmObjectTracker, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        boolean bl = sqlWriteSucceeded = sqlWriteObject != null && BoxesRunTime.unboxToBoolean((Object)sqlWriteObject.apply((Object)dos, value));
        if (!sqlWriteSucceeded) {
            this.writeType(dos, "jobj");
            this.writeJObj(dos, value, jvmObjectTracker);
            return;
        }
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        int intValue = value ? 1 : 0;
        out.writeInt(intValue);
    }

    public void writeDate(DataOutputStream out, Date value) {
        this.writeString(out, value.toString());
    }

    public void writeTime(DataOutputStream out, Time value) {
        out.writeDouble((double)value.getTime() / 1000.0);
    }

    public void writeTime(DataOutputStream out, Timestamp value) {
        out.writeDouble((double)(value.getTime() / 1000L) + (double)value.getNanos() / 1.0E9);
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        out.writeInt(value.length);
        out.write(value);
    }

    public void writeJObj(DataOutputStream out, Object value, JVMObjectTracker jvmObjectTracker) {
        JVMObjectId jVMObjectId = jvmObjectTracker.addAndGetId(value);
        if (jVMObjectId == null) {
            throw new MatchError((Object)jVMObjectId);
        }
        String id = jVMObjectId.id();
        String id2 = id;
        this.writeString(out, id2);
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(value), (Function1)(JFunction1.mcVI.sp & Serializable)v -> out.writeInt(v));
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(value), (Function1)(JFunction1.mcVD.sp & Serializable)v -> out.writeDouble(v));
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.booleanArrayOps(value), (Function1 & Serializable)v -> {
            SerDe$.MODULE$.writeBoolean(out, BoxesRunTime.unboxToBoolean((Object)v));
            return BoxedUnit.UNIT;
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value) {
        this.writeType(out, "character");
        out.writeInt(value.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])value), (Function1 & Serializable)v -> {
            SerDe$.MODULE$.writeString(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Object $anonfun$readArray$4(DataInputStream dis$1, char arrType$1, int x$10) {
        Object obj = sqlReadObject.apply((Object)dis$1, (Object)BoxesRunTime.boxToCharacter((char)arrType$1));
        if (obj == null) {
            throw new IllegalArgumentException("Invalid array type " + arrType$1);
        }
        return obj;
    }

    public static final /* synthetic */ String $anonfun$writeObject$1(char x$12) {
        return Character.toString(x$12);
    }

    public static final /* synthetic */ void $anonfun$writeObject$6(DataOutputStream dos$1, JVMObjectTracker jvmObjectTracker$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object k1 = tuple2._1();
            Object v1 = tuple2._2();
            MODULE$.writeKeyValue(dos$1, k1, v1, jvmObjectTracker$3);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SerDe$() {
    }
}

