/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.io;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005=4A!\u0005\n\u00017!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00040\u0001\t\u0007I\u0011\u0002\u0019\t\rQ\u0002\u0001\u0015!\u00032\u0011\u001d)\u0004A1A\u0005\nABaA\u000e\u0001!\u0002\u0013\t\u0004bB\u001c\u0001\u0005\u0004%I\u0001\u000f\u0005\u0007y\u0001\u0001\u000b\u0011B\u001d\t\u000fu\u0002!\u0019!C\u0005}!11\n\u0001Q\u0001\n}Bq\u0001\u0014\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004N\u0001\u0001\u0006I!\r\u0005\u0006\u001d\u0002!\te\u0014\u0005\u00073\u0002!\t\u0005\u0006.\t\u000b}\u0003A\u0011\t1\t\u000b\u0015\u0004A\u0011\t4\u0003)i\u001bF\u000fZ\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0015\t\u0019B#\u0001\u0002j_*\u0011QCF\u0001\u0006gB\f'o\u001b\u0006\u0003/a\ta!\u00199bG\",'\"A\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001a\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VM\u001a\t\u0003G\u0011j\u0011AE\u0005\u0003KI\u0011\u0001cQ8naJ,7o]5p]\u000e{G-Z2\u0002\t\r|gN\u001a\t\u0003Q%j\u0011\u0001F\u0005\u0003UQ\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\tic\u0006\u0005\u0002$\u0001!)aE\u0001a\u0001O\u0005Q!-\u001e4gKJ\u001c\u0016N_3\u0016\u0003E\u0002\"!\b\u001a\n\u0005Mr\"aA%oi\u0006Y!-\u001e4gKJ\u001c\u0016N_3!\u0003\u0015aWM^3m\u0003\u0019aWM^3mA\u0005A1\u000f\u001e:bi\u0016<\u00170F\u0001:!\ri\"(M\u0005\u0003wy\u0011aa\u00149uS>t\u0017!C:ue\u0006$XmZ=!\u0003)\u0011WO\u001a4feB{w\u000e\\\u000b\u0002\u007fA\u0011\u0001)S\u0007\u0002\u0003*\u0011!iQ\u0001\u0005uN$HM\u0003\u0002E\u000b\u0006)A.\u001e2f]*\u0011aiR\u0001\u0007O&$\b.\u001e2\u000b\u0003!\u000b1aY8n\u0013\tQ\u0015I\u0001\u0006Ck\u001a4WM\u001d)p_2\f1BY;gM\u0016\u0014\bk\\8mA\u00059qo\u001c:lKJ\u001c\u0018\u0001C<pe.,'o\u001d\u0011\u0002-\r|W\u000e\u001d:fgN,GmT;uaV$8\u000b\u001e:fC6$\"\u0001U,\u0011\u0005E+V\"\u0001*\u000b\u0005M\u0019&\"\u0001+\u0002\t)\fg/Y\u0005\u0003-J\u0013AbT;uaV$8\u000b\u001e:fC6DQ\u0001W\u0007A\u0002A\u000b\u0011a]\u0001!G>l\u0007O]3tg\u0016$7i\u001c8uS:,x.^:PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0006\u0002\\=B\u0011\u0011\u000bX\u0005\u0003;J\u0013ACQ;gM\u0016\u0014X\rZ(viB,Ho\u0015;sK\u0006l\u0007\"\u0002-\u000f\u0001\u0004\u0001\u0016!F2p[B\u0014Xm]:fI&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003C\u0012\u0004\"!\u00152\n\u0005\r\u0014&aC%oaV$8\u000b\u001e:fC6DQ\u0001W\bA\u0002\u0005\fqdY8naJ,7o]3e\u0007>tG/\u001b8v_V\u001c\u0018J\u001c9viN#(/Z1n)\t\tw\rC\u0003Y!\u0001\u0007\u0011\r\u000b\u0002\u0001SB\u0011!.\\\u0007\u0002W*\u0011A\u000eF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00018l\u00051!UM^3m_B,'/\u00119j\u0001")
public class ZStdCompressionCodec
implements CompressionCodec {
    private final int bufferSize;
    private final int level;
    private final Option<Object> strategy;
    private final BufferPool bufferPool;
    private final int workers;

    private int bufferSize() {
        return this.bufferSize;
    }

    private int level() {
        return this.level;
    }

    private Option<Object> strategy() {
        return this.strategy;
    }

    private BufferPool bufferPool() {
        return this.bufferPool;
    }

    private int workers() {
        return this.workers;
    }

    @Override
    public OutputStream compressedOutputStream(OutputStream s) {
        ZstdOutputStreamNoFinalizer os = new ZstdOutputStreamNoFinalizer(s, this.bufferPool()).setLevel(this.level()).setWorkers(this.workers());
        this.strategy().foreach((Function1 & Serializable)x$1 -> os.setStrategy(BoxesRunTime.unboxToInt((Object)x$1)));
        return new BufferedOutputStream((OutputStream)os, this.bufferSize());
    }

    @Override
    public BufferedOutputStream compressedContinuousOutputStream(OutputStream s) {
        ZstdOutputStreamNoFinalizer os = new ZstdOutputStreamNoFinalizer(s, this.bufferPool()).setLevel(this.level()).setWorkers(this.workers()).setCloseFrameOnFlush(true);
        return new BufferedOutputStream((OutputStream)os, this.bufferSize());
    }

    @Override
    public InputStream compressedInputStream(InputStream s) {
        return new BufferedInputStream((InputStream)new ZstdInputStreamNoFinalizer(s, this.bufferPool()), this.bufferSize());
    }

    @Override
    public InputStream compressedContinuousInputStream(InputStream s) {
        return new BufferedInputStream((InputStream)new ZstdInputStreamNoFinalizer(s, this.bufferPool()).setContinuous(true), this.bufferSize());
    }

    public ZStdCompressionCodec(SparkConf conf) {
        CompressionCodec.$init$(this);
        this.bufferSize = (int)BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_BUFFERSIZE()));
        this.level = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_LEVEL()));
        this.strategy = (Option)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_STRATEGY());
        this.bufferPool = BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_BUFFERPOOL_ENABLED())) ? RecyclingBufferPool.INSTANCE : NoPool.INSTANCE;
        this.workers = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.IO_COMPRESSION_ZSTD_WORKERS()));
    }
}

