/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.io.IntWritable;

class IntegerTransformerAdapter
extends AbstractTransformerAdapter {
    final IntObjectInspector columnType;
    final IntWritable writable;

    public IntegerTransformerAdapter(IntObjectInspector columnType, AbstractTransformer transformer) {
        this(columnType, transformer, new IntWritable());
    }

    public IntegerTransformerAdapter(IntObjectInspector columnType, AbstractTransformer transformer, IntWritable writable) {
        super(transformer);
        this.columnType = columnType;
        this.writable = writable;
    }

    @Override
    public Object getTransformedWritable(GenericUDF.DeferredObject object) throws HiveException {
        Integer transformedValue;
        Integer value = (Integer)this.columnType.getPrimitiveJavaObject(object.get());
        if (value != null && (transformedValue = this.transformer.transform(value)) != null) {
            this.writable.set(transformedValue.intValue());
            return this.writable;
        }
        return null;
    }
}

