/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.TupleSketchIterator;

public class Filter<T extends Summary> {
    private final Predicate<T> predicate;

    public Filter(Predicate<T> predicate) {
        this.predicate = predicate;
    }

    public CompactSketch<T> filter(Sketch<T> sketchIn) {
        boolean isEmpty;
        if (sketchIn == null) {
            return new CompactSketch(null, null, Long.MAX_VALUE, true);
        }
        long[] hashes = new long[sketchIn.getRetainedEntries()];
        Summary[] summaries = null;
        int i = 0;
        TupleSketchIterator<T> it = sketchIn.iterator();
        while (it.next()) {
            T summary = it.getSummary();
            if (!this.predicate.test(summary)) continue;
            hashes[i] = it.getHash();
            if (summaries == null) {
                summaries = (Summary[])Array.newInstance(summary.getClass(), sketchIn.getRetainedEntries());
            }
            summaries[i++] = summary.copy();
        }
        boolean bl = isEmpty = i == 0 && !sketchIn.isEstimationMode();
        if (i == 0) {
            return new CompactSketch(null, null, sketchIn.getThetaLong(), isEmpty);
        }
        return new CompactSketch(Arrays.copyOf(hashes, i), (Summary[])Arrays.copyOf(summaries, i), sketchIn.getThetaLong(), isEmpty);
    }
}

