/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.api;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.storm.task.IErrorReporter;
import org.apache.storm.task.TopologyContext;

public interface IMetricsConsumer {
    public void prepare(Map<String, Object> var1, Object var2, TopologyContext var3, IErrorReporter var4);

    public void handleDataPoints(TaskInfo var1, Collection<DataPoint> var2);

    public void cleanup();

    public static class DataPoint {
        public String name;
        public Object value;
        public Map<String, String> dimensions;

        public DataPoint() {
        }

        public DataPoint(String name, Object value) {
            this(name, value, Collections.emptyMap());
        }

        public DataPoint(String name, Object value, Map<String, String> dimensions) {
            this.name = name;
            this.value = value;
            this.dimensions = dimensions;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(this.name);
            sb.append("=");
            sb.append(this.value);
            if (!this.dimensions.isEmpty()) {
                sb.append(", ");
                sb.append(this.dimensions.toString());
            }
            sb.append("]");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DataPoint)) {
                return false;
            }
            DataPoint dataPoint = (DataPoint)o;
            return Objects.equals(this.name, dataPoint.name) && Objects.deepEquals(this.value, dataPoint.value) && Objects.deepEquals(this.dimensions, dataPoint.dimensions);
        }

        public int hashCode() {
            int result2 = this.name != null ? this.name.hashCode() : 0;
            result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
            result2 = 31 * result2 + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            return result2;
        }
    }

    public static class TaskInfo {
        public String srcWorkerHost;
        public int srcWorkerPort;
        public String srcComponentId;
        public int srcTaskId;
        public long timestamp;
        public int updateIntervalSecs;

        public TaskInfo() {
        }

        public TaskInfo(String srcWorkerHost, int srcWorkerPort, String srcComponentId, int srcTaskId, long timestamp, int updateIntervalSecs) {
            this.srcWorkerHost = srcWorkerHost;
            this.srcWorkerPort = srcWorkerPort;
            this.srcComponentId = srcComponentId;
            this.srcTaskId = srcTaskId;
            this.timestamp = timestamp;
            this.updateIntervalSecs = updateIntervalSecs;
        }

        public String toString() {
            return "TASK_INFO: { host: " + this.srcWorkerHost + ":" + this.srcWorkerPort + " comp: " + this.srcComponentId + "[" + this.srcTaskId + "]}";
        }
    }
}

