/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.authorizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.security.auth.ClientAuthUtils;
import org.apache.storm.security.auth.IAuthorizer;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.utils.ObjectReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorSimpleACLAuthorizer
implements IAuthorizer {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorSimpleACLAuthorizer.class);
    protected Set<String> topoCommands = new HashSet<String>(Arrays.asList("getLocalAssignmentForStorm", "sendSupervisorWorkerHeartbeat"));
    protected Set<String> nimbusCommands = new HashSet<String>(Arrays.asList("sendSupervisorAssignments"));
    protected Set<String> admins;
    protected Set<String> adminsGroups;
    protected Set<String> nimbus;
    protected IPrincipalToLocal ptol;
    protected IGroupMappingServiceProvider groupMappingServiceProvider;

    @Override
    public void prepare(Map<String, Object> conf) {
        this.admins = new HashSet<String>();
        this.adminsGroups = new HashSet<String>();
        this.nimbus = new HashSet<String>();
        if (conf.containsKey("nimbus.admins")) {
            this.admins.addAll((Collection)conf.get("nimbus.admins"));
        }
        if (conf.containsKey("nimbus.admins.groups")) {
            this.adminsGroups.addAll((Collection)conf.get("nimbus.admins.groups"));
        }
        if (conf.containsKey("nimbus.daemon.users")) {
            this.nimbus.addAll((Collection)conf.get("nimbus.daemon.users"));
        } else if (conf.containsKey("nimbus.supervisor.users")) {
            LOG.warn("{} is not set falling back to using {}.", (Object)"nimbus.daemon.users", (Object)"nimbus.supervisor.users");
            this.nimbus.addAll((Collection)conf.get("nimbus.supervisor.users"));
        } else {
            LOG.error("Could not find {} things might now work correctly...", (Object)"nimbus.daemon.users");
        }
        this.ptol = ClientAuthUtils.getPrincipalToLocalPlugin(conf);
        this.groupMappingServiceProvider = ClientAuthUtils.getGroupMappingServiceProviderPlugin(conf);
    }

    @Override
    public boolean permit(ReqContext context, String operation, Map<String, Object> topoConf) {
        String principal = context.principal().getName();
        String user = this.ptol.toLocal(context.principal());
        HashSet<String> userGroups = new HashSet();
        if (this.groupMappingServiceProvider != null) {
            try {
                userGroups = this.groupMappingServiceProvider.getGroups(user);
            }
            catch (IOException e) {
                LOG.warn("Error while trying to fetch user groups", (Throwable)e);
            }
        }
        if (this.admins.contains(principal) || this.admins.contains(user) || this.checkUserGroupAllowed(userGroups, this.adminsGroups).booleanValue()) {
            return true;
        }
        if (this.nimbus.contains(principal) || this.nimbus.contains(user)) {
            return this.nimbusCommands.contains(operation);
        }
        return this.topoCommands.contains(operation) && topoConf != null && this.checkTopoPermission(principal, user, userGroups, topoConf, "topology.users", "topology.groups") != false;
    }

    private Boolean checkTopoPermission(String principal, String user, Set<String> userGroups, Map<String, Object> topoConf, String userConfigKey, String groupConfigKey) {
        HashSet<String> configuredUsers = new HashSet<String>();
        if (topoConf.containsKey(userConfigKey)) {
            configuredUsers.addAll(ObjectReader.getStrings(topoConf.get(userConfigKey)));
        }
        if (configuredUsers.contains(principal) || configuredUsers.contains(user)) {
            return true;
        }
        HashSet<String> configuredGroups = new HashSet<String>();
        if (topoConf.containsKey(groupConfigKey)) {
            configuredGroups.addAll(ObjectReader.getStrings(topoConf.get(groupConfigKey)));
        }
        return this.checkUserGroupAllowed(userGroups, configuredGroups);
    }

    private Boolean checkUserGroupAllowed(Set<String> userGroups, Set<String> configuredGroups) {
        if (userGroups.size() > 0 && configuredGroups.size() > 0) {
            for (String tgroup : configuredGroups) {
                if (!userGroups.contains(tgroup)) continue;
                return true;
            }
        }
        return false;
    }
}

