/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.shade.com.google.common.collect.ArrayListMultimap;
import org.apache.storm.shade.com.google.common.collect.Multimap;
import org.apache.storm.shade.com.google.common.collect.Multimaps;
import org.apache.storm.streams.GroupingInfo;
import org.apache.storm.topology.IComponent;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.tuple.Fields;

abstract class Node
implements Serializable {
    protected final Fields outputFields;
    private final Set<String> outputStreams;
    private final Multimap<Node, String> parentStreams = ArrayListMultimap.create();
    protected GroupingInfo groupingInfo;
    protected String componentId;
    protected int parallelism;
    private boolean windowed;
    private boolean emitsPair;

    Node(Set<String> outputStreams, Fields outputFields, String componentId, int parallelism, GroupingInfo groupingInfo) {
        this.outputStreams = new HashSet<String>(outputStreams);
        this.outputFields = outputFields;
        this.componentId = componentId;
        this.parallelism = parallelism;
        this.groupingInfo = groupingInfo;
    }

    Node(String outputStream, Fields outputFields, String componentId, int parallelism, GroupingInfo groupingInfo) {
        this(Collections.singleton(outputStream), outputFields, componentId, parallelism, groupingInfo);
    }

    Node(String outputStream, Fields outputFields, String componentId, GroupingInfo groupingInfo) {
        this(outputStream, outputFields, componentId, 1, groupingInfo);
    }

    Node(String outputStream, Fields outputFields) {
        this(outputStream, outputFields, null);
    }

    Node(String outputStream, Fields outputFields, GroupingInfo groupingInfo) {
        this(outputStream, outputFields, null, groupingInfo);
    }

    static Fields getOutputFields(IComponent component, String streamId) {
        OutputFieldsGetter getter = new OutputFieldsGetter();
        component.declareOutputFields(getter);
        Map<String, StreamInfo> fieldsDeclaration = getter.getFieldsDeclaration();
        if (fieldsDeclaration != null && fieldsDeclaration.containsKey(streamId)) {
            return new Fields(fieldsDeclaration.get(streamId).get_output_fields());
        }
        return new Fields(new String[0]);
    }

    public Fields getOutputFields() {
        return this.outputFields;
    }

    GroupingInfo getGroupingInfo() {
        return this.groupingInfo;
    }

    void setGroupingInfo(GroupingInfo groupingInfo) {
        this.groupingInfo = groupingInfo;
    }

    String getComponentId() {
        return this.componentId;
    }

    void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    int getParallelism() {
        return this.parallelism;
    }

    void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    void addParentStream(Node parent, String streamId) {
        this.parentStreams.put((Object)parent, (Object)streamId);
    }

    void removeParentStreams(Node parent) {
        this.parentStreams.removeAll((Object)parent);
    }

    Set<String> getOutputStreams() {
        return Collections.unmodifiableSet(this.outputStreams);
    }

    public boolean isWindowed() {
        return this.windowed;
    }

    public void setWindowed(boolean windowed) {
        this.windowed = windowed;
    }

    Collection<String> getParentStreams(Node parent) {
        return this.parentStreams.get((Object)parent);
    }

    Set<Node> getParents(String stream) {
        Multimap rev = Multimaps.invertFrom(this.parentStreams, (Multimap)ArrayListMultimap.create());
        return new HashSet<Node>(rev.get((Object)stream));
    }

    Set<Node> getParents() {
        return this.parentStreams.keySet();
    }

    void addOutputStream(String streamId) {
        this.outputStreams.add(streamId);
    }

    public boolean emitsPair() {
        return this.emitsPair;
    }

    public void setEmitsPair(boolean emitsPair) {
        this.emitsPair = emitsPair;
    }

    public String toString() {
        return "Node{outputStreams=" + String.valueOf(this.outputStreams) + ", outputFields=" + String.valueOf(this.outputFields) + ", groupingInfo=" + String.valueOf(this.groupingInfo) + ", componentId='" + this.componentId + "', parallelism=" + this.parallelism + ", parentStreams=" + String.valueOf(this.parentStreams) + ", windowed=" + this.windowed + ", emitsPair=" + this.emitsPair + "}";
    }
}

