/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.ArrayList;
import org.apache.storm.shade.com.google.common.collect.ArrayListMultimap;
import org.apache.storm.shade.com.google.common.collect.Multimap;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.processors.BaseProcessor;
import org.apache.storm.streams.processors.BatchProcessor;

public class CoGroupByKeyProcessor<K, V1, V2>
extends BaseProcessor<Pair<K, ?>>
implements BatchProcessor {
    private final String firstStream;
    private final String secondStream;
    private final Multimap<K, V1> firstMap = ArrayListMultimap.create();
    private final Multimap<K, V2> secondMap = ArrayListMultimap.create();

    public CoGroupByKeyProcessor(String firstStream, String secondStream) {
        this.firstStream = firstStream;
        this.secondStream = secondStream;
    }

    @Override
    public void execute(Pair<K, ?> input, String sourceStream) {
        K key = input.getFirst();
        if (sourceStream.equals(this.firstStream)) {
            Object val = input.getSecond();
            this.firstMap.put(key, val);
        } else if (sourceStream.equals(this.secondStream)) {
            Object val = input.getSecond();
            this.secondMap.put(key, val);
        }
        if (!this.context.isWindowed()) {
            this.forwardValues();
        }
    }

    @Override
    public void finish() {
        this.forwardValues();
        this.firstMap.clear();
        this.secondMap.clear();
    }

    private void forwardValues() {
        this.firstMap.asMap().forEach((key, values) -> this.context.forward(Pair.of(key, Pair.of(new ArrayList(values), this.secondMap.removeAll(key)))));
        this.secondMap.asMap().forEach((key, values) -> this.context.forward(Pair.of(key, Pair.of(this.firstMap.removeAll(key), new ArrayList(values)))));
    }
}

