/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.FreshCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class PartitionPersistProcessor
implements TridentProcessor {
    StateUpdater updater;
    State state;
    String stateId;
    TridentContext context;
    Fields inputFields;
    TridentTupleView.ProjectionFactory projection;
    FreshCollector collector;

    public PartitionPersistProcessor(String stateId, Fields inputFields, StateUpdater updater) {
        this.updater = updater;
        this.stateId = stateId;
        this.inputFields = inputFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Partition persist operation can only have one parent");
        }
        this.context = tridentContext;
        this.state = (State)context.getTaskData(this.stateId);
        this.projection = new TridentTupleView.ProjectionFactory(parents.get(0), this.inputFields);
        this.collector = new FreshCollector(tridentContext);
        this.updater.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this.projection));
    }

    @Override
    public void cleanup() {
        this.updater.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        processorContext.state[this.context.getStateIndex()] = new ArrayList();
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        ((List)processorContext.state[this.context.getStateIndex()]).add(this.projection.create(tuple));
    }

    @Override
    public void flush() {
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        this.collector.setContext(processorContext);
        Object batchId = processorContext.batchId;
        List buffer = (List)processorContext.state[this.context.getStateIndex()];
        if (buffer.size() > 0) {
            Long txid = null;
            if (batchId instanceof TransactionAttempt) {
                txid = ((TransactionAttempt)batchId).getTransactionId();
            }
            this.state.beginCommit(txid);
            this.updater.updateState(this.state, buffer, this.collector);
            this.state.commit(txid);
        }
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this.collector.getOutputFactory();
    }
}

