/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.localizer;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.localizer.LocallyCachedBlob;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizedResourceRetentionSet {
    public static final Logger LOG = LoggerFactory.getLogger(LocalizedResourceRetentionSet.class);
    @VisibleForTesting
    final SortedMap<LocallyCachedBlob, Map<String, ? extends LocallyCachedBlob>> noReferences;
    private long currentSize;
    private long targetSize;

    LocalizedResourceRetentionSet(long targetSize) {
        this(targetSize, new LRUComparator());
    }

    LocalizedResourceRetentionSet(long targetSize, Comparator<? super LocallyCachedBlob> cmp) {
        this(targetSize, new TreeMap<LocallyCachedBlob, Map<String, ? extends LocallyCachedBlob>>(cmp));
    }

    LocalizedResourceRetentionSet(long targetSize, SortedMap<LocallyCachedBlob, Map<String, ? extends LocallyCachedBlob>> retain) {
        this.noReferences = retain;
        this.targetSize = targetSize;
    }

    protected int getSizeWithNoReferences() {
        return this.noReferences.size();
    }

    public void addResources(ConcurrentMap<String, ? extends LocallyCachedBlob> blobs) {
        for (LocallyCachedBlob b : blobs.values()) {
            this.currentSize += b.getSizeOnDisk();
            if (b.isUsed()) {
                LOG.debug("NOT going to clean up {}, {} depends on it", (Object)b.getKey(), b.getDependencies());
                continue;
            }
            LOG.debug("Possibly going to clean up {} ts {} size {}", new Object[]{b.getKey(), b.getLastUsed(), b.getSizeOnDisk()});
            this.noReferences.put(b, blobs);
        }
    }

    public Set<LocallyCachedBlob> cleanup(ClientBlobStore store) {
        Map<String, ? extends LocallyCachedBlob> set2;
        LocallyCachedBlob resource;
        Map.Entry<LocallyCachedBlob, Map<String, ? extends LocallyCachedBlob>> rsrc;
        HashSet<LocallyCachedBlob> deleted = new HashSet<LocallyCachedBlob>();
        LOG.debug("cleanup target size: {} current size is: {}", (Object)this.targetSize, (Object)this.currentSize);
        long bytesOver = this.currentSize - this.targetSize;
        Iterator<Map.Entry<LocallyCachedBlob, Map<String, ? extends LocallyCachedBlob>>> i = this.noReferences.entrySet().iterator();
        while (i.hasNext()) {
            rsrc = i.next();
            resource = rsrc.getKey();
            try {
                if (store.isRemoteBlobExists(resource.getKey()) || !this.removeBlob(resource, set2 = rsrc.getValue())) continue;
                bytesOver -= resource.getSizeOnDisk();
                LOG.info("Deleted blob: {} (REMOVED FROM CLUSTER).", (Object)resource.getKey());
                deleted.add(resource);
                i.remove();
            }
            catch (AuthorizationException set2) {}
        }
        i = this.noReferences.entrySet().iterator();
        while (bytesOver > 0L && i.hasNext()) {
            rsrc = i.next();
            resource = rsrc.getKey();
            if (!this.removeBlob(resource, set2 = rsrc.getValue())) continue;
            bytesOver -= resource.getSizeOnDisk();
            LOG.info("Deleted blob: {} (OVER SIZE LIMIT).", (Object)resource.getKey());
            deleted.add(resource);
            i.remove();
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeBlob(LocallyCachedBlob blob, Map<String, ? extends LocallyCachedBlob> blobs) {
        LocallyCachedBlob locallyCachedBlob = blob;
        synchronized (locallyCachedBlob) {
            if (!blob.isUsed()) {
                try {
                    blob.completelyRemove();
                }
                catch (Exception e) {
                    LOG.warn("Tried to remove {} but failed with", (Object)blob, (Object)e);
                }
                blobs.remove(blob.getKey());
                return true;
            }
            return false;
        }
    }

    public String toString() {
        return "Cache: " + this.currentSize;
    }

    static class LRUComparator
    implements Comparator<LocallyCachedBlob> {
        LRUComparator() {
        }

        @Override
        public int compare(LocallyCachedBlob r1, LocallyCachedBlob r2) {
            long ret = r1.getLastUsed() - r2.getLastUsed();
            if (0L == ret) {
                return System.identityHashCode(r1) - System.identityHashCode(r2);
            }
            return ret > 0L ? 1 : -1;
        }
    }
}

