/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.util.Collection;
import org.apache.storm.metric.api.DataPoint;
import org.apache.storm.metric.api.IClusterMetricsConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingClusterMetricsConsumer
implements IClusterMetricsConsumer {
    public static final Logger LOG = LoggerFactory.getLogger(LoggingClusterMetricsConsumer.class);
    private static String padding = "                       ";

    @Override
    public void prepare(Object registrationArgument) {
    }

    @Override
    public void handleDataPoints(IClusterMetricsConsumer.ClusterInfo clusterInfo, Collection<DataPoint> dataPoints) {
        StringBuilder sb = new StringBuilder();
        String header = String.format("%d\t%15s\t%40s\t", clusterInfo.getTimestamp(), "<cluster>", "<cluster>");
        sb.append(header);
        this.logDataPoints(dataPoints, sb, header);
    }

    @Override
    public void handleDataPoints(IClusterMetricsConsumer.SupervisorInfo supervisorInfo, Collection<DataPoint> dataPoints) {
        StringBuilder sb = new StringBuilder();
        String header = String.format("%d\t%15s\t%40s\t", supervisorInfo.getTimestamp(), supervisorInfo.getSrcSupervisorHost(), supervisorInfo.getSrcSupervisorId());
        sb.append(header);
        for (DataPoint p : dataPoints) {
            sb.delete(header.length(), sb.length());
            sb.append(p.getName()).append(padding).delete(header.length() + 23, sb.length()).append("\t").append(p.getValue());
            LOG.info(sb.toString());
        }
    }

    @Override
    public void cleanup() {
    }

    private void logDataPoints(Collection<DataPoint> dataPoints, StringBuilder sb, String header) {
        for (DataPoint p : dataPoints) {
            sb.delete(header.length(), sb.length());
            sb.append(p.getName()).append(padding).delete(header.length() + 23, sb.length()).append("\t").append(p.getValue());
            LOG.info(sb.toString());
        }
    }
}

