/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.RasNodes;
import org.apache.storm.scheduler.resource.SchedulingResult;
import org.apache.storm.scheduler.resource.SchedulingStatus;
import org.apache.storm.scheduler.resource.strategies.scheduling.BaseResourceAwareStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.ConstraintSolverConfig;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.ExecSorterByConstraintSeverity;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintSolverStrategy
extends BaseResourceAwareStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ConstraintSolverStrategy.class);
    private ConstraintSolverConfig constraintSolverConfig;

    @Override
    protected void prepareForScheduling(Cluster cluster, TopologyDetails topologyDetails) {
        super.prepareForScheduling(cluster, topologyDetails);
        this.constraintSolverConfig = new ConstraintSolverConfig(topologyDetails);
        this.setExecSorter(new ExecSorterByConstraintSeverity(cluster, topologyDetails));
    }

    @Override
    protected SchedulingResult checkSchedulingFeasibility() {
        SchedulingResult res = super.checkSchedulingFeasibility();
        if (res != null) {
            return res;
        }
        if (!this.isSchedulingFeasible()) {
            return SchedulingResult.failure(SchedulingStatus.FAIL_OTHER, "Scheduling not feasible!");
        }
        return null;
    }

    @Override
    protected boolean isExecAssignmentToWorkerValid(ExecutorDetails exec, WorkerSlot worker) {
        Map<String, Integer> maxNodeCoLocationCnts;
        Set<String> incompatibleComponents;
        if (!super.isExecAssignmentToWorkerValid(exec, worker)) {
            return false;
        }
        String execComp = (String)this.execToComp.get(exec);
        Map<String, Integer> compAssignmentCnts = this.searcherState.getCompAssignmentCntMapForWorker(worker);
        if (compAssignmentCnts != null && (incompatibleComponents = this.constraintSolverConfig.getIncompatibleComponentSets().get(execComp)) != null && !incompatibleComponents.isEmpty()) {
            for (String otherComp : compAssignmentCnts.keySet()) {
                if (!incompatibleComponents.contains(otherComp)) continue;
                LOG.debug("Topology {}, exec={} with comp={} has constraint violation with comp={} on worker={}", new Object[]{this.topoName, exec, execComp, otherComp, worker});
                return false;
            }
        }
        if ((maxNodeCoLocationCnts = this.constraintSolverConfig.getMaxNodeCoLocationCnts()).containsKey(execComp)) {
            int coLocationMaxCnt = maxNodeCoLocationCnts.get(execComp);
            RasNode node = this.nodes.getNodeById(worker.getNodeId());
            int compCntOnNode = this.searcherState.getComponentCntOnNode(node, execComp);
            if (compCntOnNode >= coLocationMaxCnt) {
                LOG.debug("Topology {}, exec={} with comp={} has MaxCoLocationCnt violation on node {}, count {} >= colocation count {}", new Object[]{this.topoName, exec, execComp, node.getId(), compCntOnNode, coLocationMaxCnt});
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting
    public static boolean validateSolution(Cluster cluster, TopologyDetails topo) {
        LOG.debug("Checking for a valid scheduling for topology {}...", (Object)topo.getName());
        if (cluster.getAssignmentById(topo.getId()) == null) {
            String err = "cluster.getAssignmentById(\"" + topo.getId() + "\") returned null";
            LOG.error(err);
            throw new AssertionError((Object)("No assignments for topologyId " + topo.getId()));
        }
        ConstraintSolverConfig constraintSolverConfig = new ConstraintSolverConfig(topo);
        Map<ExecutorDetails, String> execToComp = topo.getExecutorToComponent();
        HashMap<String, Map> nodeCompMap = new HashMap<String, Map>();
        HashMap workerToNodes = new HashMap();
        RasNodes.getAllNodesFrom(cluster).values().forEach(node -> node.getUsedSlots().forEach(workerSlot -> workerToNodes.put(workerSlot, node)));
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry<ExecutorDetails, WorkerSlot> entry : cluster.getAssignmentById(topo.getId()).getExecutorToSlot().entrySet()) {
            ExecutorDetails executorDetails = entry.getKey();
            String comp = execToComp.get(executorDetails);
            WorkerSlot worker2 = entry.getValue();
            RasNode node2 = (RasNode)workerToNodes.get(worker2);
            String nodeId = node2.getId();
            if (!constraintSolverConfig.getMaxNodeCoLocationCnts().containsKey(comp)) continue;
            int allowedColocationMaxCnt = constraintSolverConfig.getMaxNodeCoLocationCnts().get(comp);
            Map oneNodeCompMap = nodeCompMap.computeIfAbsent(nodeId, k -> new HashMap());
            oneNodeCompMap.put(comp, oneNodeCompMap.getOrDefault(comp, 0) + 1);
            if (allowedColocationMaxCnt >= (Integer)oneNodeCompMap.get(comp)) continue;
            String err = String.format("MaxNodeCoLocation: Component %s (exec=%s) on node %s, cnt %d > allowed %d", comp, executorDetails, nodeId, oneNodeCompMap.get(comp), allowedColocationMaxCnt);
            errors.add(err);
        }
        HashMap workerCompMap = new HashMap();
        cluster.getAssignmentById(topo.getId()).getExecutorToSlot().forEach((exec, worker) -> {
            String comp = (String)execToComp.get(exec);
            workerCompMap.computeIfAbsent(worker, k -> new HashSet()).add(comp);
        });
        for (Map.Entry entry : workerCompMap.entrySet()) {
            Set comps = (Set)entry.getValue();
            for (String comp1 : comps) {
                for (String comp2 : comps) {
                    if (comp1.equals(comp2) || !constraintSolverConfig.getIncompatibleComponentSets().containsKey(comp1) || !constraintSolverConfig.getIncompatibleComponentSets().get(comp1).contains(comp2)) continue;
                    String err = String.format("IncompatibleComponents: %s and %s on WorkerSlot: %s", comp1, comp2, entry.getKey());
                    errors.add(err);
                }
            }
        }
        SchedulerAssignment schedulerAssignment = cluster.getAssignmentById(topo.getId());
        HashMap<ExecutorDetails, WorkerSlot> hashMap = new HashMap<ExecutorDetails, WorkerSlot>();
        if (schedulerAssignment.getExecutorToSlot() != null) {
            hashMap.putAll(schedulerAssignment.getExecutorToSlot());
        }
        Map<String, RasNode> nodes = RasNodes.getAllNodesFrom(cluster);
        HashMap<RasNode, Collection> nodeToExecs = new HashMap<RasNode, Collection>();
        for (Map.Entry entry : hashMap.entrySet()) {
            String err;
            ExecutorDetails exec3 = (ExecutorDetails)entry.getKey();
            WorkerSlot worker3 = (WorkerSlot)entry.getValue();
            RasNode node3 = nodes.get(worker3.getNodeId());
            if (node3.getAvailableMemoryResources() < 0.0) {
                err = String.format("Resource Exhausted: Found node %s with negative available memory %,.2f", node3.getId(), node3.getAvailableMemoryResources());
                errors.add(err);
                continue;
            }
            if (node3.getAvailableCpuResources() < 0.0) {
                err = String.format("Resource Exhausted: Found node %s with negative available CPU %,.2f", node3.getId(), node3.getAvailableCpuResources());
                errors.add(err);
                continue;
            }
            nodeToExecs.computeIfAbsent(node3, k -> new HashSet()).add(exec3);
        }
        for (Map.Entry entry : nodeToExecs.entrySet()) {
            String err;
            RasNode node4 = (RasNode)entry.getKey();
            Collection execs = (Collection)entry.getValue();
            double cpuUsed = 0.0;
            double memoryUsed = 0.0;
            for (ExecutorDetails exec4 : execs) {
                cpuUsed += topo.getTotalCpuReqTask(exec4).doubleValue();
                memoryUsed += topo.getTotalMemReqTask(exec4).doubleValue();
            }
            if (node4.getAvailableCpuResources() != node4.getTotalCpuResources() - cpuUsed) {
                err = String.format("Incorrect CPU Resources: Node %s CPU available is %,.2f, expected %,.2f, Executors scheduled on node: %s", node4.getId(), node4.getAvailableCpuResources(), node4.getTotalCpuResources() - cpuUsed, execs);
                errors.add(err);
            }
            if (node4.getAvailableMemoryResources() == node4.getTotalMemoryResources() - memoryUsed) continue;
            err = String.format("Incorrect Memory Resources: Node %s Memory available is %,.2f, expected %,.2f, Executors scheduled on node: %s", node4.getId(), node4.getAvailableMemoryResources(), node4.getTotalMemoryResources() - memoryUsed, execs);
            errors.add(err);
        }
        if (!errors.isEmpty()) {
            LOG.error("Topology {} solution is invalid\n\t{}", (Object)topo.getName(), (Object)String.join((CharSequence)"\n\t", errors));
        }
        return errors.isEmpty();
    }

    private boolean isSchedulingFeasible() {
        int nodeCnt = this.nodes.getNodes().size();
        for (Map.Entry<String, Integer> entry : this.constraintSolverConfig.getMaxNodeCoLocationCnts().entrySet()) {
            String comp = entry.getKey();
            int maxCoLocationCnt = entry.getValue();
            int numExecs = ((Set)this.compToExecs.get(comp)).size();
            if (numExecs <= nodeCnt * maxCoLocationCnt) continue;
            LOG.error("Unsatisfiable constraint: Component: {} marked as spread has {} executors which is larger than number of nodes * maxCoLocationCnt: {} * {} ", new Object[]{comp, numExecs, nodeCnt, maxCoLocationCnt});
            return false;
        }
        return true;
    }
}

