/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListIterator
implements Iterator<Node> {
    private final NodeList nodeList;
    private int index;

    public NodeListIterator(Node node) {
        Objects.requireNonNull(node, "node");
        this.nodeList = node.getChildNodes();
    }

    public NodeListIterator(NodeList nodeList) {
        this.nodeList = Objects.requireNonNull(nodeList, "nodeList");
    }

    @Override
    public boolean hasNext() {
        return this.nodeList != null && this.index < this.nodeList.getLength();
    }

    @Override
    public Node next() {
        if (this.nodeList != null && this.index < this.nodeList.getLength()) {
            return this.nodeList.item(this.index++);
        }
        throw new NoSuchElementException("underlying nodeList has no more elements");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported for a NodeListIterator.");
    }
}

