/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.internal;

import java.io.Closeable;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.metric.internal.MetricStatTimer;

public class RateTracker
implements Closeable {
    private final int bucketSizeMillis;
    private final long[] bucketTime;
    private final long[] oldBuckets;
    private final AtomicLong bucketStart;
    private final AtomicLong currentBucket;
    private final TimerTask task;

    public RateTracker(int validTimeWindowInMils, int numBuckets) {
        this(validTimeWindowInMils, numBuckets, -1L);
    }

    RateTracker(int validTimeWindowInMils, int numBuckets, long startTime) {
        numBuckets = Math.max(numBuckets, 1);
        this.bucketSizeMillis = validTimeWindowInMils / numBuckets;
        if (this.bucketSizeMillis < 1) {
            throw new IllegalArgumentException("validTimeWindowInMilis and numOfSildes cause each slide to have a window that is too small");
        }
        this.bucketTime = new long[numBuckets - 1];
        this.oldBuckets = new long[numBuckets - 1];
        this.bucketStart = new AtomicLong(startTime >= 0L ? startTime : System.currentTimeMillis());
        this.currentBucket = new AtomicLong(0L);
        if (startTime < 0L) {
            this.task = new Fresher();
            MetricStatTimer.timer.scheduleAtFixedRate(this.task, this.bucketSizeMillis, (long)this.bucketSizeMillis);
        } else {
            this.task = null;
        }
    }

    public void notify(long count) {
        this.currentBucket.addAndGet(count);
    }

    public synchronized double reportRate() {
        return this.reportRate(System.currentTimeMillis());
    }

    synchronized double reportRate(long currentTime) {
        long duration = Math.max(1L, currentTime - this.bucketStart.get());
        long events = this.currentBucket.get();
        for (int i = 0; i < this.oldBuckets.length; ++i) {
            events += this.oldBuckets[i];
            duration += this.bucketTime[i];
        }
        return (double)events * 1000.0 / (double)duration;
    }

    @Override
    public void close() {
        if (this.task != null) {
            this.task.cancel();
        }
    }

    final void forceRotate(int numToEclipse, long interval) {
        long time = this.bucketStart.get();
        for (int i = 0; i < numToEclipse; ++i) {
            this.rotateBuckets(time += interval);
        }
    }

    private synchronized void rotateBuckets(long time) {
        long timeSpent = time - this.bucketStart.getAndSet(time);
        long currentVal = this.currentBucket.getAndSet(0L);
        for (int i = 0; i < this.oldBuckets.length; ++i) {
            long tmpTime = this.bucketTime[i];
            this.bucketTime[i] = timeSpent;
            timeSpent = tmpTime;
            long cnt = this.oldBuckets[i];
            this.oldBuckets[i] = currentVal;
            currentVal = cnt;
        }
    }

    private class Fresher
    extends TimerTask {
        private Fresher() {
        }

        @Override
        public void run() {
            RateTracker.this.rotateBuckets(System.currentTimeMillis());
        }
    }
}

