/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.spout;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.generated.ShellComponent;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.rpc.IShellMetric;
import org.apache.storm.multilang.ShellMsg;
import org.apache.storm.multilang.SpoutMsg;
import org.apache.storm.shade.com.google.common.util.concurrent.MoreExecutors;
import org.apache.storm.spout.ISpout;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ShellLogHandler;
import org.apache.storm.utils.ShellProcess;
import org.apache.storm.utils.ShellUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellSpout
implements ISpout {
    public static final Logger LOG = LoggerFactory.getLogger(ShellSpout.class);
    private static final long serialVersionUID = 5982357019665454L;
    private SpoutOutputCollector collector;
    private String[] command;
    private Map<String, String> env = new HashMap<String, String>();
    private ShellLogHandler logHandler;
    private ShellProcess process;
    private volatile boolean running = true;
    private volatile RuntimeException exception;
    private TopologyContext context;
    private SpoutMsg spoutMsg;
    private int workerTimeoutMills;
    private ScheduledExecutorService heartBeatExecutorService;
    private AtomicLong lastHeartbeatTimestamp = new AtomicLong();
    private AtomicBoolean waitingOnSubprocess = new AtomicBoolean(false);
    private boolean changeDirectory = true;

    public ShellSpout(ShellComponent component) {
        this(component.get_execution_command(), component.get_script());
    }

    public ShellSpout(String ... command) {
        this.command = command;
    }

    public ShellSpout setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    public boolean shouldChangeChildCWD() {
        return this.changeDirectory;
    }

    public void changeChildCWD(boolean changeDirectory) {
        this.changeDirectory = changeDirectory;
    }

    @Override
    public void open(Map<String, Object> topoConf, TopologyContext context, SpoutOutputCollector collector) {
        this.collector = collector;
        this.context = context;
        this.workerTimeoutMills = topoConf.containsKey("topology.subprocess.timeout.secs") ? 1000 * ObjectReader.getInt(topoConf.get("topology.subprocess.timeout.secs")) : 1000 * ObjectReader.getInt(topoConf.get("supervisor.worker.timeout.secs"));
        this.process = new ShellProcess(this.command);
        if (!this.env.isEmpty()) {
            this.process.setEnv(this.env);
        }
        Number subpid = this.process.launch(topoConf, context, this.changeDirectory);
        LOG.info("Launched subprocess with pid " + String.valueOf(subpid));
        this.logHandler = ShellUtils.getLogHandler(topoConf);
        this.logHandler.setUpContext(ShellSpout.class, this.process, this.context);
        this.heartBeatExecutorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
    }

    @Override
    public void close() {
        this.heartBeatExecutorService.shutdownNow();
        this.process.destroy();
        this.running = false;
    }

    @Override
    public void nextTuple() {
        this.sendSyncCommand("next", "");
    }

    @Override
    public void ack(Object msgId) {
        this.sendSyncCommand("ack", msgId);
    }

    @Override
    public void fail(Object msgId) {
        this.sendSyncCommand("fail", msgId);
    }

    private void sendSyncCommand(String command, Object msgId) {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.spoutMsg == null) {
            this.spoutMsg = new SpoutMsg();
        }
        this.spoutMsg.setCommand(command);
        this.spoutMsg.setId(msgId);
        this.querySubprocess();
    }

    private void handleMetrics(ShellMsg shellMsg) {
        String name = shellMsg.getMetricName();
        if (name.isEmpty()) {
            throw new RuntimeException("Receive Metrics name is empty");
        }
        IMetric metric = this.context.getRegisteredMetricByName(name);
        if (metric == null) {
            throw new RuntimeException("Could not find metric by name[" + name + "] ");
        }
        if (!(metric instanceof IShellMetric)) {
            throw new RuntimeException("Metric[" + name + "] is not IShellMetric, can not call by RPC");
        }
        IShellMetric shellMetric = (IShellMetric)metric;
        Object paramsObj = shellMsg.getMetricParams();
        try {
            shellMetric.updateMetricFromRPC(paramsObj);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void querySubprocess() {
        try {
            this.markWaitingSubprocess();
            this.process.writeSpoutMsg(this.spoutMsg);
            while (true) {
                ShellMsg shellMsg;
                String command;
                if ((command = (shellMsg = this.process.readShellMsg()).getCommand()) == null) {
                    throw new IllegalArgumentException("Command not found in spout message: " + String.valueOf(shellMsg));
                }
                this.setHeartbeat();
                if (command.equals("sync")) {
                    return;
                }
                if (command.equals("log")) {
                    this.logHandler.log(shellMsg);
                    continue;
                }
                if (command.equals("error")) {
                    this.handleError(shellMsg.getMsg());
                    continue;
                }
                if (command.equals("emit")) {
                    String stream = shellMsg.getStream();
                    Long task = shellMsg.getTask();
                    List<Object> tuple = shellMsg.getTuple();
                    Object messageId = shellMsg.getId();
                    if (task == 0L) {
                        List<Integer> outtasks = this.collector.emit(stream, tuple, messageId);
                        if (!shellMsg.areTaskIdsNeeded()) continue;
                        this.process.writeTaskIds(outtasks);
                        continue;
                    }
                    this.collector.emitDirect((int)task.longValue(), stream, tuple, messageId);
                    continue;
                }
                if (!command.equals("metrics")) throw new RuntimeException("Unknown command received: " + command);
                this.handleMetrics(shellMsg);
                continue;
                break;
            }
        }
        catch (Exception e) {
            String processInfo = this.process.getProcessInfoString() + this.process.getProcessTerminationInfoString();
            throw new RuntimeException(processInfo, e);
        }
        finally {
            this.completedWaitingSubprocess();
        }
    }

    private void handleError(String msg) {
        this.collector.reportError(new Exception("Shell Process Exception: " + msg));
    }

    @Override
    public void activate() {
        LOG.info("Start checking heartbeat...");
        this.setHeartbeat();
        if (this.heartBeatExecutorService.isShutdown()) {
            this.heartBeatExecutorService = MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1));
        }
        this.heartBeatExecutorService.scheduleAtFixedRate(new SpoutHeartbeatTimerTask(this), 1L, 1L, TimeUnit.SECONDS);
        this.sendSyncCommand("activate", "");
    }

    @Override
    public void deactivate() {
        this.sendSyncCommand("deactivate", "");
        this.heartBeatExecutorService.shutdownNow();
    }

    private void setHeartbeat() {
        this.lastHeartbeatTimestamp.set(System.currentTimeMillis());
    }

    private long getLastHeartbeat() {
        return this.lastHeartbeatTimestamp.get();
    }

    private void markWaitingSubprocess() {
        this.setHeartbeat();
        this.waitingOnSubprocess.compareAndSet(false, true);
    }

    private void completedWaitingSubprocess() {
        this.waitingOnSubprocess.compareAndSet(true, false);
    }

    private void die(Throwable exception) {
        String processInfo = this.process.getProcessInfoString() + this.process.getProcessTerminationInfoString();
        this.exception = new RuntimeException(processInfo, exception);
        String message = String.format("Halting process: ShellSpout died. Command: %s, ProcessInfo %s", Arrays.toString(this.command), processInfo);
        LOG.error(message, exception);
        this.collector.reportError(exception);
        if (this.running || exception instanceof Error) {
            System.exit(11);
        }
    }

    private class SpoutHeartbeatTimerTask
    extends TimerTask {
        private ShellSpout spout;

        SpoutHeartbeatTimerTask(ShellSpout spout) {
            this.spout = spout;
        }

        @Override
        public void run() {
            long lastHeartbeat = ShellSpout.this.getLastHeartbeat();
            long currentTimestamp = System.currentTimeMillis();
            boolean isWaitingOnSubprocess = ShellSpout.this.waitingOnSubprocess.get();
            LOG.debug("last heartbeat : {}, waiting subprocess now : {}, worker timeout (ms) : {}", new Object[]{lastHeartbeat, isWaitingOnSubprocess, ShellSpout.this.workerTimeoutMills});
            if (isWaitingOnSubprocess && currentTimestamp - lastHeartbeat > (long)ShellSpout.this.workerTimeoutMills) {
                this.spout.die(new RuntimeException("subprocess heartbeat timeout"));
            }
        }
    }
}

