/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.state;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.storm.serialization.KryoTupleDeserializer;
import org.apache.storm.serialization.KryoTupleSerializer;
import org.apache.storm.serialization.SerializationFactory;
import org.apache.storm.state.Serializer;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.TupleImpl;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class DefaultStateSerializer<T>
implements Serializer<T> {
    private final TopologyContext context;
    private final Map<String, Object> topoConf;
    private final List<String> registrations = new ArrayList<String>();
    private final ThreadLocal<Kryo> kryo = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo obj = new Kryo();
            obj.setRegistrationRequired(false);
            if (DefaultStateSerializer.this.context != null && DefaultStateSerializer.this.topoConf != null) {
                KryoTupleSerializer ser = new KryoTupleSerializer(DefaultStateSerializer.this.topoConf, DefaultStateSerializer.this.context);
                KryoTupleDeserializer deser = new KryoTupleDeserializer(DefaultStateSerializer.this.topoConf, DefaultStateSerializer.this.context);
                obj.register(TupleImpl.class, (com.esotericsoftware.kryo.Serializer)new TupleSerializer(ser, deser));
            }
            if (!DefaultStateSerializer.this.registrations.isEmpty()) {
                SerializationFactory.register(obj, DefaultStateSerializer.this.registrations);
            }
            obj.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
            return obj;
        }
    };
    private final ThreadLocal<Output> output = new ThreadLocal<Output>(){

        @Override
        protected Output initialValue() {
            return new Output(2000, 2000000000);
        }
    };

    public DefaultStateSerializer(Map<String, Object> topoConf, TopologyContext context, List<Class<?>> classesToRegister) {
        this.context = context;
        this.topoConf = topoConf;
        this.registrations.addAll(classesToRegister.stream().map(Class::getName).collect(Collectors.toSet()));
        this.registrations.addAll(topoConf.getOrDefault("topology.state.kryo.register", Collections.emptyList()));
        this.registrations.add(Optional.class.getName());
    }

    public DefaultStateSerializer(Map<String, Object> topoConf, TopologyContext context) {
        this(topoConf, context, Collections.emptyList());
    }

    public DefaultStateSerializer() {
        this(Collections.emptyMap(), null);
    }

    @Override
    public byte[] serialize(T obj) {
        this.output.get().reset();
        this.kryo.get().writeClassAndObject(this.output.get(), obj);
        return this.output.get().toBytes();
    }

    @Override
    public T deserialize(byte[] b) {
        Input input = new Input(b);
        return (T)this.kryo.get().readClassAndObject(input);
    }

    private static class TupleSerializer
    extends com.esotericsoftware.kryo.Serializer<TupleImpl> {
        private final KryoTupleSerializer tupleSerializer;
        private final KryoTupleDeserializer tupleDeserializer;

        TupleSerializer(KryoTupleSerializer tupleSerializer, KryoTupleDeserializer tupleDeserializer) {
            this.tupleSerializer = tupleSerializer;
            this.tupleDeserializer = tupleDeserializer;
        }

        public void write(Kryo kryo, Output output, TupleImpl tuple) {
            byte[] bytes = this.tupleSerializer.serialize(tuple);
            output.writeInt(bytes.length);
            output.write(bytes);
        }

        public TupleImpl read(Kryo kryo, Input input, Class<? extends TupleImpl> type) {
            int length = input.readInt();
            byte[] bytes = input.readBytes(length);
            return this.tupleDeserializer.deserialize(bytes);
        }
    }
}

