/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import org.apache.storm.state.KeyValueState;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.operations.StateUpdater;
import org.apache.storm.streams.processors.BaseProcessor;
import org.apache.storm.streams.processors.StatefulProcessor;

public class UpdateStateByKeyProcessor<K, V, R>
extends BaseProcessor<Pair<K, V>>
implements StatefulProcessor<K, R> {
    private final StateUpdater<V, R> stateUpdater;
    private KeyValueState<K, R> keyValueState;

    public UpdateStateByKeyProcessor(StateUpdater<V, R> stateUpdater) {
        this.stateUpdater = stateUpdater;
    }

    @Override
    public void initState(KeyValueState<K, R> keyValueState) {
        this.keyValueState = keyValueState;
    }

    @Override
    protected void execute(Pair<K, V> input) {
        K key = input.getFirst();
        V val = input.getSecond();
        R agg = this.keyValueState.get(key);
        if (agg == null) {
            agg = this.stateUpdater.init();
        }
        R newAgg = this.stateUpdater.apply(agg, val);
        this.keyValueState.put(key, newAgg);
        this.context.forward(Pair.of(key, newAgg));
    }
}

