/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionPolicy;
import org.apache.storm.windowing.WindowLifecycleListener;
import org.apache.storm.windowing.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulWindowManager<T>
extends WindowManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(StatefulWindowManager.class);

    public StatefulWindowManager(WindowLifecycleListener<T> lifecycleListener) {
        super(lifecycleListener);
    }

    public StatefulWindowManager(WindowLifecycleListener<T> lifecycleListener, Collection<Event<T>> queue) {
        super(lifecycleListener, queue);
    }

    private static <T> Iterator<T> expiringIterator(final Iterator<T> inner, final IteratorStatus status) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                if (status.isValid()) {
                    return inner.hasNext();
                }
                throw new IllegalStateException("Stale iterator, the iterator is valid only within the corresponding execute");
            }

            @Override
            public T next() {
                if (status.isValid()) {
                    return inner.next();
                }
                throw new IllegalStateException("Stale iterator, the iterator is valid only within the corresponding execute");
            }
        };
    }

    @Override
    protected void compactWindow() {
    }

    @Override
    public boolean onTrigger() {
        final Supplier<Iterator> scanEventsStateful = this::scanEventsStateful;
        final Iterator it = scanEventsStateful.get();
        boolean hasEvents = it.hasNext();
        if (hasEvents) {
            final IteratorStatus status = new IteratorStatus();
            LOG.debug("invoking windowLifecycleListener onActivation with iterator");
            Supplier wrapper = new Supplier<Iterator<T>>(){
                Iterator<T> initial;
                {
                    this.initial = it;
                }

                @Override
                public Iterator<T> get() {
                    if (status.isValid()) {
                        Iterator res;
                        if (this.initial != null) {
                            res = this.initial;
                            this.initial = null;
                        } else {
                            res = (Iterator)scanEventsStateful.get();
                        }
                        return StatefulWindowManager.expiringIterator(res, status);
                    }
                    throw new IllegalStateException("Stale window, the window is valid only within the corresponding execute");
                }
            };
            this.windowLifecycleListener.onActivation(wrapper, null, null, this.evictionPolicy.getContext().getReferenceTime());
            status.invalidate();
        } else {
            LOG.debug("No events in the window, skipping onActivation");
        }
        this.triggerPolicy.reset();
        return hasEvents;
    }

    private Iterator<T> scanEventsStateful() {
        LOG.debug("Scan events, eviction policy {}", (Object)this.evictionPolicy);
        this.evictionPolicy.reset();
        Iterator it = new Iterator<T>(){
            private Iterator<Event<T>> inner;
            private T windowEvent;
            private boolean stopped;
            {
                this.inner = StatefulWindowManager.this.queue.iterator();
            }

            @Override
            public boolean hasNext() {
                while (!this.stopped && this.windowEvent == null && this.inner.hasNext()) {
                    Event cur = this.inner.next();
                    EvictionPolicy.Action action = StatefulWindowManager.this.evictionPolicy.evict(cur);
                    if (action == EvictionPolicy.Action.EXPIRE) {
                        this.inner.remove();
                        continue;
                    }
                    if (action == EvictionPolicy.Action.STOP) {
                        this.stopped = true;
                        continue;
                    }
                    if (action != EvictionPolicy.Action.PROCESS) continue;
                    this.windowEvent = cur.get();
                }
                return this.windowEvent != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object res = this.windowEvent;
                this.windowEvent = null;
                return res;
            }
        };
        return it;
    }

    private static class IteratorStatus {
        private boolean valid = true;

        private IteratorStatus() {
        }

        void invalidate() {
            this.valid = false;
        }

        boolean isValid() {
            return this.valid;
        }
    }
}

