/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.jgrapht.experimental.equivalence;

import java.util.HashSet;
import java.util.Set;
import org.apache.storm.shade.org.jgrapht.experimental.equivalence.EquivalenceComparator;

public class EquivalenceSet<E, C> {
    protected EquivalenceComparator<? super E, ? super C> eqComparator;
    protected C comparatorContext;
    protected Set<E> elementsSet;

    public EquivalenceSet(E aElement, EquivalenceComparator<? super E, ? super C> aEqComparator, C aComparatorContext) {
        this.eqComparator = aEqComparator;
        this.comparatorContext = aComparatorContext;
        this.elementsSet = new HashSet();
        this.elementsSet.add(aElement);
    }

    public E getRepresentative() {
        return this.elementsSet.iterator().next();
    }

    public C getContext() {
        return this.comparatorContext;
    }

    public int size() {
        return this.elementsSet.size();
    }

    public void add(E element) {
        this.elementsSet.add(element);
    }

    public boolean equivalentTo(E aOther, C aOtherContext) {
        boolean result = this.eqComparator.equivalenceCompare(this.getRepresentative(), aOther, this.comparatorContext, aOtherContext);
        return result;
    }

    public boolean equals(Object other) {
        Object otherRepresentative = null;
        Object otherContext = null;
        if (!(other instanceof EquivalenceSet)) {
            throw new ClassCastException("can check equal() only of EqualityGroup");
        }
        otherRepresentative = ((EquivalenceSet)other).getRepresentative();
        otherContext = ((EquivalenceSet)other).getContext();
        boolean result = this.eqComparator.equivalenceCompare(this.getRepresentative(), otherRepresentative, this.comparatorContext, otherContext);
        return result;
    }

    public int hashCode() {
        int result = this.eqComparator.equivalenceHashcode(this.getRepresentative(), this.comparatorContext);
        return result;
    }

    public String toString() {
        return "Eq.Group=" + this.elementsSet.toString();
    }

    public Object[] toArray() {
        return this.elementsSet.toArray();
    }
}

