/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc.webapp;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.HashMap;
import net.minidev.json.JSONValue;
import org.apache.storm.generated.DRPCExecutionException;

@Provider
public class DRPCExceptionMapper
implements ExceptionMapper<DRPCExecutionException> {
    public Response toResponse(DRPCExecutionException ex) {
        Response.ResponseBuilder builder = Response.status((int)500);
        switch (ex.get_type()) {
            case FAILED_REQUEST: {
                builder.status(400);
                break;
            }
            case SERVER_SHUTDOWN: {
                builder.status(503);
                break;
            }
            case SERVER_TIMEOUT: {
                builder.status(504);
                break;
            }
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("error", ex.is_set_type() ? ex.get_type().toString() : "Internal Error");
        body.put("errorMessage", ex.get_msg());
        return builder.entity((Object)JSONValue.toJSONString(body)).type("application/json").build();
    }
}

