/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.Executing;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateFactory;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.slf4j.Logger;

public class CreatingExecutionGraph
implements State {
    private final Context context;
    private final Logger log;

    public CreatingExecutionGraph(Context context, CompletableFuture<ExecutionGraphWithVertexParallelism> executionGraphWithParallelismFuture, Logger log) {
        this.context = context;
        this.log = log;
        FutureUtils.assertNoException((CompletableFuture)executionGraphWithParallelismFuture.handle((executionGraphWithVertexParallelism, throwable) -> {
            context.runIfState(this, () -> this.handleExecutionGraphCreation((ExecutionGraphWithVertexParallelism)executionGraphWithVertexParallelism, (Throwable)throwable), Duration.ZERO);
            return null;
        }));
    }

    private void handleExecutionGraphCreation(@Nullable ExecutionGraphWithVertexParallelism executionGraphWithVertexParallelism, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.log.info("Failed to go from {} to {} because the ExecutionGraph creation failed.", new Object[]{CreatingExecutionGraph.class.getSimpleName(), Executing.class.getSimpleName(), throwable});
            this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.FAILED, throwable));
        } else {
            AssignmentResult result = this.context.tryToAssignSlots(executionGraphWithVertexParallelism);
            if (result.isSuccess()) {
                this.log.debug("Successfully reserved and assigned the required slots for the ExecutionGraph.");
                this.context.goToExecuting(result.getExecutionGraph());
            } else {
                this.log.debug("Failed to reserve and assign the required slots. Waiting for new resources.");
                this.context.goToWaitingForResources();
            }
        }
    }

    @Override
    public void cancel() {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.CANCELED, null));
    }

    @Override
    public void suspend(Throwable cause) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.SUSPENDED, cause));
    }

    @Override
    public JobStatus getJobStatus() {
        return JobStatus.INITIALIZING;
    }

    @Override
    public ArchivedExecutionGraph getJob() {
        return this.context.getArchivedExecutionGraph(this.getJobStatus(), null);
    }

    @Override
    public void handleGlobalFailure(Throwable cause) {
        this.context.goToFinished(this.context.getArchivedExecutionGraph(JobStatus.FAILED, cause));
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    static class ExecutionGraphWithVertexParallelism {
        private final ExecutionGraph executionGraph;
        private final VertexParallelism vertexParallelism;

        private ExecutionGraphWithVertexParallelism(ExecutionGraph executionGraph, VertexParallelism vertexParallelism) {
            this.executionGraph = executionGraph;
            this.vertexParallelism = vertexParallelism;
        }

        public static ExecutionGraphWithVertexParallelism create(ExecutionGraph executionGraph, VertexParallelism vertexParallelism) {
            return new ExecutionGraphWithVertexParallelism(executionGraph, vertexParallelism);
        }

        public ExecutionGraph getExecutionGraph() {
            return this.executionGraph;
        }

        public VertexParallelism getVertexParallelism() {
            return this.vertexParallelism;
        }
    }

    static class Factory
    implements StateFactory<CreatingExecutionGraph> {
        private final Context context;
        private final CompletableFuture<ExecutionGraphWithVertexParallelism> executionGraphWithParallelismFuture;
        private final Logger log;

        Factory(Context context, CompletableFuture<ExecutionGraphWithVertexParallelism> executionGraphWithParallelismFuture, Logger log) {
            this.context = context;
            this.executionGraphWithParallelismFuture = executionGraphWithParallelismFuture;
            this.log = log;
        }

        @Override
        public Class<CreatingExecutionGraph> getStateClass() {
            return CreatingExecutionGraph.class;
        }

        @Override
        public CreatingExecutionGraph getState() {
            return new CreatingExecutionGraph(this.context, this.executionGraphWithParallelismFuture, this.log);
        }
    }

    static final class AssignmentResult {
        private static final AssignmentResult NOT_POSSIBLE = new AssignmentResult(null);
        @Nullable
        private final ExecutionGraph executionGraph;

        private AssignmentResult(@Nullable ExecutionGraph executionGraph) {
            this.executionGraph = executionGraph;
        }

        boolean isSuccess() {
            return this.executionGraph != null;
        }

        ExecutionGraph getExecutionGraph() {
            Preconditions.checkState((boolean)this.isSuccess(), (Object)"Can only return the ExecutionGraph if it is a success.");
            return this.executionGraph;
        }

        static AssignmentResult success(ExecutionGraph executionGraph) {
            return new AssignmentResult((ExecutionGraph)Preconditions.checkNotNull((Object)executionGraph, (String)"AssignmentResult.success expects a non-null ExecutionGraph."));
        }

        static AssignmentResult notPossible() {
            return NOT_POSSIBLE;
        }
    }

    static interface Context {
        public void goToFinished(ArchivedExecutionGraph var1);

        public void goToExecuting(ExecutionGraph var1);

        public void goToWaitingForResources();

        public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus var1, @Nullable Throwable var2);

        public ScheduledFuture<?> runIfState(State var1, Runnable var2, Duration var3);

        public AssignmentResult tryToAssignSlots(ExecutionGraphWithVertexParallelism var1);
    }
}

